dnl Copyright (C) 2004 Gregory C. Sharp, modified from Xplanet
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl This macro defines "HAVE_LOCALE_CHARSET" if you have 
dnl the header file <localcharset.h> and locale_charset() and -lcharset.

AC_DEFUN([SR_FIND_LOCALE_CHARSET],
[
  sr_find_locale_charset=yes
  if test $am_cv_langinfo_codeset = yes; then
    sr_find_locale_charset=no
  fi
  if test $sr_find_locale_charset = yes; then
    AC_CHECK_LIB(charset,locale_charset,
      sr_find_locale_charset=yes,
      sr_find_locale_charset=no)
  fi
  if test $sr_find_locale_charset = yes; then
    AC_CHECK_DECL([locale_charset],
      sr_find_locale_charset=yes,
      sr_find_locale_charset=no,
      [#include <localcharset.h>])
  fi
  if test $sr_find_locale_charset = yes; then
    AC_DEFINE(HAVE_LOCALE_CHARSET, 1,
      [Define if you have locale_charset() in <localcharset.h>.])
    LIBCHARSET="-lcharset"
    AC_SUBST(LIBCHARSET)
  fi
])


AC_DEFUN([SR_TEST_DECL],
[
  AC_CHECK_DECL([aspell_mutable_container_add],
    echo aspell_mutable_container_add found,
    echo aspell_mutable_container_add not found,
    [#include <aspellfoo.h>])
])
