[manpage_begin tepam::doc_gen n 0.5.0]
[copyright {2013, Andreas Drollinger}]
[moddesc {Tcl's Enhanced Procedure and Argument Manager}]
[titledesc {TEPAM DOC Generation, reference manual}]
[category {Documentation tools}]
[require Tcl 8.3]
[require tepam 0.5]
[require tepam::doc_gen [opt 0.1]]

[description]
This package generates documentations of TEPAM procedures (procedures that have been declared with [cmd tepam::procedure]). The documents are generated in the classic UNIX document style using the following document sections: Name, Synopsis, Description, Arguments and Example. [package "TEPAM Doc Gen"] provides support for various document formats. Support for additional formats can be added if necessary. 

[para]
The [package "TEPAM Doc Gen"] package provides the following commands:
[list_begin definitions]
[call [cmd "tepam::doc_gen::generate"] \
   [opt "-format [arg format]"]\
   [opt "-style [arg style]"]\
   [opt "-header_footer"]\
   [opt "-dest_file [arg dest_file]"]\
   [arg name]]

This command generates the documentation for a specified procedure ([arg name]) in one of the supported formats (TXT, HTML, POD (Perl Doc), DT (TclLib DocTool), or in a custom specific format. The format is specified via [opt format]. The flag [opt -header_footer] adds to the documentation file header and footer. If [opt dest_file] is specified the documentation is stored in a file (the file header and footer are added automatically in this case) and the file name is returned. Otherwise the documentation string is returned by [cmd generate].
         
[call [cmd "tepam::doc_gen::patch"] \
   [opt "-format [arg format]"]\
   [opt "-style [arg style]"]\
   [opt "-search_pattern [arg search_pattern]"]\
   [opt "-src_string [arg src_string] | -src_file [arg src_file]"]\
   [opt "-dest_file [arg dest_file]"]\
   [opt name]]

This command inserts procedure documentations into an existing master document at the locations indicated by insertion placeholders which are matching the pattern of [opt search_pattern]. The existing master document is either provided as data to the argument ([opt src_string]) or via a file ([opt src_file]). The final document is returned by [cmd patch] if no destination file is defined ([opt dest_file]). Otherwise, the document is stored in the specified file, and the number of insertion placeholders that could be handled successfully is returned.
[para]
Any insertion placeholders of the master document are handled by default. By defining the argument [opt name] the documentation insertion will be restricted to a particular procedure.
   
[list_end]

[section "ARGUMENTS"]

[list_begin definitions]

[def [opt "-format [arg format]"]]
Specifies the documentation format. [package "TEPAM Doc Gen"] provides support for the following formats:

[list_begin itemized]
[item] TXT - Text format (default)
[item] HTML
[item] POD - Perl Plain Old Documentation format (PerlPOD)
[item] DT - TclLib DocTool format
[list_end]

Section [sectref "ADDING SUPPORT FOR NEW DOCUMENT FORMATS"] shows how support for additional formats can be added.

[def [opt "-style [arg style]"]]
The documentation is by default generated in Tcl style (e.g. [cmd "command arg1 arg2 ..."]). C-style documentation can be generated by setting this argument to 'C' (e.g. [cmd "command(arg1,arg2,...)"]).

[def [opt "-dest_file [arg dest_file]"]]
If [opt dest_file] is defined the documentation is written into the specified destination file. Otherwise the documentation string is returned by the commands [cmd generate] and [cmd patch].
      
[def "[arg name] / [opt name]"]
This is the name of the procedure for which the documentation has to be generated. This is a mandatory argument for [cmd generate], but an optional argument for [cmd patch].

[def [opt "-header_footer"]]
[cmd Generate] adds to the generated procedure documentation the file header and footer only if a file is generated. By selecting the flag [opt "-header_footer"] the header and footer are also generated if the documentation is returned as string by [cmd generate].

[def [opt "-src_string [arg src_string] | -src_file [arg src_file]"]]
[cmd Patch] inserts procedure documentations into an existing document that is either provided as string to the argument ([opt src_string]) or as a file ([opt src_file]). One of these two arguments need to be specified.

[def [opt "-search_pattern [arg search_pattern]"]]
The argument [opt search_pattern] defines the documentation insertion placeholder used in a document. It is a regular expression accepted by [cmd regexp] and needs to contain a parenthesized sub-expression that contains the procedure name for which the documentation needs to be inserted.
[para]
The default insertion placeholder pattern is [emph "\\{!(.*?)!\\}"], which means that the procedure name will be embedded between [emph "\{!"] and [emph "!\}"]. The section [sectref "EXAMPLES"] contains a custom insertion placeholder pattern example.

[list_end]

[section "PREDEFINED DOCUMENT FORMATS"]
[package "TEPAM Doc Gen"] pre-defines the following document formats:

[subsection "TXT - Text format"]
The documentation will be generated in a simple text format if this format is selected. The format can be customized via the following variable:
[list_begin definitions]
[def [var tepam::doc_gen::Option(TXT,MaxLineLength)]]
Default: 80
[para]
This variable defines the line wrapping limit (character position).
[list_end]

[subsection "HTML - HTML format"]
[package "TEPAM Doc Gen"] generates CSS styled HTML files. The HTML documentation can be customized via the following variable:
[list_begin definitions]
[def [var tepam::doc_gen::Option(HTML,CssFile)]]
Default: [file tepam_doc_stylesheet.css]
[para]
This variable specifies the CSS stylesheet file that is referred by the generated HTML files.
[list_end]
The CSS stylesheet can be customized to change the documentation formatting. A good starting point to create a customized CSS stylesheet is to use the CSS file provided by the [package "TEPAM Doc Gen"] example/demo. The HTML documentation uses the following CSS class styles:
[list_begin itemized]
   [item][emph h1.tepam_page_title] - Document page title. Only used by [cmd generate] if a file is created or if the header and footer are built (flag [opt -header_footer] selected).
   [item][emph div.tepam_command_help] - Documentation container. The entire procedure documentation is placed inside this container.
   [item][emph p.tepam_section_title] - Section title (e.g. [emph Name], [emph Synopsis], [emph Description], ...)
   [item][emph p.tepam_sub_section_title] - Sub-section title (used to separate the documentation of multiple sub-procedures)
   [item][emph p.tepam_name] - Name section
   [item][emph p.tepam_synopsis] - Synopsis section
   [item][emph p.tepam_description] - Single description paragraph
   [item][emph ul.tepam_description_list] - Item of a HTML bulleted/unordered list inside the description section
   [item][emph dt.tepam_argument] - Item of a HTML description list used to list the procedure arguments
   [item][emph p.tepam_argument_description] - Argument description paragraph
   [item][emph p.tepam_argument_attribute] - Argument attribute line
   [item][emph pre.tepam_example] - Example section
[list_end]

[subsection "POD - Perl document format"]
The documentation is generated in the Perl Plain Old Documentation format (PerlPOD) if this format is selected.

[subsection "DT - TclLib DocTools format"]
The documentation is generated in the Tcllib DocTools format if this format is selected.

[section "ADDING SUPPORT FOR NEW DOCUMENT FORMATS"]
Support for a new document format can be added by defining in the [namespace tepam::doc_gen] namespace a set of procedures that generate the different document components.
[para]
The following documentation listing contains tokens that refer to the different document generation procedures:

[example "\
[emph {     <01>}]\n\
[emph {<03> <20s>}]   NAME[emph {<20e>}]\n\
[emph {     <30s>}]       message_box - Displays text in a message box[emph {<30e>}]\n\
[emph {     <20s>}]   SYNOPSYS[emph {<20e>}]\n\
[emph {     <40s>}]       message_box \[-mtype <mtype>\] <text>[emph {<40e>}]\n\
[emph {     <20s>}]   DESCRIPTION[emph {<20e>}]\n\
[emph {     <21s>     message_box<21e>}]\n\
[emph {     <54s>       message_box [-mtype <mtype>] <text><54e>}]\n\
[emph {     <50s>}]       This procedure allows displaying a text in an message box. The following\n\
[emph {          }]       message types are supported:[emph {<50e>}]\n\
[emph {<51> <53s>}]       * Info[emph {<53e>}]\n\
[emph {     <53s>}]       * Warning[emph {<53e>}]\n\
[emph {     <53s>}]       * Error[emph {<53e>}]                                           [emph {<52>}]\n\
[emph {     <50s>}]       If the text parameter is use multiple times the different texts are\n\
[emph {          }]       concatenated to create the message text.[emph {<50e>}]\n\
[emph {     <20s>}]   ARGUMENTS[emph {<20e>}]\n\
[emph {<60> <62s>}]       \[-mtype <mtype>\][emph {<62e>}]\n\
[emph {<63> <65s>}]          Message type[emph {<65e>}]\n\
[emph {     <66s>}]          Default: \"Warning\"[emph {<66e>}]\n\
[emph {     <66s>}]          Multiple: yes[emph {<66e>}]\n\
[emph {     <66s>}]          Choices: Info, Warning, Error[emph {<66e>}]                  [emph {<64>}]\n\
[emph {     <62s>}]       <text>[emph {<62e>}]\n\
[emph {<63> <65s>}]          One or multiple text lines to display[emph {<65e>}]\n\
[emph {     <66s>}]          Type: string[emph {<66e>}]\n\
[emph {     <66s>}]          Multiple: yes[emph {<66e>}]                                  [emph {<64><61>}]\n\
[emph {     <20s>}]   EXAMPLE[emph {<20e>}]\n\
[emph {<70> <72s>}]       message_box \"Please save first the document\"[emph {<72e>}]\n\
[emph {     <73s>}]       -> 1[emph {<73e>}]                                              [emph {<71><04>}]\n\
[emph {     <02>}]"]

There are 2 types of document generation procedures: 
[list_begin definitions]
   [def "Content generation procedures (e.g. <40s>...<40e>)"]
      These procedures generate some document content based on the text that is provided as procedure argument. The listing above shows two tokens for these procedures to indicate the beginning and the end of the generated content. 
   [def "Control generation procedures (e.g. <03>)"]
      These procedures generate control constructs, for example to generate the prolog code and epilog code for lists, sections, etc. These procedures have no argument.
[list_end]

The following set of procedures needs to be defined to provide support for a new document format:

[list_begin definitions]
[def "[emph 01] - [cmd gen(\$Format,Header)] {[arg Text]}"]
   Only called if [cmd doc_gen] generates a file or if it is called with the flag [opt -header_footer]. The procedure creates the file header. The provided parameter is the procedure name for which the documentation has to be generated.
[def "[emph 02] - [cmd gen(\$Format,Footer)] {[arg Text]}"]
   Only called if [cmd doc_gen] generates a file or if it is called with the flag [opt -header_footer]. The procedure creates the file footer.
[def "[emph 03] - [cmd gen(\$Format,Begin)] {}"]
   Generates the documentation prolog (preamble)
[def "[emph 04] - [cmd gen(\$Format,End)] {}"]
   Generates the documentation epilog

[def "[emph 20] - [cmd gen(\$Format,SectionTitle)] {[arg Text]}"]
   Generates a section title (e.g. [emph Name], [emph Synopsis], [emph Description], ...). The raw title text is provided as parameter
[def "[emph 21] - [cmd gen(\$Format,SubSectionTitle)] {[arg Text]}"]
   Generates a sub-section title. Sub-sections are used if a single documentation is generated for multiple sub-commands to make a separation between them. The raw title text is provided as parameter

[def "[emph 30] - [cmd gen(\$Format,Name)] {[arg Text]}"]
   Generates the name section (without title). The raw section text is provided as parameter.

[def "[emph 40] - [cmd gen(\$Format,Synopsis)] {[arg Text]}"]
   Generates the synopsis section (without title). The section text provided as parameter is pre-formatted (the argument strings are generated by [cmd "gen(\$Format,ArgumentString)"]).

[def "[emph 50] - [cmd gen(\$Format,Description)] {[arg Text]}"]
   Generates a description paragraph. The raw paragraph text is provided as parameter.
[def "[emph 51] - [cmd gen(\$Format,DescriptionListBegin)] {}"]
   Generates the prolog of a bulleted/unordered list inside the description section. This prolog is usually the start code of a list structure.
[def "[emph 52] - [cmd gen(\$Format,DescriptionListEnd)] {}"]
   Generates the epilog of a bulleted/unordered list inside the description section. This epilog is usually the end code of a list structure.
[def "[emph 53] - [cmd gen(\$Format,DescriptionListItem)] {[arg Text]}"]
   Generates a text item in a bulleted/unordered description list. The raw item text is provided as parameter.
[def "[emph 54] - [cmd gen(\$Format,DescriptionSynopsis)] {[arg Text]}"]
   Generates the synopsis line on the beginning of the description section. The command can return an empty string if no synopsys line is required at this place.[para]
   Some formats (e.g. Tcl DocTools) require that the synopsis line is defined in the description section, to build then automatically the synopsis section. The section text provided as parameter is pre-formatted (the argument strings are generated by [cmd "gen(\$Format,ArgumentString)"]).

[def "[emph 60] - [cmd gen(\$Format,ArgumentListBegin)] {}"]
   Generates the prolog of argument list (definition/non-bulleted list). This prolog is usually the start code of a definition list.
[def "[emph 61] - [cmd gen(\$Format,ArgumentListEnd)] {}"]
   Generates the epilog of the argument list. This epilog is usually the end string of a list structure.
[def "[emph 62] - [cmd gen(\$Format,ArgumentListItem)] {Name IsOptional IsNamed Type}"]
      Generates an argument item line inside the argument list. This command can rely on [cmd gen(\$Format,ArgumentDetailBegin)] since the parameters are identical.
[def "[emph 63] - [cmd gen(\$Format,ArgumentDetailBegin)] {}"]
   Generates the argument details prolog (preamble).
[def "[emph 64] - [cmd gen(\$Format,ArgumentDetailEnd)] {}"]
   Generates the argument details epilog
[def "[emph 65] - [cmd gen(\$Format,ArgumentDescription)] {[arg Text]}"]
   Generates the argument description (single paragraph).
[def "[emph 66] - [cmd gen(\$Format,ArgumentAttribute)] {[arg Text]}"]
   Generates a single argument attribute string. The command is called individually for each attribute.

[def "[emph 70] - [cmd gen(\$Format,ExampleBegin)] {}"]
   Generates the example section prolog (preamble)
[def "[emph 71] - [cmd gen(\$Format,ExampleEnd)] {}"]
   Generates the example section epilog
[def "[emph 72] - [cmd gen(\$Format,ExampleCommandLine)] {[arg Text]}"]
   Generates a single command line in the example section. The command is called for each individual command line.
[def "[emph 73] - [cmd gen(\$Format,ExampleResultLine)] {[arg Text]}"]
   Generates a command result line

[def "[emph 80] - [cmd gen(\$Format,ArgumentString)] {Name IsOptional IsNamed Type}"]
   Generates the part of the command line or the synopsis that is specific to an argument. The generated string has to indicate if an argument is optional, named and if it is a flag.
   [para]
   The following parameters are provided to this procedure:
   [list_begin definitions]
   [def [arg "Name"]]
      Name of the argument
   [def [arg "IsOptional"]]
      If true (=[const 1]) the argument is optional which should be indicated by the generated string (for example by putting the argument into brackets {[lb][rb]} or into question marks '?'):
      [example_begin]gen(TXT,ArgumentString) mtype 1 0 string -> [emph {"[mtype]"}][example_end]
   [def [arg "IsNamed"]]
      If true (=[const 1]) an argument is a named argument (option). The generated string should in this case contain the argument/option name, followed by the argument itself:
      [example_begin]gen(TXT,ArgumentString) mtype 0 1 string -> [emph {"-mtype <mtype>"}][example_end]
      Named arguments can also be optional:
      [example_begin]gen(TXT,ArgumentString) mtype 1 1 string -> [emph {"[-mtype <mtype>]"}][example_end]
   [def [arg "Type"]]
      Indicates the type of the argument. If the type is set to [const none] the argument is a flag, which needs to be indicated by the generated string. Example:
      [example_begin]gen(TXT,ArgumentString) close 1 1 none -> [emph {"[-close]"}][example_end]
   [list_end]
[list_end]

[section "EXAMPLES"]
[subsection tepam::doc_gen::generate]
The [package "TEPAM Doc Gen"] package can be explored by generating the documentation of the command [cmd tepam::doc_gen::generate]. The following example generates the document in text format (default format):
[example "[cmd tepam::doc_gen::generate] tepam::doc_gen::generate"]
The next example generates the documentation in HTML format:
[example "[cmd tepam::doc_gen::generate] -format HTML tepam::doc_gen::generate"]
The flag [opt header_footer] adds also the file header and footer:
[example "[cmd tepam::doc_gen::generate] -format HTML -header_footer tepam::doc_gen::generate"]
The documentation can directly be stored in a file. The file header and footer are automatically generated in this way:
[example "[cmd tepam::doc_gen::generate] -format HTML -dest_file doc_gen.html tepam::doc_gen::generate"]
The generated HTML file refers a CSS stylesheet file (default: tepam_doc_stylesheet.css). To display the HTML file correctly this CSS stylesheet file needs to be copied into the directory of the generated HTML file.
[para]
The Tcl DOC Tools format can be used as intermediate format to generate other formats, for example HTML:
[example_begin]
[emph {# Generate the documentation in Tcl Doc Tool format}]
set dt [lb][cmd tepam::doc_gen::generate] -format DT -header_footer tepam::doc_gen::generate[rb]
[emph {}]
[emph {# Create a new doc tools object (HTML format)}]
package require doctools
::doctools::new myDoc -format html
[emph {}]
[emph {# Open the HTML file, and write the HTML formatted documentation}]
set fHtml [lb]open doc_gen.dt.html w[rb]
puts $fHtml [lb]myDoc format $dt[rb]
close $fHtml
[example_end]

[subsection tepam::doc_gen::patch]
While [cmd generate] provides a limited number of possibilities to vary the document structure, [cmd patch] offers more flexibility. Multiple documentations for different procedures and meta information can for example be added.
[para]
The following listing shows how the [cmd patch] command works. It defines first a HTML master document string that contains 2 procedure documentation placeholders ([emph "{*<ProcedureName>*}"]). There placeholders are replaced by [cmd patch] with the generated documentation of the referred procedures. Since nonstandard placeholders are used, [cmd patch] is called with an explicit placeholder pattern definition (argument [arg search_pattern]).
[example_begin]
[emph {# Define the HTML master document}]
set HtmlMasterDoc {\
<html>
  <head>
    <title>tepam::doc_gen</title>
    <link rel="stylesheet" href="tepam_doc_stylesheet.css">
    <meta content="documentation" name="keywords"></meta>
  </head>
  <body>
    <h1>tepam::doc_gen</h1>
      <h2>Generate</h2>
[cmd {{*tepam::doc_gen::generate*}}]
      <h2>Patch</h2>
[cmd {{*tepam::doc_gen::patch*}}]
  </body>
<html>\
}
[emph {}]
[emph {# Patch the master document: This will replace the placeholders by the 
# procedure documentation divisions:}]
[cmd tepam::doc_gen::patch] -format HTML -search_pattern {\{\*(.*?)\*\}} \
                      -src_string $HtmlMasterDoc -dest_file tepam_doc_gen.html
[example_end]

[see_also tepam(n) tepam::procedure(n)]
[keywords documentation {procedure documentation} {automatic documentation}]
[manpage_end]
