/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#include "Help.hpp"

#include "../meta.hpp"

#include "wx/stdpaths.h"
#include "wx/msgdlg.h"
#include "wx/fs_arc.h"
#include "wx/fs_zip.h"
#include "wx/html/helpdlg.h"

#include <vector>

using namespace indii;

wxHtmlHelpController* Help::help = NULL;
bool Help::haveHelp = false;

#ifdef __WXMSW__
#define HELP_FLAGS wxHF_DEFAULT_STYLE&~wxHF_BOOKMARKS&~wxHF_INDEX
// ^ wxHF_MERGE_BOOKS starts with contents expanded, but causing errors on Windows
#elif defined(__WXOSX__)
#define HELP_FLAGS wxHF_DEFAULT_STYLE&~wxHF_BOOKMARKS&~wxHF_INDEX&~wxHF_PRINT&~wxHF_TOOLBAR&~wxHF_MENU
#else
#define HELP_FLAGS wxHF_DEFAULT_STYLE&~wxHF_BOOKMARKS&~wxHF_INDEX
#endif

void Help::init(wxWindow* parent) {
  help = new wxHtmlHelpController(HELP_FLAGS, parent);
  if (!haveHelp) {
    wxFileSystem::AddHandler(new wxArchiveFSHandler()); // for *.htb file
    
    std::vector<wxFileName> files;
    files.push_back(wxFileName(_(PACKAGE_TARNAME ".htb")));
    files.push_back(wxFileName(wxString("help", wxConvUTF8) << wxFileName::GetPathSeparator() << _(PACKAGE_TARNAME) << _(".htb")));
    files.push_back(wxFileName(wxStandardPaths::Get().GetResourcesDir(), _(PACKAGE_TARNAME ".htb")));
    files.push_back(wxFileName(wxStandardPaths::Get().GetResourcesDir() << wxFileName::GetPathSeparator() << _("Plug-Ins"), _(PACKAGE_TARNAME ".htb")));
    #ifdef __WXMSW__
    /* support shortcuts to these files also */
    files.push_back(wxFileName(wxStandardPaths::Get().GetResourcesDir(), _(PACKAGE_TARNAME ".htb.lnk")));
    files.push_back(wxFileName(wxStandardPaths::Get().GetResourcesDir() << wxFileName::GetPathSeparator() << _("Plug-Ins"), _(PACKAGE_TARNAME "htb.lnk")));
    #endif
    #ifdef __WXOSX__
    /* for plugin */
    files.push_back(wxFileName(wxStandardPaths::Get().GetResourcesDir() << _("/../../../Plug-ins/" PACKAGE_TARNAME ".plugin/Contents/Resources"), _(PACKAGE_TARNAME ".htb")));
    files.push_back(wxFileName(_("/Applications/indii.org/" PACKAGE_TARNAME ".htb")));
    #endif
    #ifdef __WXGTK__
    /* datadir from autoconf */
    files.push_back(wxFileName(_(DATADIR)));
    #endif
    std::vector<wxFileName>::iterator iter;
    for (iter = files.begin(); iter != files.end() && !haveHelp; ++iter) {
      iter->Normalize(); // follow shortcuts etc
      if (iter->IsOk() && iter->FileExists()) {
        haveHelp = help->AddBook(*iter);
      }
    }
  }
}

void Help::term() {
  help->Quit();
  help = NULL;
  haveHelp = false;
}

void Help::show(const int section) {
  if (haveHelp) {
    help->Display(section);
    //help->GetDialog()->Show();
    //help->Raise();
    //help->SetFocus();
		//#if defined(__WXOSX__) && defined(__PLUGIN__)
    /* in Photoshop CS5, menus and toolbars obscure help window, and so can't
     * close it, make sure it won't be obscured */
    //int x, y;
    //help->GetScreenPosition(&x, &y);
    //if (x < 40 || y < 120) {
    //  x = std::max(40, x);
    //  y = std::max(120, y);
    //  help->Move(x, y);
    //}
		//#endif
  } else {
    wxMessageBox(wxString("The online help system could not be loaded.\n\nMake sure "
        "that the " PACKAGE_TARNAME ".htb file is in the "
        #ifdef WX_28
        , wxConvUTF8
        #endif
        ) << wxStandardPaths::Get().GetResourcesDir() <<
        _(" directory, and restart " PACKAGE_NAME "."),
        _("Error"), wxOK|wxICON_HAND, NULL);
  }
}
