/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#ifndef INDII_TINT_GUI_POSTPROCESSPANE_HPP
#define INDII_TINT_GUI_POSTPROCESSPANE_HPP

#include "../model/ClusterModel.hpp"
#include "../model/ClusterModelObserver.hpp"
#include "../../gui/Pane.hpp"

#include "wx/slider.h"

namespace indii {
/**
 * Postprocess settings pane.
 */
class PostProcessPane : public Pane, public ClusterModelObserver {
public:
  /**
   * Constructor.
   *
   * @param parent Parent.
   */
  PostProcessPane(wxWindow* parent);

  /**
   * Set model.
   *
   * @param model Model.
   */
  void setModel(ClusterModel* model);

  /*
   * Handle model changes.
   */
  virtual void notifySaturationDecayChange();
  virtual void notifySaturationSoftnessChange();
  virtual void notifyIsHardChange();
  
  /*
   * Slider control events.
   */
  void OnSlideSatDecay(wxScrollEvent& evt);
  void OnSlideSatSoft(wxScrollEvent& evt);
  void OnSlideHard(wxScrollEvent& evt);
  
  /**
   * Context sensitive help.
   */
  void OnHelp(wxHelpEvent& evt);
  
private:
  /**
   * Cluster model.
   */
  ClusterModel* model;

  /*
   * Slider controls.
   */ 
  wxSlider *slideSatDecay, *slideSatSoft, *slideHard;

  /*
   * Slider control ids.
   */
  enum ID {
    ID_SLIDE_SAT_DECAY,
    ID_SLIDE_SAT_SOFT,
    ID_SLIDE_HARD
  };

  DECLARE_EVENT_TABLE()

};
}

#endif
