[vset VERSION 1.1.0]
[comment {-*- mode: tcl; fill-column: 80 -*- doctools manpage}]
[manpage_begin shtmlview n [vset VERSION]]
[see_also text]
[keywords text]
[keywords html]
[keywords widget]
[copyright {2018-2022, Detlef Groth <detlef(at)dgroth(dot)de>}]
[copyright {2009, Robert Heller}]
[copyright {2000, Clif Flynt}]
[copyright {1995-1999, Stephen Uhler}]

[moddesc   {Basic HTML and Markdown viewer widget}]
[titledesc {Extended Tcl/Tk text widget with basic support for rendering of HTML and Markdown}]
[require Tk]
[require snit]
[require "Markdown ;# optional Markdown support"]
[require "img::jpeg ;# optional jpeg image support"]
[require shtmlview::shtmlview [opt [vset VERSION]]]

[description]

The [package shtmlview::shtmlview] package provides a pure Tcl/Tk
widget of the same name to render and display basic HTML and Markdown
files and string.

[para]

Some history: The widget is based on the [package htmllib] library
developed in the 90ties by Stephen Uhler and Clif Flynt.

In 2009 Robert Heller wrapped this library into the excellent
mega-widget framework [package snit].

The resulting widget was however tied directly into a help system.

The author of this document first just isolated the display part and
then added some functions such as changing font size and a few buttons
in the toolbar. Then a rudimentary display of data tables was
added. Even later support for inline images and extended keybindings
and Markdown support was added.

[para]

The widget is [emph not] a web browser. It only supports relative
links in the local filesystem.  It does [emph not] support style
sheets. It does not support http(s) links nor images.

It is thought of as a last fallback to use in cases where no other
possibilities exists to display HTML or Markdown markup from a Tk
application.

[para]

Use cases are as a help viewer and wherever the developer has control
about the used html tags.

[para]
Comments and feedbacks are welcome.

[para]
The [cmd shtmlview::shtmlview] widget overloads the text widget and
provides new commands and options.

These are explained in the sections [sectref {WIDGET COMMANDS}] and
[sectref {WIDGET OPTIONS}].

[para]

Note that the file [file shtmlview.tcl] is not only a package but also
a standalone application for the direct viewing of Markdown and HTML
files.

Invoke it as [example { tclsh shtmlview.tcl filename.html }] in a terminal.

[para]

The API described in this document is not the whole API offered by the snit
object [cmd ::shtmlview::shtmlview].

Instead, it is the subset of that API that is expected not to change in future
versions.

[section COMMANDS]

[list_begin definitions]

[call [cmd ::shtmlview::converter] [arg extension] [arg description] [arg cmdprefix]]

Registers a conversion command prefix ([arg cmdprefix]) for files
having the [arg extension].

The [arg description] is a short summary of the kind of files expected
to have that extension.

[para]

The result of the command is the empty string.

[para]

Whenever an shtmlview widget encounters a file with the specified
[arg extension] it will invoke the registered command prefix with one
argument, the path to the file to convert. The result of the
invokation is expected to be the HTML to render and display.

[para]

See section [sectref EXTENSIONS] for an example.

[call [cmd ::shtmlview::shtmlview] [arg pathName] [opt [arg options]]]

Creates and configures the shtmlview widget [arg pathName].

[para]	The result of the command is the [arg pathName].

[para]	An error is thrown if a widget for [arg pathName] already exists.

[para]	An error is also thrown if the parent for [arg pathName] does not exist.

[para]	The recognized options are explained in section [sectref {WIDGET OPTIONS}].

[para]	The methods of the new widget are explained in section [sectref {WIDGET COMMANDS}].

[list_end]

[section {WIDGET OPTIONS}]

[para]

Use method [method helptext] to configure the internal text widget.

[list_begin options]

[opt_def -browsecmd cmd]

Each time a HTML or Markdown page is rendered the specified [arg cmd]
command is invoked. The actual URL is appended as first argument to
the command.

[opt_def -closebutton boolean]

If [const true] (default) a close button is shown in the toolbar.

This is useful if the widget is the sole child of a toplevel widget.

[opt_def -historycombo boolean]

If [const true], and the [package tile] package is available, then a
[widget ttk::combobox] to show page history is added to the toolbar.

Defaults to [const false].

Can be only set at widget creation.

[opt_def -home string]

Sets the homepage filename of the widget.

If not set, the first page browsed to will be automatically set as the
home page.

[opt_def -tablesupport boolean]

If [const true] (default) some table support is provided.

This will have some undesired results if table tags are misused as
markup tool.

Simple html tables with [const th] and [const td] tags should however
display well if no internal markup inside of those tags is used.

[opt_def -toolbar boolean]

If [const true] (default) a toolbar will be displayed at the top.

The toolbar will provide standard buttons for the methods [method back],
[method forward] and [method home], as well as search facilities.

Defaults to [const true].

[list_end]

[section {WIDGET COMMANDS}]

Each shtmlview widget created with the above command supports the following
commands and options:

[list_begin definitions]

[call [arg pathName] [method back]]

Displays the previous HTML and Markdown page in the browsing history
if any.

[call [arg pathName] [method browse] [arg filename] [opt args]]

Displays the HTML or Markdown text contained in the named file.

Any additional arguments, while also file names, are just added to the
history stack.

They can be walked to using the history keys, [const f] and [const b].

[call [arg pathName] [method dosearch] [arg string] [arg direction]]

Search for and highlight the given string starting from the current
index in the specified direction. The direction has to be either
[const forward] (default) or [const backwards].

[call [arg pathName] [method edittext] [arg cmd] [opt [arg options]]]

This command exposes the internal text editor widget for
configuration. See the following example:

[example {
    ::shtmlview::shtmlview .help
    .help browse index.md
    .help editView
    .help edittext configure -background salmon
}]

[call [arg pathName] [method editView]]

This command switches the widget from viewing to editing.  In this
mode the user is able to edit and change the currently loaded file.

To switch to a non-editable source display instead see
[method sourceView] below.

[example {
    ::shtmlview::shtmlview .help
    .help browse index.md
    .help editView
}]

[call [arg pathName] [method forward]]

Displays the next HTML or Markdown page in the browsing history if
any.

[call [arg pathName] [method getFiles]]

This command returns a list of all visited files.

Duplicates and anchor links are removed from the raw data.

[call [arg pathName] [method getHistory]]

This command returns a list of the current history of visited files
and anchors.

[call [arg pathName] [method getEditWidget]]

This commands returns the internal pathname of the text editor widget
used for editing the current document.

This enables the developer to directly access it, if required or desired.

This is dangerous.

See also [method edittext], above.

[call [arg pathName] [method getTextWidget]]

This commands returns the internal pathname of the internal viewer
text widget.

This enables the developer to directly access it, if required or
desired.

This is dangerous.

See also [method helptext], below.

[call [arg pathName] [method helptext] [arg cmd] [opt [arg options]]]

This command exposes the internal viewer text widget for
configuration. See the following example:

[example {
    ::shtmlview::shtmlview .help
    .help browse index.html
    .help helptext configure -background yellow
}]

[call [arg pathName] [method home]]

Displays either the page set by option [option -home], or the first
page [method browse] was called for.

[call [arg pathName] [method open]]

Uses a standard file open dialog to select a document in any of the
supported formats for display, and then renders that file, if any.

[call [arg pathName] [method reload]]

Reloads and redisplays the currently shown page.

[call [arg pathName] [method render] [arg text] [opt ext]]

Renders the given [arg text] in the viewer.

If an extension [arg ext] is specified the string is assumed to be in
the associated format, and the associated converter is used.

Otherwise the string is considered to be either HTML or Markdown.  To
be treated as HTML the [arg text] has to start with a recognized HTML
tag. In any other case it is considered to be Markdown.

[call [arg pathName] [method sourceView]]

This command switches the widget from viewing the current document
itself to viewing the source of that document. To switch to a editable
source display see [method editView] above.

[example {
    ::shtmlview::shtmlview .help
    .help browse index.md
    .help sourceView
}]

[call [arg pathName] [method url]]

Returns the currently shown URL.

[list_end]

[section "BINDINGS FOR THE WIDGET"]

The following keys are bound to the widget for navigation and other
actions:

[list_begin definitions]
[def <cursor>] Standard cursor movement in the view
[def b] Back - display previous page in history
[def f] Forward - display next page in history
[def p] Previous - Move cursor to previous search match
[def n] Next - Move cursor to next search match
[def q] Remove current page from history. Implies [const f].
[def r] Start search backward
[def s] Start search forward
[def Ctrl-E] Toggle edit mode
[def Ctrl-s] In edit mode, save page
[def Ctrl-r] Reload current page
[def Ctrl-u] Toggle source vs rendered views
[def Return] Follow link under cursor
[def TAB] Move cursor to next link on current page
[list_end]

[section EXAMPLE]

[example {
    package require shtmlview::shtmlview
    proc browsed {url} {
        puts "You browsed $url"
    }
    ::shtmlview::shtmlview .help -toolbar true -browsecmd browsed
    .help browse index.html
    pack .help -fill both -expand true -side left
    package require Markdown
    .help browser test.md
}]

More examples can be found in the sources of the package.

[section EXTENSIONS]

[para]

While the package natively only support HTML documents, and Markdown
documents if the supporting [package Markdown] package is available,
it is possible to extend the range of supported formats by means of a
plugin mechanism.

[para]

The main entry point to that system is the [cmd shtmlview::converter]
command. With it is possible to register a document format and an
associated conversion command.

The format is identified by its file extension, like, for example
[file .md], [file .man], etc.

The conversion command is expected to convert the content of the file
given to it into HTML for display.

[para]

The packages [package shtmlview::doctools] and
[package shtmlview::mkdoc] are examples of such plugins.

The first provides support for the [term doctools] format used by both
[term Tcllib] and [term Tklib] for their manpages, while the second
provides support for [term mkdoc]-enhanced Tcl source files. In other
words, Tcl files with embedded documentation in [term mkdoc] syntax.

[para]

Enclosed below the bare Tcl code of the [package shtmlview::mkdoc]
package:

[example {
    package require shtmlview::shtmlview
    package require mkdoc::mkdoc

    ::shtmlview::converter .tcl {Tcl+mkdoc files}   ::shtmlview::mkdoc
    ::shtmlview::converter .tm  {Tcl+mkdoc modules} ::shtmlview::mkdoc

    proc ::shtmlview::mkdoc {url} {
	close [file tempfile htmltemp .html]

	mkdoc::mkdoc $url $htmltemp -html

	if {[catch {
	    open $htmltemp r
	} result]} {
	    return -code error "Cannot open $url: $result"
	}

	set html [read $result]
	close $result
	file delete $htmltemp

	return $html
    }

    package provide shtmlview::mkdoc 0.1
}]

[para]

It is of course possible to write plugins which use an external
application like [syscmd pandoc] to generate the HTML to render,
instead of a Tcl package.

[para]

And it is of course also possible to register conversion commands
directly from the application using this package, instead of going
through a separate package.

[section CHANGELOG]

[list_begin definitions]

[def {2022-02-25 version 0.9.2}]

[list_begin itemized]
[item] Fix for [cmd tk_textCopy] and documentation update
[list_end]

[def {2022-03-06 version 0.9.3}]

[list_begin itemized]

[item] Support for MouseWheel bindings
[item] Fixing hyperlinks to http(s) links
[item] Support for file-anchor links like [const file.html#anchor]
[item] Support for [const #] as link to the top
[item] Thanks to aplsimple for suggestions and bug reports
[list_end]

[def {2022-03-26 version 1.0.0}]

[list_begin itemized]

[item] HTML 3.2 tags div, sub, sup, small, big
[item] Initial support for Markdown files
[item] Initial support for base64 encoded inline image files
[item] Support for JPEG images if the [package img::jpeg] package is available
[item] Support for SVG images if either [cmd critcl] and [term librsvg-dev(el)] or terminal application [syscmd rsvg-convert] or [syscmd cairosvg] are available
[item] Back and forward as well for anchors
[item] First and last browse entry buttons for history
[item] History with full file path to allow directory changes
[item] Improved usage line and install option
[item] Keyboard bindings for next and previous search
[item] Return and tab for links
[item] Historycombo option
[item] Toolbar fix
[item] Browse fix for non-existing files
[item] Removed unused css/stylesheet and web forms code
[item] Thanks to pepdiz for bug-reports and suggestions
[list_end]

[def {2022-04-XX version 1.1.0}]

[list_begin itemized]
[item] Keybinding Ctrl-u to source view for HTML and Markdown files
[item] Keybinding Ctrl-Shift-e to use a simple text editor for file editing
[item] File open dialog now remembers the last directory and the last file extension
[item] File close button added with option -closebutton, useful for toplevel windows
[item] Some backslash fixes for Markdown links
[item] Adding span tag for styling
[item] Adding render method to read HTML directly without filename
[item] Adding plugin structure for additional file types like Tcllib doctools, or mkdoc
[item] Tcl doctools support resides in its own package
[item] Tcl mkdoc supports resides in its own package
[list_end]

[list_end][comment {-- definitions}]

[section TODO]

[list_begin itemized]
[item] Markdown rendering using tcllib package [package Markdown] in case an URL ends with [file .md] (done)
[item] Support for SVG images for instance using [uri https://wiki.tcl-lang.org/page/svgconvert svgconvert], at least on Linux/Windows
[item] More tags, see tag history add 3.2 tags: [uri http://www.martinrinehart.com/frontend-engineering/engineers/html/html-tag-history.html] (done)
[item] Source view using Ctrl-u (done)
[item] Edit view using Ctrl-Shift-e
[item] Fixing mouse wheel issues
[list_end]

[section Thanks]

Stephen Uhler, Clif Flynt and Robert Heller, they provided the majority of the code in this widget.

[section "Bugs, Ideas, Feedback"]

This document, and the package it describes, will undoubtedly contain bugs and
other problems. Please report such to the author of this package. Please also report any ideas for enhancements you may have for
either package and/or documentation.

[section "Code Copyright"]

BSD License type:

[para]

Sun Microsystems, Inc.  The following terms apply to all files a
ssociated with the software unless explicitly disclaimed in individual
files.

[para]

The authors hereby grant permission to use, copy, modify, distribute,
and license this software and its documentation for any purpose,
provided that existing copyright notices are retained in all copies
and that this notice is included verbatim in any distributions. No
written agreement, license, or royalty fee is required for any of the
authorized uses.  Modifications to this software may be copyrighted by
their authors and need not follow the licensing terms described here,
provided that the new terms are clearly indicated on the first page of
each file where they apply.

[para]

In no event shall the authors or distributors be liable to any party
for direct, indirect, special, incidental, or consequential damages
arising out of the use of this software, its documentation, or any
derivatives thereof, even if the authors have been advised of the
possibility of such damage.

[para]

The authors and distributors specifically disclaim any warranties,
including, but not limited to, the implied warranties of
merchantability, fitness for a particular purpose, and
non-infringement.

This software is provided on an "as is" basis, and the authors and
distributors have no obligation to provide maintenance, support,
updates, enhancements, or modifications.

[para]

RESTRICTED RIGHTS: Use, duplication or disclosure by the government is
subject to the restrictions as set forth in subparagraph (c) (1) (ii)
of the Rights in Technical Data and Computer Software Clause as DFARS
252.227-7013 and FAR 52.227-19.

[vset CATEGORY shtmlview]

[manpage_end]
