/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.CodeAttributeComposer;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionUtil;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;

public class CompactCodeAttributeComposer
extends SimplifiedVisitor
implements AttributeVisitor {
    private final ConstantPoolEditor constantPoolEditor;
    private final CodeAttributeComposer codeAttributeComposer;

    public CompactCodeAttributeComposer(ProgramClass programClass) {
        this(programClass, false, false, true);
    }

    public CompactCodeAttributeComposer(ProgramClass programClass, boolean bl, boolean bl2, boolean bl3) {
        this.constantPoolEditor = new ConstantPoolEditor(programClass);
        this.codeAttributeComposer = new CodeAttributeComposer(bl, bl2, bl3);
    }

    public CompactCodeAttributeComposer reset() {
        this.codeAttributeComposer.reset();
        return this;
    }

    public CompactCodeAttributeComposer beginCodeFragment(int n) {
        this.codeAttributeComposer.beginCodeFragment(n);
        return this;
    }

    public CompactCodeAttributeComposer appendInstruction(int n, Instruction instruction) {
        this.codeAttributeComposer.appendInstruction(n, instruction);
        return this;
    }

    public CompactCodeAttributeComposer appendLabel(int n) {
        this.codeAttributeComposer.appendLabel(n);
        return this;
    }

    public CompactCodeAttributeComposer appendInstructions(Instruction[] instructionArray) {
        this.codeAttributeComposer.appendInstructions(instructionArray);
        return this;
    }

    public CompactCodeAttributeComposer appendInstruction(Instruction instruction) {
        this.codeAttributeComposer.appendInstruction(instruction);
        return this;
    }

    public CompactCodeAttributeComposer appendException(ExceptionInfo exceptionInfo) {
        this.codeAttributeComposer.appendException(exceptionInfo);
        return this;
    }

    public int insertLineNumber(LineNumberInfo lineNumberInfo) {
        return this.codeAttributeComposer.insertLineNumber(lineNumberInfo);
    }

    public int insertLineNumber(int n, LineNumberInfo lineNumberInfo) {
        return this.codeAttributeComposer.insertLineNumber(n, lineNumberInfo);
    }

    public CompactCodeAttributeComposer appendLineNumber(LineNumberInfo lineNumberInfo) {
        this.codeAttributeComposer.appendLineNumber(lineNumberInfo);
        return this;
    }

    public CompactCodeAttributeComposer endCodeFragment() {
        this.codeAttributeComposer.endCodeFragment();
        return this;
    }

    public CompactCodeAttributeComposer nop() {
        return this.add(new SimpleInstruction(0));
    }

    public CompactCodeAttributeComposer aconst_null() {
        return this.add(new SimpleInstruction(1));
    }

    public CompactCodeAttributeComposer iconst(int n) {
        return this.add(new SimpleInstruction(3, n));
    }

    public CompactCodeAttributeComposer iconst_m1() {
        return this.add(new SimpleInstruction(2));
    }

    public CompactCodeAttributeComposer iconst_0() {
        return this.add(new SimpleInstruction(3));
    }

    public CompactCodeAttributeComposer iconst_1() {
        return this.add(new SimpleInstruction(4));
    }

    public CompactCodeAttributeComposer iconst_2() {
        return this.add(new SimpleInstruction(5));
    }

    public CompactCodeAttributeComposer iconst_3() {
        return this.add(new SimpleInstruction(6));
    }

    public CompactCodeAttributeComposer iconst_4() {
        return this.add(new SimpleInstruction(7));
    }

    public CompactCodeAttributeComposer iconst_5() {
        return this.add(new SimpleInstruction(8));
    }

    public CompactCodeAttributeComposer lconst(int n) {
        return this.add(new SimpleInstruction(9, n));
    }

    public CompactCodeAttributeComposer lconst_0() {
        return this.add(new SimpleInstruction(9));
    }

    public CompactCodeAttributeComposer lconst_1() {
        return this.add(new SimpleInstruction(10));
    }

    public CompactCodeAttributeComposer fconst(int n) {
        return this.add(new SimpleInstruction(11, n));
    }

    public CompactCodeAttributeComposer fconst_0() {
        return this.add(new SimpleInstruction(11));
    }

    public CompactCodeAttributeComposer fconst_1() {
        return this.add(new SimpleInstruction(12));
    }

    public CompactCodeAttributeComposer fconst_2() {
        return this.add(new SimpleInstruction(13));
    }

    public CompactCodeAttributeComposer dconst(int n) {
        return this.add(new SimpleInstruction(14, n));
    }

    public CompactCodeAttributeComposer dconst_0() {
        return this.add(new SimpleInstruction(14));
    }

    public CompactCodeAttributeComposer dconst_1() {
        return this.add(new SimpleInstruction(15));
    }

    public CompactCodeAttributeComposer bipush(int n) {
        return this.add(new SimpleInstruction(16, n));
    }

    public CompactCodeAttributeComposer sipush(int n) {
        return this.add(new SimpleInstruction(17, n));
    }

    public CompactCodeAttributeComposer ldc(int n) {
        return this.ldc_(this.constantPoolEditor.addIntegerConstant(n));
    }

    public CompactCodeAttributeComposer ldc(float f) {
        return this.ldc_(this.constantPoolEditor.addFloatConstant(f));
    }

    public CompactCodeAttributeComposer ldc(String string) {
        return this.ldc(string, null, null);
    }

    public CompactCodeAttributeComposer ldc(Object object) {
        return this.ldc_(this.constantPoolEditor.addPrimitiveArrayConstant(object));
    }

    public CompactCodeAttributeComposer ldc(String string, Clazz clazz, Method method) {
        return this.ldc_(this.constantPoolEditor.addStringConstant(string, clazz, method));
    }

    public CompactCodeAttributeComposer ldc(String string, Clazz clazz) {
        return this.ldc_(this.constantPoolEditor.addClassConstant(string, clazz));
    }

    public CompactCodeAttributeComposer ldc_(int n) {
        return this.add(new ConstantInstruction(18, n));
    }

    public CompactCodeAttributeComposer ldc_w(int n) {
        return this.ldc_w_(this.constantPoolEditor.addIntegerConstant(n));
    }

    public CompactCodeAttributeComposer ldc_w(float f) {
        return this.ldc_w_(this.constantPoolEditor.addFloatConstant(f));
    }

    public CompactCodeAttributeComposer ldc_w(String string) {
        return this.ldc_w(string, null, null);
    }

    public CompactCodeAttributeComposer ldc_w(String string, Clazz clazz, Method method) {
        return this.ldc_w_(this.constantPoolEditor.addStringConstant(string, clazz, method));
    }

    public CompactCodeAttributeComposer ldc_w(String string, Clazz clazz) {
        return this.ldc_w_(this.constantPoolEditor.addClassConstant(string, clazz));
    }

    public CompactCodeAttributeComposer ldc_w_(int n) {
        return this.add(new ConstantInstruction(19, n));
    }

    public CompactCodeAttributeComposer ldc2_w(long l) {
        return this.ldc2_w(this.constantPoolEditor.addLongConstant(l));
    }

    public CompactCodeAttributeComposer ldc2_w(double d) {
        return this.ldc2_w(this.constantPoolEditor.addDoubleConstant(d));
    }

    public CompactCodeAttributeComposer ldc2_w(int n) {
        return this.add(new ConstantInstruction(20, n));
    }

    public CompactCodeAttributeComposer iload(int n) {
        return this.add(new VariableInstruction(21, n));
    }

    public CompactCodeAttributeComposer lload(int n) {
        return this.add(new VariableInstruction(22, n));
    }

    public CompactCodeAttributeComposer fload(int n) {
        return this.add(new VariableInstruction(23, n));
    }

    public CompactCodeAttributeComposer dload(int n) {
        return this.add(new VariableInstruction(24, n));
    }

    public CompactCodeAttributeComposer aload(int n) {
        return this.add(new VariableInstruction(25, n));
    }

    public CompactCodeAttributeComposer iload_0() {
        return this.add(new VariableInstruction(26));
    }

    public CompactCodeAttributeComposer iload_1() {
        return this.add(new VariableInstruction(27));
    }

    public CompactCodeAttributeComposer iload_2() {
        return this.add(new VariableInstruction(28));
    }

    public CompactCodeAttributeComposer iload_3() {
        return this.add(new VariableInstruction(29));
    }

    public CompactCodeAttributeComposer lload_0() {
        return this.add(new VariableInstruction(30));
    }

    public CompactCodeAttributeComposer lload_1() {
        return this.add(new VariableInstruction(31));
    }

    public CompactCodeAttributeComposer lload_2() {
        return this.add(new VariableInstruction(32));
    }

    public CompactCodeAttributeComposer lload_3() {
        return this.add(new VariableInstruction(33));
    }

    public CompactCodeAttributeComposer fload_0() {
        return this.add(new VariableInstruction(34));
    }

    public CompactCodeAttributeComposer fload_1() {
        return this.add(new VariableInstruction(35));
    }

    public CompactCodeAttributeComposer fload_2() {
        return this.add(new VariableInstruction(36));
    }

    public CompactCodeAttributeComposer fload_3() {
        return this.add(new VariableInstruction(37));
    }

    public CompactCodeAttributeComposer dload_0() {
        return this.add(new VariableInstruction(38));
    }

    public CompactCodeAttributeComposer dload_1() {
        return this.add(new VariableInstruction(39));
    }

    public CompactCodeAttributeComposer dload_2() {
        return this.add(new VariableInstruction(40));
    }

    public CompactCodeAttributeComposer dload_3() {
        return this.add(new VariableInstruction(41));
    }

    public CompactCodeAttributeComposer aload_0() {
        return this.add(new VariableInstruction(42));
    }

    public CompactCodeAttributeComposer aload_1() {
        return this.add(new VariableInstruction(43));
    }

    public CompactCodeAttributeComposer aload_2() {
        return this.add(new VariableInstruction(44));
    }

    public CompactCodeAttributeComposer aload_3() {
        return this.add(new VariableInstruction(45));
    }

    public CompactCodeAttributeComposer iaload() {
        return this.add(new SimpleInstruction(46));
    }

    public CompactCodeAttributeComposer laload() {
        return this.add(new SimpleInstruction(47));
    }

    public CompactCodeAttributeComposer faload() {
        return this.add(new SimpleInstruction(48));
    }

    public CompactCodeAttributeComposer daload() {
        return this.add(new SimpleInstruction(49));
    }

    public CompactCodeAttributeComposer aaload() {
        return this.add(new SimpleInstruction(50));
    }

    public CompactCodeAttributeComposer baload() {
        return this.add(new SimpleInstruction(51));
    }

    public CompactCodeAttributeComposer caload() {
        return this.add(new SimpleInstruction(52));
    }

    public CompactCodeAttributeComposer saload() {
        return this.add(new SimpleInstruction(53));
    }

    public CompactCodeAttributeComposer istore(int n) {
        return this.add(new VariableInstruction(54, n));
    }

    public CompactCodeAttributeComposer lstore(int n) {
        return this.add(new VariableInstruction(55, n));
    }

    public CompactCodeAttributeComposer fstore(int n) {
        return this.add(new VariableInstruction(56, n));
    }

    public CompactCodeAttributeComposer dstore(int n) {
        return this.add(new VariableInstruction(57, n));
    }

    public CompactCodeAttributeComposer astore(int n) {
        return this.add(new VariableInstruction(58, n));
    }

    public CompactCodeAttributeComposer istore_0() {
        return this.add(new VariableInstruction(59));
    }

    public CompactCodeAttributeComposer istore_1() {
        return this.add(new VariableInstruction(60));
    }

    public CompactCodeAttributeComposer istore_2() {
        return this.add(new VariableInstruction(61));
    }

    public CompactCodeAttributeComposer istore_3() {
        return this.add(new VariableInstruction(62));
    }

    public CompactCodeAttributeComposer lstore_0() {
        return this.add(new VariableInstruction(63));
    }

    public CompactCodeAttributeComposer lstore_1() {
        return this.add(new VariableInstruction(64));
    }

    public CompactCodeAttributeComposer lstore_2() {
        return this.add(new VariableInstruction(65));
    }

    public CompactCodeAttributeComposer lstore_3() {
        return this.add(new VariableInstruction(66));
    }

    public CompactCodeAttributeComposer fstore_0() {
        return this.add(new VariableInstruction(67));
    }

    public CompactCodeAttributeComposer fstore_1() {
        return this.add(new VariableInstruction(68));
    }

    public CompactCodeAttributeComposer fstore_2() {
        return this.add(new VariableInstruction(69));
    }

    public CompactCodeAttributeComposer fstore_3() {
        return this.add(new VariableInstruction(70));
    }

    public CompactCodeAttributeComposer dstore_0() {
        return this.add(new VariableInstruction(71));
    }

    public CompactCodeAttributeComposer dstore_1() {
        return this.add(new VariableInstruction(72));
    }

    public CompactCodeAttributeComposer dstore_2() {
        return this.add(new VariableInstruction(73));
    }

    public CompactCodeAttributeComposer dstore_3() {
        return this.add(new VariableInstruction(74));
    }

    public CompactCodeAttributeComposer astore_0() {
        return this.add(new VariableInstruction(75));
    }

    public CompactCodeAttributeComposer astore_1() {
        return this.add(new VariableInstruction(76));
    }

    public CompactCodeAttributeComposer astore_2() {
        return this.add(new VariableInstruction(77));
    }

    public CompactCodeAttributeComposer astore_3() {
        return this.add(new VariableInstruction(78));
    }

    public CompactCodeAttributeComposer iastore() {
        return this.add(new SimpleInstruction(79));
    }

    public CompactCodeAttributeComposer lastore() {
        return this.add(new SimpleInstruction(80));
    }

    public CompactCodeAttributeComposer fastore() {
        return this.add(new SimpleInstruction(81));
    }

    public CompactCodeAttributeComposer dastore() {
        return this.add(new SimpleInstruction(82));
    }

    public CompactCodeAttributeComposer aastore() {
        return this.add(new SimpleInstruction(83));
    }

    public CompactCodeAttributeComposer bastore() {
        return this.add(new SimpleInstruction(84));
    }

    public CompactCodeAttributeComposer castore() {
        return this.add(new SimpleInstruction(85));
    }

    public CompactCodeAttributeComposer sastore() {
        return this.add(new SimpleInstruction(86));
    }

    public CompactCodeAttributeComposer pop() {
        return this.add(new SimpleInstruction(87));
    }

    public CompactCodeAttributeComposer pop2() {
        return this.add(new SimpleInstruction(88));
    }

    public CompactCodeAttributeComposer dup() {
        return this.add(new SimpleInstruction(89));
    }

    public CompactCodeAttributeComposer dup_x1() {
        return this.add(new SimpleInstruction(90));
    }

    public CompactCodeAttributeComposer dup_x2() {
        return this.add(new SimpleInstruction(91));
    }

    public CompactCodeAttributeComposer dup2() {
        return this.add(new SimpleInstruction(92));
    }

    public CompactCodeAttributeComposer dup2_x1() {
        return this.add(new SimpleInstruction(93));
    }

    public CompactCodeAttributeComposer dup2_x2() {
        return this.add(new SimpleInstruction(94));
    }

    public CompactCodeAttributeComposer swap() {
        return this.add(new SimpleInstruction(95));
    }

    public CompactCodeAttributeComposer iadd() {
        return this.add(new SimpleInstruction(96));
    }

    public CompactCodeAttributeComposer ladd() {
        return this.add(new SimpleInstruction(97));
    }

    public CompactCodeAttributeComposer fadd() {
        return this.add(new SimpleInstruction(98));
    }

    public CompactCodeAttributeComposer dadd() {
        return this.add(new SimpleInstruction(99));
    }

    public CompactCodeAttributeComposer isub() {
        return this.add(new SimpleInstruction(100));
    }

    public CompactCodeAttributeComposer lsub() {
        return this.add(new SimpleInstruction(101));
    }

    public CompactCodeAttributeComposer fsub() {
        return this.add(new SimpleInstruction(102));
    }

    public CompactCodeAttributeComposer dsub() {
        return this.add(new SimpleInstruction(103));
    }

    public CompactCodeAttributeComposer imul() {
        return this.add(new SimpleInstruction(104));
    }

    public CompactCodeAttributeComposer lmul() {
        return this.add(new SimpleInstruction(105));
    }

    public CompactCodeAttributeComposer fmul() {
        return this.add(new SimpleInstruction(106));
    }

    public CompactCodeAttributeComposer dmul() {
        return this.add(new SimpleInstruction(107));
    }

    public CompactCodeAttributeComposer idiv() {
        return this.add(new SimpleInstruction(108));
    }

    public CompactCodeAttributeComposer ldiv() {
        return this.add(new SimpleInstruction(109));
    }

    public CompactCodeAttributeComposer fdiv() {
        return this.add(new SimpleInstruction(110));
    }

    public CompactCodeAttributeComposer ddiv() {
        return this.add(new SimpleInstruction(111));
    }

    public CompactCodeAttributeComposer irem() {
        return this.add(new SimpleInstruction(112));
    }

    public CompactCodeAttributeComposer lrem() {
        return this.add(new SimpleInstruction(113));
    }

    public CompactCodeAttributeComposer frem() {
        return this.add(new SimpleInstruction(114));
    }

    public CompactCodeAttributeComposer drem() {
        return this.add(new SimpleInstruction(115));
    }

    public CompactCodeAttributeComposer ineg() {
        return this.add(new SimpleInstruction(116));
    }

    public CompactCodeAttributeComposer lneg() {
        return this.add(new SimpleInstruction(117));
    }

    public CompactCodeAttributeComposer fneg() {
        return this.add(new SimpleInstruction(118));
    }

    public CompactCodeAttributeComposer dneg() {
        return this.add(new SimpleInstruction(119));
    }

    public CompactCodeAttributeComposer ishl() {
        return this.add(new SimpleInstruction(120));
    }

    public CompactCodeAttributeComposer lshl() {
        return this.add(new SimpleInstruction(121));
    }

    public CompactCodeAttributeComposer ishr() {
        return this.add(new SimpleInstruction(122));
    }

    public CompactCodeAttributeComposer lshr() {
        return this.add(new SimpleInstruction(123));
    }

    public CompactCodeAttributeComposer iushr() {
        return this.add(new SimpleInstruction(124));
    }

    public CompactCodeAttributeComposer lushr() {
        return this.add(new SimpleInstruction(125));
    }

    public CompactCodeAttributeComposer iand() {
        return this.add(new SimpleInstruction(126));
    }

    public CompactCodeAttributeComposer land() {
        return this.add(new SimpleInstruction(127));
    }

    public CompactCodeAttributeComposer ior() {
        return this.add(new SimpleInstruction(-128));
    }

    public CompactCodeAttributeComposer lor() {
        return this.add(new SimpleInstruction(-127));
    }

    public CompactCodeAttributeComposer ixor() {
        return this.add(new SimpleInstruction(-126));
    }

    public CompactCodeAttributeComposer lxor() {
        return this.add(new SimpleInstruction(-125));
    }

    public CompactCodeAttributeComposer iinc(int n, int n2) {
        return this.add(new VariableInstruction(-124, n, n2));
    }

    public CompactCodeAttributeComposer i2l() {
        return this.add(new SimpleInstruction(-123));
    }

    public CompactCodeAttributeComposer i2f() {
        return this.add(new SimpleInstruction(-122));
    }

    public CompactCodeAttributeComposer i2d() {
        return this.add(new SimpleInstruction(-121));
    }

    public CompactCodeAttributeComposer l2i() {
        return this.add(new SimpleInstruction(-120));
    }

    public CompactCodeAttributeComposer l2f() {
        return this.add(new SimpleInstruction(-119));
    }

    public CompactCodeAttributeComposer l2d() {
        return this.add(new SimpleInstruction(-118));
    }

    public CompactCodeAttributeComposer f2i() {
        return this.add(new SimpleInstruction(-117));
    }

    public CompactCodeAttributeComposer f2l() {
        return this.add(new SimpleInstruction(-116));
    }

    public CompactCodeAttributeComposer f2d() {
        return this.add(new SimpleInstruction(-115));
    }

    public CompactCodeAttributeComposer d2i() {
        return this.add(new SimpleInstruction(-114));
    }

    public CompactCodeAttributeComposer d2l() {
        return this.add(new SimpleInstruction(-113));
    }

    public CompactCodeAttributeComposer d2f() {
        return this.add(new SimpleInstruction(-112));
    }

    public CompactCodeAttributeComposer i2b() {
        return this.add(new SimpleInstruction(-111));
    }

    public CompactCodeAttributeComposer i2c() {
        return this.add(new SimpleInstruction(-110));
    }

    public CompactCodeAttributeComposer i2s() {
        return this.add(new SimpleInstruction(-109));
    }

    public CompactCodeAttributeComposer lcmp() {
        return this.add(new SimpleInstruction(-108));
    }

    public CompactCodeAttributeComposer fcmpl() {
        return this.add(new SimpleInstruction(-107));
    }

    public CompactCodeAttributeComposer fcmpg() {
        return this.add(new SimpleInstruction(-106));
    }

    public CompactCodeAttributeComposer dcmpl() {
        return this.add(new SimpleInstruction(-105));
    }

    public CompactCodeAttributeComposer dcmpg() {
        return this.add(new SimpleInstruction(-104));
    }

    public CompactCodeAttributeComposer ifeq(int n) {
        return this.add(new BranchInstruction(-103, n));
    }

    public CompactCodeAttributeComposer ifne(int n) {
        return this.add(new BranchInstruction(-102, n));
    }

    public CompactCodeAttributeComposer iflt(int n) {
        return this.add(new BranchInstruction(-101, n));
    }

    public CompactCodeAttributeComposer ifge(int n) {
        return this.add(new BranchInstruction(-100, n));
    }

    public CompactCodeAttributeComposer ifgt(int n) {
        return this.add(new BranchInstruction(-99, n));
    }

    public CompactCodeAttributeComposer ifle(int n) {
        return this.add(new BranchInstruction(-98, n));
    }

    public CompactCodeAttributeComposer ificmpeq(int n) {
        return this.add(new BranchInstruction(-97, n));
    }

    public CompactCodeAttributeComposer ificmpne(int n) {
        return this.add(new BranchInstruction(-96, n));
    }

    public CompactCodeAttributeComposer ificmplt(int n) {
        return this.add(new BranchInstruction(-95, n));
    }

    public CompactCodeAttributeComposer ificmpge(int n) {
        return this.add(new BranchInstruction(-94, n));
    }

    public CompactCodeAttributeComposer ificmpgt(int n) {
        return this.add(new BranchInstruction(-93, n));
    }

    public CompactCodeAttributeComposer ificmple(int n) {
        return this.add(new BranchInstruction(-92, n));
    }

    public CompactCodeAttributeComposer ifacmpeq(int n) {
        return this.add(new BranchInstruction(-91, n));
    }

    public CompactCodeAttributeComposer ifacmpne(int n) {
        return this.add(new BranchInstruction(-90, n));
    }

    public CompactCodeAttributeComposer goto_(int n) {
        return this.add(new BranchInstruction(-89, n));
    }

    public CompactCodeAttributeComposer jsr(int n) {
        return this.add(new BranchInstruction(-88, n));
    }

    public CompactCodeAttributeComposer ret(int n) {
        return this.add(new VariableInstruction(-87, n));
    }

    public CompactCodeAttributeComposer tableswitch(int n, int n2, int n3, int[] nArray) {
        return this.add(new TableSwitchInstruction(-86, n, n2, n3, nArray));
    }

    public CompactCodeAttributeComposer lookupswitch(int n, int[] nArray, int[] nArray2) {
        return this.add(new LookUpSwitchInstruction(-85, n, nArray, nArray2));
    }

    public CompactCodeAttributeComposer ireturn() {
        return this.add(new SimpleInstruction(-84));
    }

    public CompactCodeAttributeComposer lreturn() {
        return this.add(new SimpleInstruction(-83));
    }

    public CompactCodeAttributeComposer freturn() {
        return this.add(new SimpleInstruction(-82));
    }

    public CompactCodeAttributeComposer dreturn() {
        return this.add(new SimpleInstruction(-81));
    }

    public CompactCodeAttributeComposer areturn() {
        return this.add(new SimpleInstruction(-80));
    }

    public CompactCodeAttributeComposer return_() {
        return this.add(new SimpleInstruction(-79));
    }

    public CompactCodeAttributeComposer getstatic(Clazz clazz, Member member) {
        return this.getstatic(clazz.getName(), member.getName(clazz), member.getDescriptor(clazz), clazz, member);
    }

    public CompactCodeAttributeComposer getstatic(String string, String string2, String string3) {
        return this.getstatic(string, string2, string3, null, null);
    }

    public CompactCodeAttributeComposer getstatic(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.getstatic(this.constantPoolEditor.addFieldrefConstant(string, string2, string3, clazz, member));
    }

    public CompactCodeAttributeComposer getstatic(int n) {
        return this.add(new ConstantInstruction(-78, n));
    }

    public CompactCodeAttributeComposer putstatic(Clazz clazz, Member member) {
        return this.putstatic(clazz.getName(), member.getName(clazz), member.getDescriptor(clazz), clazz, member);
    }

    public CompactCodeAttributeComposer putstatic(String string, String string2, String string3) {
        return this.putstatic(string, string2, string3, null, null);
    }

    public CompactCodeAttributeComposer putstatic(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.putstatic(this.constantPoolEditor.addFieldrefConstant(string, string2, string3, clazz, member));
    }

    public CompactCodeAttributeComposer putstatic(int n) {
        return this.add(new ConstantInstruction(-77, n));
    }

    public CompactCodeAttributeComposer getfield(String string, String string2, String string3) {
        return this.getfield(string, string2, string3, null, null);
    }

    public CompactCodeAttributeComposer getfield(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.getfield(this.constantPoolEditor.addFieldrefConstant(string, string2, string3, clazz, member));
    }

    public CompactCodeAttributeComposer getfield(int n) {
        return this.add(new ConstantInstruction(-76, n));
    }

    public CompactCodeAttributeComposer putfield(String string, String string2, String string3) {
        return this.putfield(string, string2, string3, null, null);
    }

    public CompactCodeAttributeComposer putfield(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.putfield(this.constantPoolEditor.addFieldrefConstant(string, string2, string3, clazz, member));
    }

    public CompactCodeAttributeComposer putfield(int n) {
        return this.add(new ConstantInstruction(-75, n));
    }

    public CompactCodeAttributeComposer invokevirtual(String string, String string2, String string3) {
        return this.invokevirtual(string, string2, string3, null, null);
    }

    public CompactCodeAttributeComposer invokevirtual(Clazz clazz, Member member) {
        return this.invokevirtual(clazz.getName(), member.getName(clazz), member.getDescriptor(clazz), clazz, member);
    }

    public CompactCodeAttributeComposer invokevirtual(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.invokevirtual(this.constantPoolEditor.addMethodrefConstant(string, string2, string3, clazz, member));
    }

    public CompactCodeAttributeComposer invokevirtual(int n) {
        return this.add(new ConstantInstruction(-74, n));
    }

    public CompactCodeAttributeComposer invokespecial(String string, String string2, String string3) {
        return this.invokespecial(string, string2, string3, null, null);
    }

    public CompactCodeAttributeComposer invokespecial(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.invokespecial(this.constantPoolEditor.addMethodrefConstant(string, string2, string3, clazz, member));
    }

    public CompactCodeAttributeComposer invokespecial(int n) {
        return this.add(new ConstantInstruction(-73, n));
    }

    public CompactCodeAttributeComposer invokestatic(String string, String string2, String string3) {
        return this.invokestatic(string, string2, string3, null, null);
    }

    public CompactCodeAttributeComposer invokestatic(Clazz clazz, Member member) {
        return this.invokestatic(clazz.getName(), member.getName(clazz), member.getDescriptor(clazz), clazz, member);
    }

    public CompactCodeAttributeComposer invokestatic(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.invokestatic(this.constantPoolEditor.addMethodrefConstant(string, string2, string3, clazz, member));
    }

    public CompactCodeAttributeComposer invokestaticinterface(String string, String string2, String string3) {
        return this.invokestaticinterface(string, string2, string3, null, null);
    }

    public CompactCodeAttributeComposer invokestaticinterface(Clazz clazz, Member member) {
        return this.invokestaticinterface(clazz.getName(), member.getName(clazz), member.getDescriptor(clazz), clazz, member);
    }

    public CompactCodeAttributeComposer invokestaticinterface(String string, String string2, String string3, Clazz clazz, Member member) {
        return this.invokestatic(this.constantPoolEditor.addInterfaceMethodrefConstant(string, string2, string3, clazz, member));
    }

    public CompactCodeAttributeComposer invokestatic(int n) {
        return this.add(new ConstantInstruction(-72, n));
    }

    public CompactCodeAttributeComposer invokeinterface(String string, String string2, String string3) {
        return this.invokeinterface(string, string2, string3, null, null);
    }

    public CompactCodeAttributeComposer invokeinterface(String string, String string2, String string3, Clazz clazz, Member member) {
        int n = ClassUtil.internalMethodParameterSize(string3, false) << 8;
        return this.invokeinterface(this.constantPoolEditor.addInterfaceMethodrefConstant(string, string2, string3, clazz, member), n);
    }

    public CompactCodeAttributeComposer invokeinterface(int n, int n2) {
        return this.add(new ConstantInstruction(-71, n, n2));
    }

    public CompactCodeAttributeComposer invokedynamic(int n, String string, String string2, Clazz[] clazzArray) {
        return this.invokedynamic(this.constantPoolEditor.addInvokeDynamicConstant(n, string, string2, clazzArray));
    }

    public CompactCodeAttributeComposer invokedynamic(int n) {
        return this.add(new ConstantInstruction(-70, n));
    }

    public CompactCodeAttributeComposer new_(String string) {
        return this.new_(string, null);
    }

    public CompactCodeAttributeComposer new_(String string, Clazz clazz) {
        return this.new_(this.constantPoolEditor.addClassConstant(string, clazz));
    }

    public CompactCodeAttributeComposer new_(int n) {
        return this.add(new ConstantInstruction(-69, n));
    }

    public CompactCodeAttributeComposer newarray(int n) {
        return this.add(new SimpleInstruction(-68, n));
    }

    public CompactCodeAttributeComposer anewarray(String string, Clazz clazz) {
        return this.anewarray(this.constantPoolEditor.addClassConstant(string, clazz));
    }

    public CompactCodeAttributeComposer anewarray(int n) {
        return this.add(new ConstantInstruction(-67, n));
    }

    public CompactCodeAttributeComposer arraylength() {
        return this.add(new SimpleInstruction(-66));
    }

    public CompactCodeAttributeComposer athrow() {
        return this.add(new SimpleInstruction(-65));
    }

    public CompactCodeAttributeComposer checkcast(String string) {
        return this.checkcast(string, null);
    }

    public CompactCodeAttributeComposer checkcast(String string, Clazz clazz) {
        return this.checkcast(this.constantPoolEditor.addClassConstant(string, clazz));
    }

    public CompactCodeAttributeComposer checkcast(int n) {
        return this.add(new ConstantInstruction(-64, n));
    }

    public CompactCodeAttributeComposer instanceof_(String string, Clazz clazz) {
        return this.instanceof_(this.constantPoolEditor.addClassConstant(string, clazz));
    }

    public CompactCodeAttributeComposer instanceof_(int n) {
        return this.add(new ConstantInstruction(-63, n));
    }

    public CompactCodeAttributeComposer monitorenter() {
        return this.add(new SimpleInstruction(-62));
    }

    public CompactCodeAttributeComposer monitorexit() {
        return this.add(new SimpleInstruction(-61));
    }

    public CompactCodeAttributeComposer wide() {
        return this.add(new SimpleInstruction(-60));
    }

    public CompactCodeAttributeComposer multianewarray(String string, Clazz clazz) {
        return this.multianewarray(this.constantPoolEditor.addClassConstant(string, clazz));
    }

    public CompactCodeAttributeComposer multianewarray(int n) {
        return this.add(new ConstantInstruction(-59, n));
    }

    public CompactCodeAttributeComposer ifnull(int n) {
        return this.add(new BranchInstruction(-58, n));
    }

    public CompactCodeAttributeComposer ifnonnull(int n) {
        return this.add(new BranchInstruction(-57, n));
    }

    public CompactCodeAttributeComposer goto_w(int n) {
        return this.add(new BranchInstruction(-56, n));
    }

    public CompactCodeAttributeComposer jsr_w(int n) {
        return this.add(new BranchInstruction(-55, n));
    }

    public CompactCodeAttributeComposer pushPrimitive(Object object, char c) {
        switch (c) {
            case 'Z': {
                return (Boolean)object != false ? this.iconst_1() : this.iconst_0();
            }
            case 'B': {
                return this.bipush(((Byte)object).byteValue());
            }
            case 'C': {
                return this.ldc(((Character)object).charValue());
            }
            case 'S': {
                return this.sipush(((Short)object).shortValue());
            }
            case 'I': {
                return this.ldc((Integer)object);
            }
            case 'J': {
                return this.ldc2_w((Long)object);
            }
            case 'F': {
                return this.ldc(((Float)object).floatValue());
            }
            case 'D': {
                return this.ldc2_w((Double)object);
            }
        }
        throw new IllegalArgumentException(object.toString());
    }

    public CompactCodeAttributeComposer pushInt(int n) {
        return n >= -1 && n <= 5 ? this.iconst(n) : (n == (byte)n ? this.bipush(n) : (n == (short)n ? this.sipush(n) : this.ldc(n)));
    }

    public CompactCodeAttributeComposer pushFloat(float f) {
        return f == 0.0f || f == 1.0f ? this.fconst((int)f) : this.ldc(f);
    }

    public CompactCodeAttributeComposer pushLong(long l) {
        return l == 0L || l == 1L ? this.lconst((int)l) : this.ldc2_w(l);
    }

    public CompactCodeAttributeComposer pushDouble(double d) {
        return d == 0.0 || d == 1.0 ? this.dconst((int)d) : this.ldc2_w(d);
    }

    public CompactCodeAttributeComposer pushNewArray(String string, int n) {
        this.pushInt(n);
        return ClassUtil.isInternalPrimitiveType(string) ? this.newarray(InstructionUtil.arrayTypeFromInternalType(string.charAt(0))) : this.anewarray(string, null);
    }

    public CompactCodeAttributeComposer load(int n, String string) {
        return this.load(n, string.charAt(0));
    }

    public CompactCodeAttributeComposer load(int n, char c) {
        switch (c) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.iload(n);
            }
            case 'J': {
                return this.lload(n);
            }
            case 'F': {
                return this.fload(n);
            }
            case 'D': {
                return this.dload(n);
            }
        }
        return this.aload(n);
    }

    public CompactCodeAttributeComposer store(int n, String string) {
        return this.store(n, string.charAt(0));
    }

    public CompactCodeAttributeComposer store(int n, char c) {
        switch (c) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.istore(n);
            }
            case 'J': {
                return this.lstore(n);
            }
            case 'F': {
                return this.fstore(n);
            }
            case 'D': {
                return this.dstore(n);
            }
        }
        return this.astore(n);
    }

    public CompactCodeAttributeComposer storeToArray(String string) {
        switch (string.charAt(0)) {
            case 'B': 
            case 'Z': {
                return this.bastore();
            }
            case 'C': {
                return this.castore();
            }
            case 'S': {
                return this.sastore();
            }
            case 'I': {
                return this.iastore();
            }
            case 'J': {
                return this.lastore();
            }
            case 'F': {
                return this.fastore();
            }
            case 'D': {
                return this.dastore();
            }
        }
        return this.aastore();
    }

    public CompactCodeAttributeComposer return_(String string) {
        switch (string.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.ireturn();
            }
            case 'J': {
                return this.lreturn();
            }
            case 'F': {
                return this.freturn();
            }
            case 'D': {
                return this.dreturn();
            }
            case 'V': {
                return this.return_();
            }
        }
        return this.areturn();
    }

    public CompactCodeAttributeComposer appendPrintIntegerInstructions(String string) {
        this.appendPrintInstructions(string);
        this.appendPrintIntegerInstructions();
        return this;
    }

    public CompactCodeAttributeComposer appendPrintIntegerHexInstructions(String string) {
        this.appendPrintInstructions(string);
        this.appendPrintIntegerHexInstructions();
        return this;
    }

    public CompactCodeAttributeComposer appendPrintLongInstructions(String string) {
        this.appendPrintInstructions(string);
        this.appendPrintLongInstructions();
        return this;
    }

    public CompactCodeAttributeComposer appendPrintStringInstructions(String string) {
        this.appendPrintInstructions(string);
        this.appendPrintStringInstructions();
        return this;
    }

    public CompactCodeAttributeComposer appendPrintObjectInstructions(String string) {
        this.appendPrintInstructions(string);
        this.appendPrintObjectInstructions();
        return this;
    }

    public CompactCodeAttributeComposer appendPrintStackTraceInstructions(String string) {
        this.appendPrintInstructions(string);
        this.appendPrintStackTraceInstructions();
        return this;
    }

    public CompactCodeAttributeComposer appendPrintInstructions(String string) {
        this.getstatic("java/lang/System", "err", "Ljava/io/PrintStream;");
        this.ldc(string);
        this.invokevirtual("java/io/PrintStream", "println", "(Ljava/lang/String;)V");
        return this;
    }

    public CompactCodeAttributeComposer appendPrintIntegerInstructions() {
        this.dup();
        this.getstatic("java/lang/System", "err", "Ljava/io/PrintStream;");
        this.swap();
        this.invokevirtual("java/io/PrintStream", "println", "(I)V");
        return this;
    }

    public CompactCodeAttributeComposer appendPrintIntegerHexInstructions() {
        this.dup();
        this.getstatic("java/lang/System", "err", "Ljava/io/PrintStream;");
        this.swap();
        this.invokestatic("java/lang/Integer", "toHexString", "(I)Ljava/lang/String;");
        this.invokevirtual("java/io/PrintStream", "println", "(Ljava/lang/String;)V");
        return this;
    }

    public CompactCodeAttributeComposer appendPrintLongInstructions() {
        this.dup2();
        this.getstatic("java/lang/System", "err", "Ljava/io/PrintStream;");
        this.dup_x2();
        this.pop();
        this.invokevirtual("java/io/PrintStream", "println", "(J)V");
        return this;
    }

    public CompactCodeAttributeComposer appendPrintStringInstructions() {
        this.dup();
        this.getstatic("java/lang/System", "err", "Ljava/io/PrintStream;");
        this.swap();
        this.invokevirtual("java/io/PrintStream", "println", "(Ljava/lang/String;)V");
        return this;
    }

    public CompactCodeAttributeComposer appendPrintObjectInstructions() {
        this.dup();
        this.getstatic("java/lang/System", "err", "Ljava/io/PrintStream;");
        this.swap();
        this.invokevirtual("java/io/PrintStream", "println", "(Ljava/lang/Object;)V");
        return this;
    }

    public CompactCodeAttributeComposer appendPrintStackTraceInstructions() {
        this.dup();
        this.invokevirtual("java/lang/Throwable", "printStackTrace", "()V");
        return this;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeComposer.visitCodeAttribute(clazz, method, codeAttribute);
    }

    private CompactCodeAttributeComposer add(Instruction instruction) {
        this.codeAttributeComposer.appendInstruction(instruction);
        return this;
    }

    public static void main(String[] stringArray) {
        ProgramClass programClass = new ProgramClass(0, 0, new Constant[32], 0, 0, 0);
        CompactCodeAttributeComposer compactCodeAttributeComposer = new CompactCodeAttributeComposer(programClass);
        compactCodeAttributeComposer.beginCodeFragment(4);
        compactCodeAttributeComposer.appendInstruction(0, new SimpleInstruction(3));
        compactCodeAttributeComposer.appendInstruction(1, new VariableInstruction(54, 0));
        compactCodeAttributeComposer.appendInstruction(2, new BranchInstruction(-89, 1));
        compactCodeAttributeComposer.beginCodeFragment(4);
        compactCodeAttributeComposer.appendInstruction(0, new VariableInstruction(-124, 0, 1));
        compactCodeAttributeComposer.appendInstruction(1, new VariableInstruction(21, 0));
        compactCodeAttributeComposer.appendInstruction(2, new SimpleInstruction(8));
        compactCodeAttributeComposer.appendInstruction(3, new BranchInstruction(-95, -3));
        compactCodeAttributeComposer.endCodeFragment();
        compactCodeAttributeComposer.appendInstruction(3, new SimpleInstruction(-79));
        compactCodeAttributeComposer.endCodeFragment();
    }
}

