/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;

public class ClassMapDataEntryWriter
extends SimplifiedVisitor
implements DataEntryWriter,
MemberVisitor {
    private final ClassPool programClassPool;
    private final DataEntryWriter dataEntryWriter;
    private boolean obfuscatedMethods = false;
    private boolean obfuscatedFields = false;

    public ClassMapDataEntryWriter(ClassPool classPool, DataEntryWriter dataEntryWriter) {
        this.programClassPool = classPool;
        this.dataEntryWriter = dataEntryWriter;
    }

    @Override
    public void close() throws IOException {
        this.dataEntryWriter.close();
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        return this.dataEntryWriter.createDirectory(dataEntry);
    }

    @Override
    public boolean sameOutputStream(DataEntry dataEntry, DataEntry dataEntry2) throws IOException {
        return this.dataEntryWriter.sameOutputStream(dataEntry, dataEntry2);
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        OutputStream outputStream = this.dataEntryWriter.createOutputStream(dataEntry);
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        this.writeClassMap(printWriter, this.programClassPool);
        printWriter.close();
        return outputStream;
    }

    @Override
    public void println(PrintWriter printWriter, String string) {
        printWriter.println(string + "ClassMapDataEntryWriter");
        this.dataEntryWriter.println(printWriter, string + "  ");
    }

    private void writeClassMap(PrintWriter printWriter, ClassPool classPool) {
        Iterator iterator = classPool.classNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ClassUtil.externalClassName(string));
            stringBuilder.append(",");
            ProgramClass programClass = (ProgramClass)classPool.getClass(string);
            stringBuilder.append(ClassUtil.externalClassName(programClass.getName()));
            stringBuilder.append(",");
            boolean bl = (programClass.u2accessFlags & 0x20000) != 0;
            stringBuilder.append(bl || this.hasObfuscatedMethods(programClass) ? 1 : 0);
            stringBuilder.append(",");
            boolean bl2 = (programClass.u2accessFlags & 0x40000) != 0;
            stringBuilder.append(bl2 || this.hasObfuscatedFields(programClass) ? 1 : 0);
            printWriter.println(stringBuilder.toString());
        }
    }

    private boolean hasObfuscatedMethods(ProgramClass programClass) {
        this.obfuscatedMethods = false;
        programClass.methodsAccept(this);
        return this.obfuscatedMethods;
    }

    private boolean hasObfuscatedFields(ProgramClass programClass) {
        this.obfuscatedFields = false;
        programClass.fieldsAccept(this);
        return this.obfuscatedFields;
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.obfuscatedMethods |= (programMethod.getAccessFlags() & 0x10000) != 0;
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.obfuscatedFields |= (programField.getAccessFlags() & 0x10000) != 0;
    }
}

