/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler.list;

import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.util.JsonUtil;
import org.jolokia.service.jmx.handler.list.DataKeys;
import org.jolokia.service.jmx.handler.list.DataUpdater;

class OperationDataUpdater
extends DataUpdater {
    protected OperationDataUpdater() {
        super(100);
    }

    @Override
    public String getKey() {
        return DataKeys.OPERATIONS.getKey();
    }

    @Override
    public JSONObject extractData(ObjectName pObjectName, MBeanInfo pMBeanInfo, String pOperation) {
        JSONObject opMap = new JSONObject();
        for (MBeanOperationInfo opInfo : pMBeanInfo.getOperations()) {
            if (pOperation != null && !opInfo.getName().equals(pOperation)) continue;
            JSONObject map = new JSONObject();
            JSONArray argList = new JSONArray(opInfo.getSignature().length);
            for (MBeanParameterInfo paramInfo : opInfo.getSignature()) {
                JSONObject args = new JSONObject();
                args.put((Object)DataKeys.DESCRIPTION.getKey(), (Object)paramInfo.getDescription());
                args.put((Object)DataKeys.NAME.getKey(), (Object)paramInfo.getName());
                args.put((Object)DataKeys.TYPE.getKey(), (Object)paramInfo.getType());
                argList.add((Object)args);
            }
            map.put((Object)DataKeys.ARGS.getKey(), (Object)argList);
            map.put((Object)DataKeys.RETURN_TYPE.getKey(), (Object)opInfo.getReturnType());
            map.put((Object)DataKeys.DESCRIPTION.getKey(), (Object)opInfo.getDescription());
            JsonUtil.addJSONObjectToJSONObject((JSONObject)opMap, (String)opInfo.getName(), (JSONObject)map);
        }
        return opMap;
    }
}

