/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTimeoutTest
extends ClientBase {
    protected static final Logger LOG = LoggerFactory.getLogger(SessionTimeoutTest.class);
    private TestableZooKeeper zk;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.zk = this.createClient();
    }

    @Test
    public void testSessionExpiration() throws InterruptedException, KeeperException {
        CountDownLatch expirationLatch = new CountDownLatch(1);
        Watcher watcher = event -> {
            if (event.getState() == Watcher.Event.KeeperState.Expired) {
                expirationLatch.countDown();
            }
        };
        this.zk.exists("/foo", watcher);
        this.zk.getTestable().injectSessionExpiration();
        Assertions.assertTrue((boolean)expirationLatch.await(5L, TimeUnit.SECONDS));
        boolean gotException = false;
        try {
            this.zk.exists("/foo", false);
            Assertions.fail((String)"Should have thrown a SessionExpiredException");
        }
        catch (KeeperException.SessionExpiredException e) {
            gotException = true;
        }
        Assertions.assertTrue((boolean)gotException);
    }

    @Test
    public void testSessionRecoveredAfterMultipleFailedAttempts() throws Exception {
        this.zk.close();
        try (BusyServer busyServer = new BusyServer();){
            List<String> servers = Arrays.asList(busyServer.getHostPort(), busyServer.getHostPort(), this.hostPort, busyServer.getHostPort(), busyServer.getHostPort(), busyServer.getHostPort());
            String connectString = String.join((CharSequence)",", servers);
            this.zk = this.createClient(new ClientBase.CountdownWatcher(), connectString);
            this.stopServer();
            Thread.sleep(this.zk.getSessionTimeout() / 2);
            CompletableFuture connected = new CompletableFuture();
            this.zk.register(event -> {
                if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    connected.complete(null);
                } else {
                    connected.completeExceptionally(new KeeperException.SessionExpiredException());
                }
            });
            this.startServer();
            connected.join();
        }
    }

    @Test
    public void testSessionExpirationAfterAllServerDown() throws Exception {
        this.zk.close();
        int sessionTimeout = 3000;
        CompletableFuture expired = new CompletableFuture();
        this.zk = this.createClient(new ClientBase.CountdownWatcher(), this.hostPort, sessionTimeout);
        this.zk.register(event -> {
            if (event.getState() == Watcher.Event.KeeperState.Expired) {
                expired.complete(null);
            }
        });
        this.stopServer();
        expired.join();
        Assertions.assertThrows(KeeperException.SessionExpiredException.class, () -> this.zk.exists("/", null));
    }

    @Test
    public void testSessionExpirationWhenNoServerUp() throws Exception {
        this.zk.close();
        this.stopServer();
        int sessionTimeout = 3000;
        CompletableFuture expired = new CompletableFuture();
        new TestableZooKeeper(this.hostPort, sessionTimeout, event -> {
            if (event.getState() == Watcher.Event.KeeperState.Expired) {
                expired.complete(null);
            }
        });
        expired.join();
        Assertions.assertThrows(KeeperException.SessionExpiredException.class, () -> this.zk.exists("/", null));
    }

    @Test
    public void testQueueEvent() throws InterruptedException, KeeperException {
        CountDownLatch eventLatch = new CountDownLatch(1);
        Watcher watcher = event -> {
            if (event.getType() == Watcher.Event.EventType.NodeDataChanged && event.getPath().equals("/foo/bar")) {
                eventLatch.countDown();
            }
        };
        this.zk.exists("/foo/bar", watcher);
        WatchedEvent event2 = new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, "/foo/bar");
        this.zk.getTestable().queueEvent(event2);
        Assertions.assertTrue((boolean)eventLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testSessionDisconnect() throws KeeperException, InterruptedException, IOException {
        this.zk.create("/sdisconnect", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Assertions.assertNotNull((Object)this.zk.exists("/sdisconnect", null), (String)"Ephemeral node has not been created");
        this.zk.close();
        this.zk = this.createClient();
        Assertions.assertNull((Object)this.zk.exists("/sdisconnect", null), (String)"Ephemeral node shouldn't exist after client disconnect");
    }

    @Test
    public void testSessionRestore() throws KeeperException, InterruptedException, IOException {
        this.zk.create("/srestore", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Assertions.assertNotNull((Object)this.zk.exists("/srestore", null), (String)"Ephemeral node has not been created");
        this.zk.disconnect();
        this.zk.close();
        this.zk = this.createClient();
        Assertions.assertNotNull((Object)this.zk.exists("/srestore", null), (String)"Ephemeral node should be present when session is restored");
    }

    @Test
    public void testSessionSurviveServerRestart() throws Exception {
        this.zk.create("/sdeath", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Assertions.assertNotNull((Object)this.zk.exists("/sdeath", null), (String)"Ephemeral node has not been created");
        this.zk.disconnect();
        this.stopServer();
        this.startServer();
        this.zk = this.createClient();
        Assertions.assertNotNull((Object)this.zk.exists("/sdeath", null), (String)"Ephemeral node should be present when server restarted");
    }

    private static class BusyServer
    implements AutoCloseable {
        private final ServerSocket server = new ServerSocket(0, 1);
        private final Socket client = new Socket("127.0.0.1", this.server.getLocalPort());

        public int getLocalPort() {
            return this.server.getLocalPort();
        }

        public String getHostPort() {
            return String.format("127.0.0.1:%d", this.getLocalPort());
        }

        @Override
        public void close() throws Exception {
            this.client.close();
            this.server.close();
        }
    }
}

