/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	context "context"

	v1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
	camelv1 "github.com/apache/camel-k/v2/pkg/client/camel/applyconfiguration/camel/v1"
	typedcamelv1 "github.com/apache/camel-k/v2/pkg/client/camel/clientset/versioned/typed/camel/v1"
	autoscalingv1 "k8s.io/api/autoscaling/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	gentype "k8s.io/client-go/gentype"
	testing "k8s.io/client-go/testing"
)

// fakePipes implements PipeInterface
type fakePipes struct {
	*gentype.FakeClientWithListAndApply[*v1.Pipe, *v1.PipeList, *camelv1.PipeApplyConfiguration]
	Fake *FakeCamelV1
}

func newFakePipes(fake *FakeCamelV1, namespace string) typedcamelv1.PipeInterface {
	return &fakePipes{
		gentype.NewFakeClientWithListAndApply[*v1.Pipe, *v1.PipeList, *camelv1.PipeApplyConfiguration](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("pipes"),
			v1.SchemeGroupVersion.WithKind("Pipe"),
			func() *v1.Pipe { return &v1.Pipe{} },
			func() *v1.PipeList { return &v1.PipeList{} },
			func(dst, src *v1.PipeList) { dst.ListMeta = src.ListMeta },
			func(list *v1.PipeList) []*v1.Pipe { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.PipeList, items []*v1.Pipe) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}

// GetScale takes name of the pipe, and returns the corresponding scale object, and an error if there is any.
func (c *fakePipes) GetScale(ctx context.Context, pipeName string, options metav1.GetOptions) (result *autoscalingv1.Scale, err error) {
	emptyResult := &autoscalingv1.Scale{}
	obj, err := c.Fake.
		Invokes(testing.NewGetSubresourceActionWithOptions(c.Resource(), c.Namespace(), "scale", pipeName, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*autoscalingv1.Scale), err
}

// UpdateScale takes the representation of a scale and updates it. Returns the server's representation of the scale, and an error, if there is any.
func (c *fakePipes) UpdateScale(ctx context.Context, pipeName string, scale *autoscalingv1.Scale, opts metav1.UpdateOptions) (result *autoscalingv1.Scale, err error) {
	emptyResult := &autoscalingv1.Scale{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceActionWithOptions(c.Resource(), "scale", c.Namespace(), scale, opts), &autoscalingv1.Scale{})

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*autoscalingv1.Scale), err
}
