/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool.stats;

import java.util.Comparator;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.tools.nodetool.stats.StatsTable;

public class StatsTableComparator
implements Comparator<StatsTable> {
    private final String sortKey;
    private final boolean humanReadable;
    private final boolean ascending;
    public static final String[] supportedSortKeys = new String[]{"average_live_cells_per_slice_last_five_minutes", "average_tombstones_per_slice_last_five_minutes", "bloom_filter_false_positives", "bloom_filter_false_ratio", "bloom_filter_off_heap_memory_used", "bloom_filter_space_used", "compacted_partition_maximum_bytes", "compacted_partition_mean_bytes", "compacted_partition_minimum_bytes", "compression_metadata_off_heap_memory_used", "dropped_mutations", "full_name", "index_summary_off_heap_memory_used", "local_read_count", "local_read_latency_ms", "local_write_latency_ms", "maximum_live_cells_per_slice_last_five_minutes", "maximum_tombstones_per_slice_last_five_minutes", "memtable_cell_count", "memtable_data_size", "memtable_off_heap_memory_used", "memtable_switch_count", "number_of_partitions_estimate", "off_heap_memory_used_total", "pending_flushes", "percent_repaired", "read_latency", "reads", "space_used_by_snapshots_total", "space_used_live", "space_used_total", "sstable_compression_ratio", "sstable_count", "table_name", "write_latency", "writes", "max_sstable_size", "local_read_write_ratio", "twcs_max_duration", "sai_local_query_latency_ms", "sai_post_filtering_read_latency", "sai_disk_used_bytes", "sai_sstable_indexes_hit", "sai_index_segments_hit", "sai_rows_filtered", "sai_total_query_timeouts", "sai_total_queryable_index_ratio"};

    public StatsTableComparator(String sortKey, boolean humanReadable) {
        this(sortKey, humanReadable, false);
    }

    public StatsTableComparator(String sortKey, boolean humanReadable, boolean ascending) {
        this.sortKey = sortKey;
        this.humanReadable = humanReadable;
        this.ascending = ascending;
    }

    private int compareDoubles(double x, double y) {
        int sign;
        int n = sign = this.ascending ? 1 : -1;
        if (Double.isNaN(x) && !Double.isNaN(y)) {
            return sign * Double.valueOf(0.0).compareTo(y);
        }
        if (!Double.isNaN(x) && Double.isNaN(y)) {
            return sign * Double.valueOf(x).compareTo(0.0);
        }
        if (Double.isNaN(x) && Double.isNaN(y)) {
            return 0;
        }
        return sign * Double.valueOf(x).compareTo(y);
    }

    private int compareFileSizes(String x, String y) {
        int sign;
        int n = sign = this.ascending ? 1 : -1;
        if (null == x && null != y) {
            return sign * -1;
        }
        if (null != x && null == y) {
            return sign;
        }
        if (null == x && null == y) {
            return 0;
        }
        long sizeX = this.humanReadable ? FileUtils.parseFileSize(x) : Long.valueOf(x);
        long sizeY = this.humanReadable ? FileUtils.parseFileSize(y) : Long.valueOf(y);
        return sign * Long.compare(sizeX, sizeY);
    }

    @Override
    public int compare(StatsTable stx, StatsTable sty) {
        if (stx == null || sty == null) {
            throw new NullPointerException("StatsTableComparator cannot compare null objects");
        }
        int sign = this.ascending ? 1 : -1;
        int result = 0;
        if (this.sortKey.equals("average_live_cells_per_slice_last_five_minutes")) {
            result = this.compareDoubles(stx.averageLiveCellsPerSliceLastFiveMinutes, sty.averageLiveCellsPerSliceLastFiveMinutes);
        } else if (this.sortKey.equals("average_tombstones_per_slice_last_five_minutes")) {
            result = this.compareDoubles(stx.averageTombstonesPerSliceLastFiveMinutes, sty.averageTombstonesPerSliceLastFiveMinutes);
        } else if (this.sortKey.equals("bloom_filter_false_positives")) {
            result = sign * ((Long)stx.bloomFilterFalsePositives).compareTo((Long)sty.bloomFilterFalsePositives);
        } else if (this.sortKey.equals("bloom_filter_false_ratio")) {
            result = this.compareDoubles((Double)stx.bloomFilterFalseRatio, (Double)sty.bloomFilterFalseRatio);
        } else if (this.sortKey.equals("bloom_filter_off_heap_memory_used")) {
            if (stx.bloomFilterOffHeapUsed && !sty.bloomFilterOffHeapUsed) {
                return sign;
            }
            if (!stx.bloomFilterOffHeapUsed && sty.bloomFilterOffHeapUsed) {
                return sign * -1;
            }
            result = !stx.bloomFilterOffHeapUsed && !sty.bloomFilterOffHeapUsed ? 0 : this.compareFileSizes(stx.bloomFilterOffHeapMemoryUsed, sty.bloomFilterOffHeapMemoryUsed);
        } else if (this.sortKey.equals("bloom_filter_space_used")) {
            result = this.compareFileSizes(stx.bloomFilterSpaceUsed, sty.bloomFilterSpaceUsed);
        } else if (this.sortKey.equals("compacted_partition_maximum_bytes")) {
            result = sign * Long.valueOf(stx.compactedPartitionMaximumBytes).compareTo(sty.compactedPartitionMaximumBytes);
        } else if (this.sortKey.equals("compacted_partition_mean_bytes")) {
            result = sign * Long.valueOf(stx.compactedPartitionMeanBytes).compareTo(sty.compactedPartitionMeanBytes);
        } else if (this.sortKey.equals("compacted_partition_minimum_bytes")) {
            result = sign * Long.valueOf(stx.compactedPartitionMinimumBytes).compareTo(sty.compactedPartitionMinimumBytes);
        } else if (this.sortKey.equals("compression_metadata_off_heap_memory_used")) {
            if (stx.compressionMetadataOffHeapUsed && !sty.compressionMetadataOffHeapUsed) {
                return sign;
            }
            if (!stx.compressionMetadataOffHeapUsed && sty.compressionMetadataOffHeapUsed) {
                return sign * -1;
            }
            result = !stx.compressionMetadataOffHeapUsed && !sty.compressionMetadataOffHeapUsed ? 0 : this.compareFileSizes(stx.compressionMetadataOffHeapMemoryUsed, sty.compressionMetadataOffHeapMemoryUsed);
        } else {
            if (this.sortKey.equals("full_name")) {
                return sign * stx.fullName.compareTo(sty.fullName);
            }
            if (this.sortKey.equals("index_summary_off_heap_memory_used")) {
                if (stx.indexSummaryOffHeapUsed && !sty.indexSummaryOffHeapUsed) {
                    return sign;
                }
                if (!stx.indexSummaryOffHeapUsed && sty.indexSummaryOffHeapUsed) {
                    return sign * -1;
                }
                result = !stx.indexSummaryOffHeapUsed && !sty.indexSummaryOffHeapUsed ? 0 : this.compareFileSizes(stx.indexSummaryOffHeapMemoryUsed, sty.indexSummaryOffHeapMemoryUsed);
            } else if (this.sortKey.equals("local_read_count") || this.sortKey.equals("reads")) {
                result = sign * Long.valueOf(stx.localReadCount).compareTo(sty.localReadCount);
            } else if (this.sortKey.equals("local_read_latency_ms") || this.sortKey.equals("read_latency")) {
                result = this.compareDoubles(stx.localReadLatencyMs, sty.localReadLatencyMs);
            } else if (this.sortKey.equals("local_write_count") || this.sortKey.equals("writes")) {
                result = sign * Long.valueOf(stx.localWriteCount).compareTo(sty.localWriteCount);
            } else if (this.sortKey.equals("local_write_latency_ms") || this.sortKey.equals("write_latency")) {
                result = this.compareDoubles(stx.localWriteLatencyMs, sty.localWriteLatencyMs);
            } else if (this.sortKey.equals("local_read_write_ratio")) {
                result = this.compareDoubles(stx.localReadWriteRatio, sty.localReadWriteRatio);
            } else if (this.sortKey.equals("maximum_live_cells_per_slice_last_five_minutes")) {
                result = sign * Long.valueOf(stx.maximumLiveCellsPerSliceLastFiveMinutes).compareTo(sty.maximumLiveCellsPerSliceLastFiveMinutes);
            } else if (this.sortKey.equals("maximum_tombstones_per_slice_last_five_minutes")) {
                result = sign * Long.valueOf(stx.maximumTombstonesPerSliceLastFiveMinutes).compareTo(sty.maximumTombstonesPerSliceLastFiveMinutes);
            } else if (this.sortKey.equals("memtable_cell_count")) {
                result = sign * ((Long)stx.memtableCellCount).compareTo((Long)sty.memtableCellCount);
            } else if (this.sortKey.equals("memtable_data_size")) {
                result = this.compareFileSizes(stx.memtableDataSize, sty.memtableDataSize);
            } else if (this.sortKey.equals("memtable_off_heap_memory_used")) {
                if (stx.memtableOffHeapUsed && !sty.memtableOffHeapUsed) {
                    return sign;
                }
                if (!stx.memtableOffHeapUsed && sty.memtableOffHeapUsed) {
                    return sign * -1;
                }
                result = !stx.memtableOffHeapUsed && !sty.memtableOffHeapUsed ? 0 : this.compareFileSizes(stx.memtableOffHeapMemoryUsed, sty.memtableOffHeapMemoryUsed);
            } else if (this.sortKey.equals("memtable_switch_count")) {
                result = sign * ((Long)stx.memtableSwitchCount).compareTo((Long)sty.memtableSwitchCount);
            } else if (this.sortKey.equals("number_of_partitions_estimate")) {
                result = sign * ((Long)stx.numberOfPartitionsEstimate).compareTo((Long)sty.numberOfPartitionsEstimate);
            } else if (this.sortKey.equals("off_heap_memory_used_total")) {
                if (stx.offHeapUsed && !sty.offHeapUsed) {
                    return sign;
                }
                if (!stx.offHeapUsed && sty.offHeapUsed) {
                    return sign * -1;
                }
                result = !stx.offHeapUsed && !sty.offHeapUsed ? 0 : this.compareFileSizes(stx.offHeapMemoryUsedTotal, sty.offHeapMemoryUsedTotal);
            } else if (this.sortKey.equals("pending_flushes")) {
                result = sign * ((Long)stx.pendingFlushes).compareTo((Long)sty.pendingFlushes);
            } else if (this.sortKey.equals("percent_repaired")) {
                result = this.compareDoubles(stx.percentRepaired, sty.percentRepaired);
            } else if (this.sortKey.equals("max_sstable_size")) {
                result = sign * stx.maxSSTableSize.compareTo(sty.maxSSTableSize);
            } else if (this.sortKey.equals("twcs_max_duration")) {
                if (stx.twcsDurationInMillis != null && sty.twcsDurationInMillis == null) {
                    return sign;
                }
                if (stx.twcsDurationInMillis == null && sty.twcsDurationInMillis != null) {
                    return sign * -1;
                }
                if (stx.twcsDurationInMillis == null) {
                    return 0;
                }
                result = sign * stx.twcsDurationInMillis.compareTo(sty.twcsDurationInMillis);
            } else if (this.sortKey.equals("space_used_by_snapshots_total")) {
                result = this.compareFileSizes(stx.spaceUsedBySnapshotsTotal, sty.spaceUsedBySnapshotsTotal);
            } else if (this.sortKey.equals("space_used_live")) {
                result = this.compareFileSizes(stx.spaceUsedLive, sty.spaceUsedLive);
            } else if (this.sortKey.equals("space_used_total")) {
                result = this.compareFileSizes(stx.spaceUsedTotal, sty.spaceUsedTotal);
            } else if (this.sortKey.equals("sstable_compression_ratio")) {
                result = this.compareDoubles((Double)stx.sstableCompressionRatio, (Double)sty.sstableCompressionRatio);
            } else if (this.sortKey.equals("sstable_count")) {
                result = sign * ((Integer)stx.sstableCount).compareTo((Integer)sty.sstableCount);
            } else {
                if (this.sortKey.equals("table_name")) {
                    return sign * stx.tableName.compareTo(sty.tableName);
                }
                if (this.sortKey.equals("sai_local_query_latency_ms")) {
                    result = this.compareDoubles(stx.saiQueryLatencyMs, sty.saiQueryLatencyMs);
                } else if (this.sortKey.equals("sai_post_filtering_read_latency")) {
                    result = this.compareDoubles(stx.saiPostFilteringReadLatencyMs, sty.saiPostFilteringReadLatencyMs);
                } else if (this.sortKey.equals("sai_disk_used_bytes")) {
                    result = this.compareFileSizes(stx.saiDiskUsedBytes, sty.saiDiskUsedBytes);
                } else if (this.sortKey.equals("sai_sstable_indexes_hit")) {
                    result = this.compareDoubles(stx.saiSSTableIndexesHit, sty.saiSSTableIndexesHit);
                } else if (this.sortKey.equals("sai_index_segments_hit")) {
                    result = this.compareDoubles(stx.saiIndexSegmentsHit, sty.saiIndexSegmentsHit);
                } else if (this.sortKey.equals("sai_rows_filtered")) {
                    result = this.compareDoubles(stx.saiRowsFiltered, sty.saiRowsFiltered);
                } else if (this.sortKey.equals("sai_total_query_timeouts")) {
                    result = sign * Long.valueOf(stx.saiTotalQueryTimeouts).compareTo(sty.saiTotalQueryTimeouts);
                } else if (this.sortKey.equals("sai_total_queryable_index_ratio")) {
                    if (stx.saiTotalQueryableIndexRatio == null && sty.saiTotalQueryableIndexRatio != null) {
                        return sign * -1;
                    }
                    if (stx.saiTotalQueryableIndexRatio != null && sty.saiTotalQueryableIndexRatio == null) {
                        return sign;
                    }
                    if (stx.saiTotalQueryableIndexRatio == null && sty.saiTotalQueryableIndexRatio == null) {
                        return 0;
                    }
                    result = sign * stx.saiTotalQueryableIndexRatio.compareTo(sty.saiTotalQueryableIndexRatio);
                } else {
                    throw new IllegalStateException(String.format("Unsupported sort key: %s", this.sortKey));
                }
            }
        }
        return result == 0 ? stx.fullName.compareTo(sty.fullName) : result;
    }
}

