/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.algo.graph.dfs;

import java.util.Iterator;
import org.psjava.algo.graph.bfs.SimpleStopper;
import org.psjava.algo.graph.dfs.DFSStatus;
import org.psjava.algo.graph.dfs.DFSVisitor;
import org.psjava.ds.Collection;
import org.psjava.ds.graph.DirectedEdge;
import org.psjava.ds.graph.Graph;
import org.psjava.ds.map.MutableMap;
import org.psjava.ds.stack.Stack;
import org.psjava.goods.GoodMutableMapFactory;
import org.psjava.goods.GoodStackFactory;

public class DFSCore {
    public static <V> MutableMap<V, DFSStatus> createInitialStatus(Collection<V> vertices) {
        MutableMap r = GoodMutableMapFactory.getInstance().create();
        for (Object v : vertices) {
            r.add(v, DFSStatus.NOT_DISCOVERED);
        }
        return r;
    }

    public static <V, E extends DirectedEdge<V>> void traverse(Graph<V, E> graph, MutableMap<V, DFSStatus> status, V start, DFSVisitor<V, E> visitor) {
        Stack<StackItem<V, Object>> stack = GoodStackFactory.getInstance().create();
        status.replace((DFSStatus)((Object)start), DFSStatus.DISCOVERED);
        SimpleStopper stopper = new SimpleStopper();
        visitor.onDiscovered(start, 0, stopper);
        Iterator<E> iterator = graph.getEdges(start).iterator();
        stack.push(new StackItem<V, Object>(start, null, 0, iterator));
        while (!stack.isEmpty() && !stopper.isStopped()) {
            StackItem item = (StackItem)stack.top();
            if (item.iter.hasNext()) {
                DirectedEdge edge = (DirectedEdge)item.iter.next();
                Object nextv = edge.to();
                DFSStatus nextc = (DFSStatus)((Object)status.get((DFSStatus)((Object)nextv)));
                if (nextc == DFSStatus.NOT_DISCOVERED) {
                    visitor.onWalkDown(edge);
                    status.replace((DFSStatus)((Object)item.v), DFSStatus.DISCOVERED);
                    visitor.onDiscovered(nextv, item.depth + 1, stopper);
                    stack.push(new StackItem(nextv, edge, item.depth + 1, graph.getEdges(nextv).iterator()));
                    continue;
                }
                if (nextc != DFSStatus.DISCOVERED) continue;
                visitor.onBackEdgeFound(edge);
                continue;
            }
            stack.pop();
            status.replace((DFSStatus)((Object)item.v), DFSStatus.EXPLORED);
            visitor.onFinish(item.v, item.depth);
            if (item.e == null) continue;
            visitor.onWalkUp((DirectedEdge)item.e);
        }
    }

    private DFSCore() {
    }

    private static class StackItem<V, E> {
        public V v;
        public E e;
        public int depth;
        public Iterator<E> iter;

        public StackItem(V v, E e, int d, Iterator<E> iter) {
            this.v = v;
            this.e = e;
            this.depth = d;
            this.iter = iter;
        }
    }
}

