/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapper;
import org.apache.cxf.microprofile.client.cdi.InterceptorInvoker;
import org.apache.cxf.microprofile.client.cdi.MPRestClientInvocationContextImpl;

class CDIInterceptorWrapperImpl
implements CDIInterceptorWrapper {
    private static final Logger LOG = LogUtils.getL7dLogger(CDIInterceptorWrapperImpl.class);
    private final CreationalContext<?> creationalContext;
    private final Map<Method, List<InterceptorInvoker>> interceptorInvokers;

    CDIInterceptorWrapperImpl(Class<?> restClient, Object beanManagerObject) {
        BeanManager beanManager = (BeanManager)beanManagerObject;
        this.creationalContext = beanManager != null ? beanManager.createCreationalContext(null) : null;
        this.interceptorInvokers = CDIInterceptorWrapperImpl.initInterceptorInvokers(beanManager, this.creationalContext, restClient);
    }

    private static Map<Method, List<InterceptorInvoker>> initInterceptorInvokers(BeanManager beanManager, CreationalContext<?> creationalContext, Class<?> restClient) {
        HashMap invokers = new HashMap();
        HashMap<Interceptor, Object> interceptorInstances = new HashMap<Interceptor, Object>();
        AnnotatedType restClientType = beanManager.createAnnotatedType(restClient);
        List<Annotation> classBindings = CDIInterceptorWrapperImpl.getBindings(restClientType.getAnnotations(), beanManager);
        for (AnnotatedMethod method : restClientType.getMethods()) {
            Method javaMethod = method.getJavaMember();
            if (javaMethod.isDefault() || method.isStatic()) continue;
            List<Annotation> methodBindings = CDIInterceptorWrapperImpl.getBindings(method.getAnnotations(), beanManager);
            if (classBindings.isEmpty() && methodBindings.isEmpty()) continue;
            Annotation[] interceptorBindings = CDIInterceptorWrapperImpl.merge(methodBindings, classBindings);
            ArrayList interceptors = new ArrayList(beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, interceptorBindings));
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Resolved interceptors from beanManager, " + String.valueOf(beanManager) + ":" + String.valueOf(interceptors));
            }
            if (interceptors.isEmpty()) continue;
            ArrayList<InterceptorInvoker> chain = new ArrayList<InterceptorInvoker>();
            for (Interceptor interceptor : interceptors) {
                chain.add(new InterceptorInvoker(interceptor, interceptorInstances.computeIfAbsent(interceptor, i -> beanManager.getReference((Bean)i, (Type)i.getBeanClass(), creationalContext))));
            }
            invokers.put(javaMethod, chain);
        }
        return invokers.isEmpty() ? Collections.emptyMap() : invokers;
    }

    private static Annotation[] merge(List<Annotation> methodBindings, List<Annotation> classBindings) {
        Set types = methodBindings.stream().map(a -> a.annotationType()).collect(Collectors.toSet());
        ArrayList<Annotation> merged = new ArrayList<Annotation>(methodBindings);
        for (Annotation annotation : classBindings) {
            if (types.contains(annotation.annotationType())) continue;
            merged.add(annotation);
        }
        return merged.toArray(new Annotation[0]);
    }

    private static List<Annotation> getBindings(Set<Annotation> annotations, BeanManager beanManager) {
        if (annotations == null || annotations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Annotation> bindings = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            if (!beanManager.isInterceptorBinding(annotation.annotationType())) continue;
            bindings.add(annotation);
        }
        return bindings;
    }

    @Override
    public Object invoke(Object restClient, Method method, Object[] params, Callable<Object> callable) throws Exception {
        List<InterceptorInvoker> invokers = this.interceptorInvokers.get(method);
        if (invokers == null || invokers.isEmpty()) {
            return callable.call();
        }
        return new MPRestClientInvocationContextImpl(restClient, method, params, invokers, callable).proceed();
    }
}

