/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.mtom;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.type.mtom.AbstractXOPType;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.ByteDataSource;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.message.Attachment;

public class ByteArrayType
extends AbstractXOPType {
    public ByteArrayType(boolean useXmimeBinaryType, String expectedContentTypes) {
        super(useXmimeBinaryType, expectedContentTypes);
        this.setTypeClass((Type)((Object)byte[].class));
    }

    @Override
    protected Object readAttachment(Attachment att, Context context) throws IOException {
        DataHandler handler = att.getDataHandler();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byArray;
            block11: {
                InputStream is = handler.getInputStream();
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)out);
                    byArray = out.toByteArray();
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return byArray;
        }
    }

    @Override
    protected Attachment createAttachment(Object object, String id) {
        byte[] data = (byte[])object;
        ByteDataSource source = new ByteDataSource(data);
        source.setContentType(this.getContentType(object, null));
        AttachmentImpl att = new AttachmentImpl(id, new DataHandler((DataSource)source));
        att.setXOP(true);
        return att;
    }

    @Override
    protected String getContentType(Object object, Context context) {
        return "application/octet-stream";
    }

    @Override
    protected Object wrapBytes(byte[] bareBytes, String contentType) {
        return bareBytes;
    }

    @Override
    protected byte[] getBytes(Object object) {
        return (byte[])object;
    }
}

