/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import java.lang.ref.Cleaner;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.IndexingObjectStore;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.CleanerSupport;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.signature.X509CRL;

public class X509CRLImpl
extends AbstractXMLObject
implements X509CRL {
    @Nonnull
    private static final IndexingObjectStore<String> B64_CRL_STORE = new IndexingObjectStore();
    @Nonnull
    private static final Cleaner CLEANER = CleanerSupport.getInstance(X509CRLImpl.class);
    @Nullable
    private Cleaner.Cleanable cleanable;
    @Nullable
    private String b64CRLIndex;

    protected X509CRLImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Nullable
    public String getValue() {
        return (String)B64_CRL_STORE.get(this.b64CRLIndex);
    }

    public void setValue(@Nullable String newValue) {
        String newCRL;
        String currentCRL = (String)B64_CRL_STORE.get(this.b64CRLIndex);
        if (!Objects.equals(currentCRL, newCRL = this.prepareForAssignment(currentCRL, newValue))) {
            if (this.cleanable != null) {
                this.cleanable.clean();
                this.cleanable = null;
            }
            this.b64CRLIndex = B64_CRL_STORE.put((Object)newCRL);
            if (this.b64CRLIndex != null) {
                this.cleanable = CLEANER.register((Object)this, new CleanerState(this.b64CRLIndex));
            }
        }
    }

    @Nullable
    @Unmodifiable
    @NotLive
    public List<XMLObject> getOrderedChildren() {
        return null;
    }

    static class CleanerState
    implements Runnable {
        @Nonnull
        private final String index;

        public CleanerState(@Nonnull String idx) {
            this.index = (String)Constraint.isNotNull((Object)idx, (String)"Index cannot be null");
        }

        @Override
        public void run() {
            B64_CRL_STORE.remove(this.index);
        }
    }
}

