/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.io.QuietException;
import org.eclipse.jetty.util.ExceptionUtil;

public interface HttpException
extends QuietException {
    public int getCode();

    public String getReason();

    public static HttpException asHttpException(Throwable throwable) {
        if (throwable instanceof IllegalArgumentException) {
            IllegalArgumentException iae = (IllegalArgumentException)throwable;
            return iae;
        }
        if (throwable instanceof IllegalStateException) {
            IllegalStateException ise = (IllegalStateException)throwable;
            return ise;
        }
        if (throwable instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)throwable;
            return re;
        }
        if (throwable instanceof java.lang.IllegalArgumentException) {
            return new IllegalArgumentException(400, throwable.getMessage(), throwable);
        }
        if (throwable instanceof java.lang.IllegalStateException) {
            return new IllegalStateException(400, throwable.getMessage(), throwable);
        }
        if (throwable instanceof java.lang.RuntimeException) {
            return new RuntimeException(400, throwable.getMessage(), throwable);
        }
        return new RuntimeException(400, throwable.getMessage(), throwable);
    }

    public static void throwAsUnchecked(HttpException httpException) {
        if (httpException instanceof Throwable) {
            Throwable throwable = (Throwable)((Object)httpException);
            ExceptionUtil.ifExceptionThrowUnchecked((Throwable)throwable);
        }
        throw new IllegalStateException(httpException.getCode(), httpException.getReason());
    }

    public static void throwAsUncheckedHttpException(Throwable throwable) {
        HttpException.throwAsUnchecked(HttpException.asHttpException(throwable));
    }

    public static void throwIfHttpException(Throwable th) {
        if (th instanceof HttpException) {
            HttpException he = (HttpException)((Object)th);
            HttpException.throwAsUnchecked(he);
        }
    }

    public static class IllegalArgumentException
    extends java.lang.IllegalArgumentException
    implements HttpException {
        private final int _code;
        private final String _reason;

        public IllegalArgumentException(int code) {
            this(code, null, null);
        }

        public IllegalArgumentException(int code, String reason) {
            this(code, reason, null);
        }

        public IllegalArgumentException(int code, String reason, Throwable cause) {
            super(code + ": " + reason, cause);
            assert (code == 0 || HttpStatus.isClientError(code) || HttpStatus.isServerError(code));
            this._code = code;
            this._reason = reason;
        }

        @Override
        public int getCode() {
            return this._code;
        }

        @Override
        public String getReason() {
            return this._reason;
        }
    }

    public static class IllegalStateException
    extends java.lang.IllegalStateException
    implements HttpException {
        private final int _code;
        private final String _reason;

        public IllegalStateException(int code) {
            this(code, null, null);
        }

        public IllegalStateException(int code, String reason) {
            this(code, reason, null);
        }

        public IllegalStateException(int code, String reason, Throwable cause) {
            super(code + ": " + reason, cause);
            assert (code == 0 || HttpStatus.isClientError(code) || HttpStatus.isServerError(code));
            this._code = code;
            this._reason = reason;
        }

        @Override
        public int getCode() {
            return this._code;
        }

        @Override
        public String getReason() {
            return this._reason;
        }
    }

    public static class RuntimeException
    extends java.lang.RuntimeException
    implements HttpException {
        private final int _code;
        private final String _reason;

        public RuntimeException(int code) {
            this(code, null, null);
        }

        public RuntimeException(int code, String reason) {
            this(code, reason, null);
        }

        public RuntimeException(int code, Throwable cause) {
            this(code, null, cause);
        }

        public RuntimeException(int code, String reason, Throwable cause) {
            super(code + ": " + reason, cause);
            assert (code == 0 || HttpStatus.isClientError(code) || HttpStatus.isServerError(code));
            this._code = code;
            this._reason = reason;
        }

        @Override
        public int getCode() {
            return this._code;
        }

        @Override
        public String getReason() {
            return this._reason;
        }

        public IllegalStateException asIllegalStateException() {
            return new IllegalStateException(this._code, this._reason, this.getCause());
        }
    }
}

