/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.file;

import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCConnectionProvider;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFile;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactoryDriver;
import org.apache.activemq.artemis.jdbc.store.file.PostgresLargeObjectManager;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PostgresSequentialSequentialFileDriver
extends JDBCSequentialFileFactoryDriver {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String POSTGRES_OID_KEY = "POSTGRES_OID_KEY";
    private PostgresLargeObjectManager largeObjectManager;

    public PostgresSequentialSequentialFileDriver() throws SQLException {
    }

    public PostgresSequentialSequentialFileDriver(JDBCConnectionProvider connectionProvider, SQLProvider provider) {
        this.setJdbcConnectionProvider(connectionProvider);
        this.setSqlProvider(provider);
    }

    @Override
    protected void prepareStatements() {
        this.largeObjectManager = new PostgresLargeObjectManager();
        this.deleteFile = this.sqlProvider.getDeleteFileSQL();
        this.createFile = this.sqlProvider.getInsertFileSQL();
        this.createFileAutogeneratedKeys = 1;
        this.selectFileByFileName = this.sqlProvider.getSelectFileByFileName();
        this.copyFileRecord = this.sqlProvider.getCopyFileRecordByIdSQL();
        this.renameFile = this.sqlProvider.getUpdateFileNameByIdSQL();
        this.readLargeObject = this.sqlProvider.getReadLargeObjectSQL();
        this.appendToLargeObject = this.sqlProvider.getAppendToLargeObjectSQL();
        this.selectFileNamesByExtension = this.sqlProvider.getSelectFileNamesByExtensionSQL();
    }

    @Override
    public void createFile(JDBCSequentialFile file) throws SQLException {
        try (Connection connection = this.connectionProvider.getConnection();){
            try (PreparedStatement createFile = connection.prepareStatement(this.createFile, this.createFileAutogeneratedKeys);){
                connection.setAutoCommit(false);
                Long oid = this.largeObjectManager.createLO(connection);
                file.setOid(oid);
                if (logger.isDebugEnabled()) {
                    logger.debug("Creating file {} with oid={}", (Object)file.getFileName(), (Object)oid);
                }
                createFile.setString(1, file.getFileName());
                createFile.setString(2, file.getExtension());
                createFile.setLong(3, oid);
                createFile.executeUpdate();
                try (ResultSet keys = createFile.getGeneratedKeys();){
                    keys.next();
                    file.setId(keys.getLong(1));
                }
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
        }
    }

    @Override
    public void loadFile(JDBCSequentialFile file) throws SQLException {
        try (Connection connection = this.connectionProvider.getConnection();
             PreparedStatement readLargeObject = connection.prepareStatement(this.readLargeObject);){
            connection.setAutoCommit(false);
            readLargeObject.setLong(1, file.getId());
            try (ResultSet rs = readLargeObject.executeQuery();){
                if (rs.next()) {
                    file.setWritePosition(this.getPostgresLargeObjectSize(file));
                }
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
        }
    }

    @Override
    public int writeToFile(JDBCSequentialFile file, byte[] data, boolean append) throws SQLException {
        try (Connection connection = this.connectionProvider.getConnection();){
            Long oid = this.getOID(file);
            try {
                connection.setAutoCommit(false);
                Object largeObject = this.largeObjectManager.open(connection, oid, 131072);
                if (append) {
                    this.largeObjectManager.seek(largeObject, this.largeObjectManager.size(largeObject));
                } else {
                    this.largeObjectManager.truncate(largeObject, 0);
                }
                this.largeObjectManager.write(largeObject, data);
                this.largeObjectManager.close(largeObject);
                connection.commit();
            }
            catch (Exception e) {
                connection.rollback();
                throw e;
            }
            int n = data.length;
            return n;
        }
    }

    @Override
    public int readFromFile(JDBCSequentialFile file, ByteBuffer bytes) throws SQLException {
        long oid = this.getOID(file);
        Connection connection = this.connectionProvider.getConnection();
        try {
            connection.setAutoCommit(false);
            Object largeObject = this.largeObjectManager.open(connection, oid, 262144);
            int readLength = (int)this.calculateReadLength(this.largeObjectManager.size(largeObject), bytes.remaining(), file.position());
            if (readLength > 0) {
                if (file.position() > 0L) {
                    this.largeObjectManager.seek(largeObject, (int)file.position());
                }
                byte[] data = this.largeObjectManager.read(largeObject, readLength);
                bytes.put(data);
            }
            this.largeObjectManager.close(largeObject);
            connection.commit();
            int n = readLength;
            return n;
        }
        catch (SQLException e) {
            connection.rollback();
            throw e;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private Long getOID(JDBCSequentialFile file) throws SQLException {
        Long value;
        if (file.getOid() != -1L) {
            return file.getOid();
        }
        Long oid = (Long)file.getMetaData(POSTGRES_OID_KEY);
        if (oid == null) {
            try (Connection connection = this.connectionProvider.getConnection();
                 PreparedStatement readLargeObject = connection.prepareStatement(this.readLargeObject);){
                connection.setAutoCommit(false);
                readLargeObject.setLong(1, file.getId());
                try (ResultSet rs = readLargeObject.executeQuery();){
                    if (rs.next()) {
                        file.addMetaData(POSTGRES_OID_KEY, rs.getLong(1));
                    }
                    connection.commit();
                }
                catch (SQLException e) {
                    connection.rollback();
                    throw e;
                }
            }
        }
        if ((value = (Long)file.getMetaData(POSTGRES_OID_KEY)) != null) {
            file.setOid(value);
        }
        return value;
    }

    private int getPostgresLargeObjectSize(JDBCSequentialFile file) throws SQLException {
        int size = 0;
        Long oid = this.getOID(file);
        if (oid != null) {
            try (Connection connection = this.connectionProvider.getConnection();){
                try {
                    connection.setAutoCommit(false);
                    Object largeObject = this.largeObjectManager.open(connection, oid, 262144);
                    size = this.largeObjectManager.size(largeObject);
                    this.largeObjectManager.close(largeObject);
                    connection.commit();
                }
                catch (SQLException e) {
                    connection.rollback();
                    throw e;
                }
            }
        }
        return size;
    }

    @Override
    public void deleteFile(JDBCSequentialFile file) throws SQLException {
        Long oid = this.getOID(file);
        if (logger.isDebugEnabled()) {
            logger.debug("Deleting file {} with oid={}", (Object)file.getFileName(), (Object)oid);
        }
        if (oid != null) {
            try (Connection connection = this.connectionProvider.getConnection();){
                this.largeObjectManager.deleteLO(connection, oid);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        super.deleteFile(file);
    }
}

