/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public final class SegmentHeaders
extends Enum<SegmentHeaders> {
    public static final /* enum */ SegmentHeaders LOG_FILE = new SegmentHeaders("%flf");
    public static final /* enum */ SegmentHeaders CLOSE_FILE = new SegmentHeaders("!ctl");
    public static final /* enum */ SegmentHeaders JUMP_LIST = new SegmentHeaders("+jmp");
    public static final /* enum */ SegmentHeaders CHUNK_START = new SegmentHeaders("-st-");
    public static final /* enum */ SegmentHeaders FILE_CHUNK = new SegmentHeaders("~fc~");
    private final byte[] value;
    private final int validator;
    private static final /* synthetic */ SegmentHeaders[] $VALUES;

    public static SegmentHeaders[] values() {
        return (SegmentHeaders[])$VALUES.clone();
    }

    public static SegmentHeaders valueOf(String name) {
        return Enum.valueOf(SegmentHeaders.class, name);
    }

    private SegmentHeaders(String value) {
        assert (value.length() == 4);
        try {
            this.value = value.getBytes("ASCII");
            this.validator = this.produceIntValue(this.value);
        }
        catch (UnsupportedEncodingException unsupported) {
            throw new AssertionError((Object)unsupported);
        }
    }

    private int produceIntValue(byte[] value) {
        if (value.length != 4) {
            throw new AssertionError((Object)"segment headers must be 4 bytes long");
        }
        int val = value[0] & 0xFF;
        val <<= 8;
        val |= value[1] & 0xFF;
        val <<= 8;
        val |= value[2] & 0xFF;
        val <<= 8;
        return val |= value[3] & 0xFF;
    }

    public boolean validate(int test) {
        return test == this.validator;
    }

    public boolean validate(byte[] test) {
        return Arrays.equals(this.value, test);
    }

    public int getIntValue() {
        return this.validator;
    }

    public byte[] getBytes() {
        return this.value;
    }

    public String toString() {
        try {
            return new String(this.value, "ASCII");
        }
        catch (UnsupportedEncodingException unsupported) {
            throw new AssertionError((Object)unsupported);
        }
    }

    static {
        $VALUES = new SegmentHeaders[]{LOG_FILE, CLOSE_FILE, JUMP_LIST, CHUNK_START, FILE_CHUNK};
    }
}

