/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.unparsers;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.nio.LongBuffer;
import org.apache.daffodil.api.DataLocation;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.io.DataInputStream;
import org.apache.daffodil.io.DataOutputStream;
import org.apache.daffodil.io.DirectOrBufferedDataOutputStream;
import org.apache.daffodil.io.StringDataInputStreamForUnparse;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.exceptions.ThrowsSDE;
import org.apache.daffodil.lib.iapi.DaffodilTunables;
import org.apache.daffodil.lib.schema.annotation.props.gen.BitOrder;
import org.apache.daffodil.lib.util.Cursor;
import org.apache.daffodil.lib.util.LocalStack;
import org.apache.daffodil.lib.util.MStackOfLong;
import org.apache.daffodil.lib.util.MStackOfMaybe;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.lib.util.Maybe$WithNulls$;
import org.apache.daffodil.lib.util.MaybeULong$;
import org.apache.daffodil.lib.util.ThreadSafePool;
import org.apache.daffodil.runtime1.iapi.DFDL;
import org.apache.daffodil.runtime1.infoset.DIArray;
import org.apache.daffodil.runtime1.infoset.DIDocument;
import org.apache.daffodil.runtime1.infoset.DIElement;
import org.apache.daffodil.runtime1.infoset.DINode;
import org.apache.daffodil.runtime1.infoset.InfosetAccessor;
import org.apache.daffodil.runtime1.infoset.InfosetInputter;
import org.apache.daffodil.runtime1.processors.CheckBitOrderAndCharsetEv;
import org.apache.daffodil.runtime1.processors.CheckByteAndBitOrderEv;
import org.apache.daffodil.runtime1.processors.DataLoc;
import org.apache.daffodil.runtime1.processors.DataProcessor;
import org.apache.daffodil.runtime1.processors.DelimiterStackUnparseNode;
import org.apache.daffodil.runtime1.processors.EscapeSchemeUnparserHelper;
import org.apache.daffodil.runtime1.processors.Failure;
import org.apache.daffodil.runtime1.processors.NonTermRuntimeData;
import org.apache.daffodil.runtime1.processors.ParseOrUnparseState;
import org.apache.daffodil.runtime1.processors.RuntimeData;
import org.apache.daffodil.runtime1.processors.TermRuntimeData;
import org.apache.daffodil.runtime1.processors.UnparseResult;
import org.apache.daffodil.runtime1.processors.VariableBox;
import org.apache.daffodil.runtime1.processors.VariableInstance;
import org.apache.daffodil.runtime1.processors.VariableRuntimeData;
import org.apache.daffodil.runtime1.processors.dfa.DFADelimiter;
import org.apache.daffodil.runtime1.processors.unparsers.UState$;
import org.apache.daffodil.runtime1.processors.unparsers.UStateMain;
import org.apache.daffodil.runtime1.processors.unparsers.UnparseError;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public abstract class UState
extends ParseOrUnparseState
implements Cursor<InfosetAccessor> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(UState.class.getDeclaredField("unparseResult$lzy1"));
    private final VariableBox vbox;
    private DirectOrBufferedDataOutputStream _dataOutputStream;
    private volatile Object unparseResult$lzy1;
    private final boolean releaseUnneededInfoset;

    public static UStateMain createInitialUState(OutputStream outputStream, DFDL.DataProcessor dataProcessor, InfosetInputter infosetInputter, boolean bl) {
        return UState$.MODULE$.createInitialUState(outputStream, dataProcessor, infosetInputter, bl);
    }

    public UState(VariableBox vbox, Seq<Diagnostic> diagnosticsArg, Object dataProcArg, DaffodilTunables tunable, boolean areDebugging) {
        this.vbox = vbox;
        super(vbox, diagnosticsArg, dataProcArg, tunable);
        this.releaseUnneededInfoset = !areDebugging && tunable.releaseUnneededInfoset();
    }

    private DaffodilTunables tunable$accessor() {
        return super.tunable();
    }

    @Override
    public final void setVariable(VariableRuntimeData vrd, Object newValue, ThrowsSDE referringContext) {
        this.vbox.vmap().setVariable(vrd, newValue, referringContext, this);
    }

    @Override
    public final Object getVariable(VariableRuntimeData vrd, ThrowsSDE referringContext) {
        return this.vbox.vmap().readVariable(vrd, referringContext, this);
    }

    @Override
    public final VariableInstance newVariableInstance(VariableRuntimeData vrd) {
        return this.variableMap().newVariableInstance(vrd);
    }

    @Override
    public final void removeVariableInstance(VariableRuntimeData vrd) {
        this.variableMap().removeVariableInstance(vrd);
    }

    public abstract void pushTRD(TermRuntimeData var1);

    public abstract Object maybeTopTRD();

    public abstract TermRuntimeData popTRD(TermRuntimeData var1);

    public String toString() {
        Object object = this.currentInfosetNodeMaybe();
        String elt = Maybe$.MODULE$.isDefined$extension(object) ? "node=" + this.currentInfosetNode().toString() : "";
        return "UState(" + elt + " DOS=" + this.getDataOutputStream().toString() + ")";
    }

    public DirectOrBufferedDataOutputStream _dataOutputStream() {
        return this._dataOutputStream;
    }

    public void _dataOutputStream_$eq(DirectOrBufferedDataOutputStream x$1) {
        this._dataOutputStream = x$1;
    }

    public DirectOrBufferedDataOutputStream getDataOutputStream() {
        return this._dataOutputStream();
    }

    public void setDataOutputStream(DirectOrBufferedDataOutputStream dos) {
        this._dataOutputStream_$eq(dos);
    }

    public abstract DINode currentInfosetNode();

    public abstract Object currentInfosetNodeMaybe();

    public abstract MStackOfMaybe<EscapeSchemeUnparserHelper> escapeSchemeEVCache();

    public abstract LocalStack<StringDataInputStreamForUnparse> withUnparserDataInputStream();

    public abstract LocalStack<Tuple2<ByteArrayOutputStream, DirectOrBufferedDataOutputStream>> withByteArrayOutputStream();

    public abstract List<DFADelimiter> allTerminatingMarkup();

    public abstract DelimiterStackUnparseNode localDelimiters();

    public abstract void pushDelimiters(DelimiterStackUnparseNode var1);

    public abstract void popDelimiters();

    public abstract MStackOfMaybe<DINode> currentInfosetNodeStack();

    public abstract MStackOfLong arrayIterationIndexStack();

    public abstract MStackOfLong occursIndexStack();

    public abstract MStackOfLong childIndexStack();

    public abstract MStackOfLong groupIndexStack();

    public abstract void moveOverOneArrayIterationIndexOnly();

    public abstract void moveOverOneOccursIndexOnly();

    public abstract void moveOverOneGroupIndexOnly();

    public abstract void moveOverOneElementChildOnly();

    public abstract InfosetAccessor inspectOrError();

    public abstract InfosetAccessor advanceOrError();

    public abstract boolean isInspectArrayEnd();

    @Override
    public Object dataStream() {
        return Maybe$.MODULE$.apply(this.getDataOutputStream());
    }

    @Override
    public Object currentNode() {
        return this.currentInfosetNodeMaybe();
    }

    @Override
    public boolean hasInfoset() {
        Object object = this.currentInfosetNodeMaybe();
        return Maybe$.MODULE$.isDefined$extension(object);
    }

    @Override
    public DIElement infoset() {
        if (!Maybe$WithNulls$.MODULE$.isDefined(this.currentInfosetNode())) {
            throw Assert$.MODULE$.abort("Invariant broken: org.apache.daffodil.lib.util.Maybe.WithNulls.isDefined[org.apache.daffodil.runtime1.infoset.DINode](UState.this.currentInfosetNode)");
        }
        DINode dINode = this.currentInfosetNode();
        if (dINode instanceof DIArray) {
            DIArray a = (DIArray)dINode;
            return a.apply(this.arrayIterationPos());
        }
        if (dINode instanceof DIElement) {
            DIElement e = (DIElement)dINode;
            return this.thisElement();
        }
        throw new MatchError((Object)dINode);
    }

    @Override
    public DIElement thisElement() {
        if (!Maybe$WithNulls$.MODULE$.isDefined(this.currentInfosetNode())) {
            throw Assert$.MODULE$.usageError("org.apache.daffodil.lib.util.Maybe.WithNulls.isDefined[org.apache.daffodil.runtime1.infoset.DINode](UState.this.currentInfosetNode)");
        }
        DINode curNode = this.currentInfosetNode();
        DINode dINode = curNode;
        if (dINode instanceof DIElement) {
            DIElement e = (DIElement)dINode;
            return e;
        }
        if (dINode instanceof DIArray) {
            DIArray a = (DIArray)dINode;
            return a.parent();
        }
        throw new MatchError((Object)dINode);
    }

    private Object maybeCurrentInfosetElement() {
        if (!Maybe$WithNulls$.MODULE$.isDefined(this.currentInfosetNode())) {
            return Maybe$.MODULE$.Nope();
        }
        DINode dINode = this.currentInfosetNode();
        if (dINode instanceof DIElement) {
            DIElement e = (DIElement)dINode;
            return Maybe$One$.MODULE$.apply(e);
        }
        if (dINode instanceof DIArray) {
            DIArray a = (DIArray)dINode;
            return Maybe$.MODULE$.Nope();
        }
        throw new MatchError((Object)dINode);
    }

    @Override
    public DataLocation currentLocation() {
        Object m = this.maybeCurrentInfosetElement();
        Object mrd = Maybe$.MODULE$.isDefined$extension(m) ? Maybe$.MODULE$.apply(((DIElement)Maybe$.MODULE$.value$extension(m)).runtimeData()) : Maybe$.MODULE$.Nope();
        return new DataLoc(this.bitPos1b(), this.bitLimit1b(), (Either<DataOutputStream, DataInputStream>)package$.MODULE$.Left().apply((Object)this.getDataOutputStream()), mrd);
    }

    public UnparseResult unparseResult() {
        Object object = this.unparseResult$lzy1;
        if (object instanceof UnparseResult) {
            return (UnparseResult)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (UnparseResult)this.unparseResult$lzyINIT1();
    }

    private Object unparseResult$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.unparseResult$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    UnparseResult unparseResult = null;
                    try {
                        Object object3 = this.dataProc();
                        unparseResult = new UnparseResult((DataProcessor)Maybe$.MODULE$.get$extension(object3), this);
                        object2 = unparseResult == null ? LazyVals.NullValue$.MODULE$ : unparseResult;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.unparseResult$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return unparseResult;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public long bitPos0b() {
        if (MaybeULong$.MODULE$.isDefined$extension(this.getDataOutputStream().maybeAbsBitPos0b())) {
            return MaybeULong$.MODULE$.get$extension(this.getDataOutputStream().maybeAbsBitPos0b());
        }
        return 0L;
    }

    @Override
    public long bitLimit0b() {
        return this.getDataOutputStream().maybeRelBitLimit0b();
    }

    public long charPos() {
        return -1L;
    }

    @Override
    public final void notifyDebugging(boolean flag) {
        this.getDataOutputStream().setDebugging(flag);
    }

    public void addUnparseError(UnparseError ue) {
        this.diagnostics_$eq((Seq<Diagnostic>)((Seq)this.diagnostics().$plus$colon((Object)ue)));
        this._processorStatus_$eq(new Failure(ue));
    }

    @Override
    public final void checkBitOrder() {
        DirectOrBufferedDataOutputStream dos = this.getDataOutputStream();
        boolean isChanging = this.isUnparseBitOrderChanging(dos);
        if (isChanging) {
            RuntimeData runtimeData = this.processor().context();
            if (runtimeData instanceof TermRuntimeData) {
                TermRuntimeData trd = (TermRuntimeData)runtimeData;
                Object mcboc = trd.maybeCheckBitOrderAndCharsetEv();
                Object mcbbo = trd.maybeCheckByteAndBitOrderEv();
                if (Maybe$.MODULE$.isDefined$extension(mcboc)) {
                    ((CheckBitOrderAndCharsetEv)Maybe$.MODULE$.get$extension(mcboc)).evaluate(this);
                }
                if (Maybe$.MODULE$.isDefined$extension(mcbbo)) {
                    ((CheckByteAndBitOrderEv)Maybe$.MODULE$.get$extension(mcbbo)).evaluate(this);
                }
            }
            BitOrder bo = this.bitOrder();
            dos.setPriorBitOrder(bo);
            this.splitOnUknownByteAlignmentBitOrderChange(dos);
            return;
        }
    }

    private boolean isUnparseBitOrderChanging(DirectOrBufferedDataOutputStream dos) {
        BitOrder newBitOrder;
        RuntimeData ctxt = this.processor().context();
        RuntimeData runtimeData = ctxt;
        if (runtimeData instanceof NonTermRuntimeData) {
            NonTermRuntimeData ntrd = (NonTermRuntimeData)runtimeData;
            return false;
        }
        BitOrder priorBitOrder = dos.priorBitOrder();
        return priorBitOrder != (newBitOrder = this.bitOrder());
    }

    private void splitOnUknownByteAlignmentBitOrderChange(DirectOrBufferedDataOutputStream dos) {
        boolean bl;
        long mabp = dos.maybeAbsBitPos0b();
        boolean mabpDefined = MaybeULong$.MODULE$.isDefined$extension(mabp);
        if (mabpDefined && dos.isAligned(8)) {
            bl = dos.fragmentLastByteLimit() != 0;
        } else if (!mabpDefined) {
            bl = true;
        } else {
            long bp1b = MaybeULong$.MODULE$.get$extension(mabp) + 1L;
            throw this.SDE("Can only change dfdl:bitOrder on a byte boundary. Bit pos (1b) was %s. Should be 1 mod 8, was %s (mod 8)", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)bp1b), BoxesRunTime.boxToLong((long)(bp1b % 8L))}));
        }
        boolean isSplitNeeded = bl;
        if (isSplitNeeded) {
            if (!dos.isBuffering()) {
                throw Assert$.MODULE$.abort("Invariant broken: dos.isBuffering");
            }
            UState uState = this;
            if (!(uState instanceof UStateMain)) {
                throw Assert$.MODULE$.invariantFailed("State must be a UStateMain when splitting for bit order change");
            }
            UStateMain m = (UStateMain)uState;
            UState finfo = m.cloneForSuspension(dos);
            DirectOrBufferedDataOutputStream newDOS = dos.addBuffered();
            this.setDataOutputStream(newDOS);
            dos.setFinished(finfo);
            return;
        }
    }

    @Override
    public ThreadSafePool<Tuple2<CharBuffer, LongBuffer>> regexMatchStatePool() {
        throw Assert$.MODULE$.usageError("Not to be used.");
    }

    public abstract DIDocument documentElement();

    public final boolean releaseUnneededInfoset() {
        return this.releaseUnneededInfoset;
    }

    @Override
    public Object delimitedParseResult() {
        return Maybe$.MODULE$.Nope();
    }
}

