/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.ReadableNilFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.java.util.common.IAE;

public class OutputChannel {
    @Nullable
    private volatile WritableFrameChannel writableChannel;
    @Nullable
    private volatile MemoryAllocator frameMemoryAllocator;
    private final Supplier<ReadableFrameChannel> readableChannelSupplier;
    private final int partitionNumber;

    private OutputChannel(@Nullable WritableFrameChannel writableChannel, @Nullable MemoryAllocator frameMemoryAllocator, Supplier<ReadableFrameChannel> readableChannelSupplier, int partitionNumber) {
        this.writableChannel = writableChannel;
        this.frameMemoryAllocator = frameMemoryAllocator;
        this.readableChannelSupplier = readableChannelSupplier;
        this.partitionNumber = partitionNumber;
        if (partitionNumber < 0 && partitionNumber != -1) {
            throw new IAE("Invalid partition number [%d]", partitionNumber);
        }
    }

    public static OutputChannel pair(WritableFrameChannel writableChannel, MemoryAllocator frameMemoryAllocator, Supplier<ReadableFrameChannel> readableChannelSupplier, int partitionNumber) {
        return new OutputChannel((WritableFrameChannel)Preconditions.checkNotNull((Object)writableChannel, (Object)"writableChannel"), (MemoryAllocator)Preconditions.checkNotNull((Object)frameMemoryAllocator, (Object)"frameMemoryAllocator"), readableChannelSupplier, partitionNumber);
    }

    public static OutputChannel immediatelyReadablePair(WritableFrameChannel writableChannel, MemoryAllocator frameMemoryAllocator, ReadableFrameChannel readableChannel, int partitionNumber) {
        return new OutputChannel((WritableFrameChannel)Preconditions.checkNotNull((Object)writableChannel, (Object)"writableChannel"), (MemoryAllocator)Preconditions.checkNotNull((Object)frameMemoryAllocator, (Object)"frameMemoryAllocator"), () -> readableChannel, partitionNumber);
    }

    public static OutputChannel readOnly(ReadableFrameChannel readableChannel, int partitionNumber) {
        return OutputChannel.readOnly(() -> readableChannel, partitionNumber);
    }

    public static OutputChannel readOnly(Supplier<ReadableFrameChannel> readableChannelSupplier, int partitionNumber) {
        return new OutputChannel(null, null, readableChannelSupplier, partitionNumber);
    }

    public static OutputChannel nil(int partitionNumber) {
        return new OutputChannel(null, null, () -> ReadableNilFrameChannel.INSTANCE, partitionNumber);
    }

    public WritableFrameChannel getWritableChannel() {
        WritableFrameChannel theWritableChannel = this.writableChannel;
        if (theWritableChannel == null) {
            throw DruidException.defensive("Writable channel is not available. The output channel might be marked as read-only, hence no writes are allowed.", new Object[0]);
        }
        return theWritableChannel;
    }

    public MemoryAllocator getFrameMemoryAllocator() {
        MemoryAllocator theFrameMemoryAllocator = this.frameMemoryAllocator;
        if (theFrameMemoryAllocator == null) {
            throw DruidException.defensive("Frame memory allocator is not available. The output channel might be marked as read-only, hence no writes are allowed.", new Object[0]);
        }
        return theFrameMemoryAllocator;
    }

    public ReadableFrameChannel getReadableChannel() {
        return this.readableChannelSupplier.get();
    }

    public Supplier<ReadableFrameChannel> getReadableChannelSupplier() {
        return this.readableChannelSupplier;
    }

    public int getPartitionNumber() {
        return this.partitionNumber;
    }

    public OutputChannel mapWritableChannel(Function<WritableFrameChannel, WritableFrameChannel> mapFn) {
        WritableFrameChannel theWritableChannel = this.writableChannel;
        MemoryAllocator theFrameMemoryAllocator = this.frameMemoryAllocator;
        if (theWritableChannel == null || theFrameMemoryAllocator == null) {
            return this;
        }
        return new OutputChannel(mapFn.apply(theWritableChannel), theFrameMemoryAllocator, this.readableChannelSupplier, this.partitionNumber);
    }

    public OutputChannel readOnly() {
        return this.isReadOnly() ? this : OutputChannel.readOnly(this.readableChannelSupplier, this.partitionNumber);
    }

    public boolean isReadOnly() {
        return this.writableChannel == null;
    }

    public void convertToReadOnly() {
        this.writableChannel = null;
        this.frameMemoryAllocator = null;
    }
}

