/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.java.util.common.guava.YieldingSequenceBase;

public class ExplodingSequence<T>
extends YieldingSequenceBase<T> {
    private final Sequence<T> baseSequence;
    private final boolean getThrowsException;
    private final boolean closeThrowsException;
    private final AtomicLong closed = new AtomicLong();

    public ExplodingSequence(Sequence<T> baseSequence, boolean getThrowsException, boolean closeThrowsException) {
        this.baseSequence = baseSequence;
        this.getThrowsException = getThrowsException;
        this.closeThrowsException = closeThrowsException;
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
        return this.wrapYielder(this.baseSequence.toYielder(initValue, accumulator));
    }

    public long getCloseCount() {
        return this.closed.get();
    }

    private <OutType> Yielder<OutType> wrapYielder(final Yielder<OutType> baseYielder) {
        return new Yielder<OutType>(){

            @Override
            public OutType get() {
                if (ExplodingSequence.this.getThrowsException) {
                    throw new RuntimeException("get");
                }
                return baseYielder.get();
            }

            @Override
            public Yielder<OutType> next(OutType initValue) {
                return ExplodingSequence.this.wrapYielder(baseYielder.next(initValue));
            }

            @Override
            public boolean isDone() {
                return baseYielder.isDone();
            }

            @Override
            public void close() throws IOException {
                ExplodingSequence.this.closed.incrementAndGet();
                if (ExplodingSequence.this.closeThrowsException) {
                    throw new IOException("close");
                }
                baseYielder.close();
            }
        };
    }
}

