/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;

public class StringAnyBufferAggregator
implements BufferAggregator {
    private static final int FOUND_AND_NULL_FLAG_VALUE = -1;
    private static final int NOT_FOUND_FLAG_VALUE = -2;
    private static final int FOUND_VALUE_OFFSET = 4;
    private final BaseObjectColumnValueSelector valueSelector;
    private final int maxStringBytes;
    private final boolean aggregateMultipleValues;

    public StringAnyBufferAggregator(BaseObjectColumnValueSelector valueSelector, int maxStringBytes, boolean aggregateMultipleValues) {
        this.valueSelector = valueSelector;
        this.maxStringBytes = maxStringBytes;
        this.aggregateMultipleValues = aggregateMultipleValues;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putInt(position, -2);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        if (buf.getInt(position) == -2) {
            String foundValue = this.readValue(this.valueSelector.getObject());
            if (foundValue != null) {
                ByteBuffer mutationBuffer = buf.duplicate();
                mutationBuffer.position(position + 4);
                mutationBuffer.limit(position + 4 + this.maxStringBytes);
                int len = StringUtils.toUtf8WithLimit(foundValue, mutationBuffer);
                mutationBuffer.putInt(position, len);
            } else {
                buf.putInt(position, -1);
            }
        }
    }

    private String readValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            List objectList = (List)object;
            if (objectList.size() == 0) {
                return null;
            }
            if (objectList.size() == 1) {
                return DimensionHandlerUtils.convertObjectToString(objectList.get(0));
            }
            if (this.aggregateMultipleValues) {
                return DimensionHandlerUtils.convertObjectToString(objectList);
            }
            return DimensionHandlerUtils.convertObjectToString(objectList.get(0));
        }
        return DimensionHandlerUtils.convertObjectToString(object);
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        ByteBuffer copyBuffer = buf.duplicate();
        copyBuffer.position(position);
        int stringSizeBytes = copyBuffer.getInt();
        if (stringSizeBytes >= 0) {
            byte[] valueBytes = new byte[stringSizeBytes];
            copyBuffer.get(valueBytes, 0, stringSizeBytes);
            return StringUtils.fromUtf8(valueBytes);
        }
        return null;
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("StringAnyBufferAggregator does not support getFloat()");
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("StringAnyBufferAggregator does not support getLong()");
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("StringAnyBufferAggregator does not support getDouble()");
    }

    @Override
    public void close() {
    }
}

