/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.vector;

import com.google.common.collect.Iterables;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.Order;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.vector.VectorCursor;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class VectorCursorGranularizer {
    private final VectorCursor cursor;
    private final Iterable<Interval> bucketIterable;
    @Nullable
    private final VectorValueSelector timeSelector;
    @Nullable
    private long[] timestamps = null;
    private int startOffset = 0;
    private int endOffset = 0;

    @Nullable
    public static VectorCursorGranularizer create(VectorCursor cursor, @Nullable TimeBoundaryInspector timeBoundaryInspector, Order timeOrder, Granularity granularity, Interval queryInterval) {
        VectorValueSelector timeSelector;
        if (!Granularities.ALL.equals(granularity) && timeOrder == Order.NONE) {
            throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.UNSUPPORTED).build("Cannot use granularity[%s] on non-time-sorted data.", granularity);
        }
        Interval clippedQueryInterval = timeBoundaryInspector != null ? queryInterval.overlap((ReadableInterval)new Interval((ReadableInstant)timeBoundaryInspector.getMinTime(), (ReadableInstant)granularity.bucketEnd(timeBoundaryInspector.getMaxTime()))) : queryInterval;
        if (clippedQueryInterval == null) {
            return null;
        }
        Iterable<Interval> bucketIterable = granularity.getIterable(clippedQueryInterval);
        Interval firstBucket = granularity.bucket(clippedQueryInterval.getStart());
        if (firstBucket.contains((ReadableInterval)clippedQueryInterval)) {
            assert (Iterables.size(bucketIterable) == 1);
            timeSelector = null;
        } else {
            timeSelector = cursor.getColumnSelectorFactory().makeValueSelector("__time");
        }
        return new VectorCursorGranularizer(cursor, bucketIterable, timeSelector);
    }

    private VectorCursorGranularizer(VectorCursor cursor, Iterable<Interval> bucketIterable, @Nullable VectorValueSelector timeSelector) {
        this.cursor = cursor;
        this.bucketIterable = bucketIterable;
        this.timeSelector = timeSelector;
    }

    public void setCurrentOffsets(Interval bucketInterval) {
        long timeStart = bucketInterval.getStartMillis();
        long timeEnd = bucketInterval.getEndMillis();
        int vectorSize = this.cursor.getCurrentVectorSize();
        this.endOffset = 0;
        if (this.timeSelector != null) {
            if (this.timestamps == null) {
                this.timestamps = this.timeSelector.getLongVector();
            }
            while (this.startOffset < vectorSize && this.timestamps[this.startOffset] < timeStart) {
                ++this.startOffset;
            }
            this.endOffset = vectorSize - 1;
            while (this.endOffset >= this.startOffset && this.timestamps[this.endOffset] >= timeEnd) {
                --this.endOffset;
            }
            ++this.endOffset;
        } else {
            this.endOffset = vectorSize;
        }
    }

    public boolean advanceCursorWithinBucket() {
        if (this.endOffset == this.cursor.getCurrentVectorSize()) {
            this.cursor.advance();
            if (this.timeSelector != null && !this.cursor.isDone()) {
                this.timestamps = this.timeSelector.getLongVector();
            }
            this.startOffset = 0;
            return true;
        }
        return false;
    }

    public Iterable<Interval> getBucketIterable() {
        return this.bucketIterable;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }
}

