/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="TooManyWarnings")
public class TooManyWarningsFault
extends BaseMSQFault {
    static final String CODE = "TooManyWarnings";
    private final int maxWarnings;
    private final String rootErrorCode;

    @JsonCreator
    public TooManyWarningsFault(@JsonProperty(value="maxWarnings") int maxWarnings, @JsonProperty(value="rootErrorCode") String rootErrorCode) {
        super(CODE, "Too many warnings of type %s generated (max = %d)", rootErrorCode, maxWarnings);
        this.maxWarnings = maxWarnings;
        this.rootErrorCode = rootErrorCode;
    }

    @JsonProperty
    public int getMaxWarnings() {
        return this.maxWarnings;
    }

    @JsonProperty
    public String getRootErrorCode() {
        return this.rootErrorCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TooManyWarningsFault that = (TooManyWarningsFault)o;
        return this.maxWarnings == that.maxWarnings && Objects.equals(this.rootErrorCode, that.rootErrorCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxWarnings, this.rootErrorCode);
    }
}

