/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.kll;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllFloatsSketchBuildBufferAggregatorHelper;
import org.apache.druid.segment.vector.VectorValueSelector;

public class KllFloatsSketchBuildVectorAggregator
implements VectorAggregator {
    private final VectorValueSelector selector;
    private final KllFloatsSketchBuildBufferAggregatorHelper helper;

    KllFloatsSketchBuildVectorAggregator(VectorValueSelector selector, int size, int maxIntermediateSize) {
        this.selector = selector;
        this.helper = new KllFloatsSketchBuildBufferAggregatorHelper(size, maxIntermediateSize);
    }

    public void init(ByteBuffer buf, int position) {
        this.helper.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        float[] floats = this.selector.getFloatVector();
        boolean[] nulls = this.selector.getNullVector();
        KllFloatsSketch sketch = (KllFloatsSketch)this.helper.getSketchAtPosition(buf, position);
        for (int i = startRow; i < endRow; ++i) {
            if (nulls != null && nulls[i]) continue;
            sketch.update(floats[i]);
        }
    }

    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        float[] floats = this.selector.getFloatVector();
        boolean[] nulls = this.selector.getNullVector();
        for (int i = 0; i < numRows; ++i) {
            int idx;
            int n = idx = rows != null ? rows[i] : i;
            if (nulls != null && nulls[idx]) continue;
            int position = positions[i] + positionOffset;
            ((KllFloatsSketch)this.helper.getSketchAtPosition(buf, position)).update(floats[idx]);
        }
    }

    public Object get(ByteBuffer buf, int position) {
        return this.helper.get(buf, position);
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuf, ByteBuffer newBuf) {
        this.helper.relocate(oldPosition, newPosition, oldBuf, newBuf);
    }

    public void close() {
        this.helper.clear();
    }
}

