/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.io.decorations;

import com.github.rvesse.airline.io.decorations.AnsiDecorationProvider;

public enum BasicDecoration implements AnsiDecorationProvider
{
    BOLD(1, 22, "Bold"),
    FAINT(2, 22, "Faint"),
    ITALIC(3, 23, "Italic"),
    UNDERLINE(4, 24, "Underline"),
    BLINK_SLOW(5, 25, "Blink (Slow)"),
    BLINK_RAPID(6, 25, "Blink (Rapid)"),
    IMAGE_NEGATIVE(7, 27, "Image Negative"),
    CONCEAL(8, 28, "Concealed"),
    STRIKE_THROUGH(9, 29, "Strike-Through");

    private final int enableCode;
    private final int disableCode;
    private final String name;

    private BasicDecoration(int enable, int disable, String name) {
        this.enableCode = enable;
        this.disableCode = disable;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getAnsiDecorationEnabledControlCode() {
        return this.getAnsiControlCode(this.enableCode);
    }

    @Override
    public String getAnsiDecorationDisabledControlCode() {
        return this.getAnsiControlCode(this.disableCode);
    }

    private String getAnsiControlCode(int code) {
        StringBuilder builder = new StringBuilder();
        builder.append("\u001b[").append(code).append('m');
        return builder.toString();
    }
}

