/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.batch;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.storage.blob.batch.BlobBatch;
import com.azure.storage.blob.batch.BlobBatchAsyncClient;
import com.azure.storage.blob.batch.BlobBatchClientBuilder;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.time.Duration;
import java.util.List;

@ServiceClient(builder=BlobBatchClientBuilder.class)
public final class BlobBatchClient {
    private final BlobBatchAsyncClient client;

    BlobBatchClient(BlobBatchAsyncClient client) {
        this.client = client;
    }

    BlobBatchAsyncClient getClient() {
        return this.client;
    }

    public BlobBatch getBlobBatch() {
        return this.client.getBlobBatch();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void submitBatch(BlobBatch batch) {
        this.submitBatchWithResponse(batch, true, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> submitBatchWithResponse(BlobBatch batch, boolean throwOnAnyFailure, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.submitBatchWithResponse(batch, throwOnAnyFailure, context), (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<Response<Void>> deleteBlobs(List<String> blobUrls, DeleteSnapshotsOptionType deleteOptions) {
        return new PagedIterable(this.client.deleteBlobs(blobUrls, deleteOptions));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<Response<Void>> deleteBlobs(List<String> blobUrls, DeleteSnapshotsOptionType deleteOptions, Duration timeout, Context context) {
        return new PagedIterable(this.client.deleteBlobsWithTimeout(blobUrls, deleteOptions, timeout, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<Response<Void>> setBlobsAccessTier(List<String> blobUrls, AccessTier accessTier) {
        return new PagedIterable(this.client.setBlobsAccessTier(blobUrls, accessTier));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<Response<Void>> setBlobsAccessTier(List<String> blobUrls, AccessTier accessTier, Duration timeout, Context context) {
        return new PagedIterable(this.client.setBlobsAccessTierWithTimeout(blobUrls, accessTier, timeout, context));
    }
}

