/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ResourceClaim;
import io.kubernetes.client.openapi.models.V1ResourceClaimBuilder;
import io.kubernetes.client.openapi.models.V1ResourceClaimFluentImpl;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.kubernetes.client.openapi.models.V1ResourceRequirementsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class V1ResourceRequirementsFluentImpl<A extends V1ResourceRequirementsFluent<A>>
extends BaseFluent<A>
implements V1ResourceRequirementsFluent<A> {
    private ArrayList<V1ResourceClaimBuilder> claims;
    private Map<String, Quantity> limits;
    private Map<String, Quantity> requests;

    public V1ResourceRequirementsFluentImpl() {
    }

    public V1ResourceRequirementsFluentImpl(V1ResourceRequirements instance) {
        if (instance != null) {
            this.withClaims(instance.getClaims());
            this.withLimits(instance.getLimits());
            this.withRequests(instance.getRequests());
        }
    }

    @Override
    public A addToClaims(int index, V1ResourceClaim item) {
        if (this.claims == null) {
            this.claims = new ArrayList();
        }
        V1ResourceClaimBuilder builder = new V1ResourceClaimBuilder(item);
        if (index < 0 || index >= this.claims.size()) {
            this._visitables.get("claims").add(builder);
            this.claims.add(builder);
        } else {
            this._visitables.get("claims").add(index, builder);
            this.claims.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToClaims(int index, V1ResourceClaim item) {
        if (this.claims == null) {
            this.claims = new ArrayList();
        }
        V1ResourceClaimBuilder builder = new V1ResourceClaimBuilder(item);
        if (index < 0 || index >= this.claims.size()) {
            this._visitables.get("claims").add(builder);
            this.claims.add(builder);
        } else {
            this._visitables.get("claims").set(index, builder);
            this.claims.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToClaims(V1ResourceClaim ... items) {
        if (this.claims == null) {
            this.claims = new ArrayList();
        }
        for (V1ResourceClaim item : items) {
            V1ResourceClaimBuilder builder = new V1ResourceClaimBuilder(item);
            this._visitables.get("claims").add(builder);
            this.claims.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToClaims(Collection<V1ResourceClaim> items) {
        if (this.claims == null) {
            this.claims = new ArrayList();
        }
        for (V1ResourceClaim item : items) {
            V1ResourceClaimBuilder builder = new V1ResourceClaimBuilder(item);
            this._visitables.get("claims").add(builder);
            this.claims.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromClaims(V1ResourceClaim ... items) {
        for (V1ResourceClaim item : items) {
            V1ResourceClaimBuilder builder = new V1ResourceClaimBuilder(item);
            this._visitables.get("claims").remove(builder);
            if (this.claims == null) continue;
            this.claims.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromClaims(Collection<V1ResourceClaim> items) {
        for (V1ResourceClaim item : items) {
            V1ResourceClaimBuilder builder = new V1ResourceClaimBuilder(item);
            this._visitables.get("claims").remove(builder);
            if (this.claims == null) continue;
            this.claims.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromClaims(Predicate<V1ResourceClaimBuilder> predicate) {
        if (this.claims == null) {
            return (A)this;
        }
        Iterator<V1ResourceClaimBuilder> each = this.claims.iterator();
        Object visitables = this._visitables.get("claims");
        while (each.hasNext()) {
            V1ResourceClaimBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1ResourceClaim> getClaims() {
        return this.claims != null ? V1ResourceRequirementsFluentImpl.build(this.claims) : null;
    }

    @Override
    public List<V1ResourceClaim> buildClaims() {
        return this.claims != null ? V1ResourceRequirementsFluentImpl.build(this.claims) : null;
    }

    @Override
    public V1ResourceClaim buildClaim(int index) {
        return this.claims.get(index).build();
    }

    @Override
    public V1ResourceClaim buildFirstClaim() {
        return this.claims.get(0).build();
    }

    @Override
    public V1ResourceClaim buildLastClaim() {
        return this.claims.get(this.claims.size() - 1).build();
    }

    @Override
    public V1ResourceClaim buildMatchingClaim(Predicate<V1ResourceClaimBuilder> predicate) {
        for (V1ResourceClaimBuilder item : this.claims) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingClaim(Predicate<V1ResourceClaimBuilder> predicate) {
        for (V1ResourceClaimBuilder item : this.claims) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withClaims(List<V1ResourceClaim> claims) {
        if (this.claims != null) {
            this._visitables.get("claims").clear();
        }
        if (claims != null) {
            this.claims = new ArrayList();
            for (V1ResourceClaim item : claims) {
                this.addToClaims(item);
            }
        } else {
            this.claims = null;
        }
        return (A)this;
    }

    @Override
    public A withClaims(V1ResourceClaim ... claims) {
        if (this.claims != null) {
            this.claims.clear();
            this._visitables.remove("claims");
        }
        if (claims != null) {
            for (V1ResourceClaim item : claims) {
                this.addToClaims(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasClaims() {
        return this.claims != null && !this.claims.isEmpty();
    }

    @Override
    public V1ResourceRequirementsFluent.ClaimsNested<A> addNewClaim() {
        return new ClaimsNestedImpl();
    }

    @Override
    public V1ResourceRequirementsFluent.ClaimsNested<A> addNewClaimLike(V1ResourceClaim item) {
        return new ClaimsNestedImpl(-1, item);
    }

    @Override
    public V1ResourceRequirementsFluent.ClaimsNested<A> setNewClaimLike(int index, V1ResourceClaim item) {
        return new ClaimsNestedImpl(index, item);
    }

    @Override
    public V1ResourceRequirementsFluent.ClaimsNested<A> editClaim(int index) {
        if (this.claims.size() <= index) {
            throw new RuntimeException("Can't edit claims. Index exceeds size.");
        }
        return this.setNewClaimLike(index, this.buildClaim(index));
    }

    @Override
    public V1ResourceRequirementsFluent.ClaimsNested<A> editFirstClaim() {
        if (this.claims.size() == 0) {
            throw new RuntimeException("Can't edit first claims. The list is empty.");
        }
        return this.setNewClaimLike(0, this.buildClaim(0));
    }

    @Override
    public V1ResourceRequirementsFluent.ClaimsNested<A> editLastClaim() {
        int index = this.claims.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last claims. The list is empty.");
        }
        return this.setNewClaimLike(index, this.buildClaim(index));
    }

    @Override
    public V1ResourceRequirementsFluent.ClaimsNested<A> editMatchingClaim(Predicate<V1ResourceClaimBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.claims.size(); ++i) {
            if (!predicate.test(this.claims.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching claims. No match found.");
        }
        return this.setNewClaimLike(index, this.buildClaim(index));
    }

    @Override
    public A addToLimits(String key, Quantity value) {
        if (this.limits == null && key != null && value != null) {
            this.limits = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.limits.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLimits(Map<String, Quantity> map) {
        if (this.limits == null && map != null) {
            this.limits = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.limits.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLimits(String key) {
        if (this.limits == null) {
            return (A)this;
        }
        if (key != null && this.limits != null) {
            this.limits.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLimits(Map<String, Quantity> map) {
        if (this.limits == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.limits == null) continue;
                this.limits.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getLimits() {
        return this.limits;
    }

    @Override
    public <K, V> A withLimits(Map<String, Quantity> limits) {
        this.limits = limits == null ? null : new LinkedHashMap<String, Quantity>(limits);
        return (A)this;
    }

    @Override
    public Boolean hasLimits() {
        return this.limits != null;
    }

    @Override
    public A addToRequests(String key, Quantity value) {
        if (this.requests == null && key != null && value != null) {
            this.requests = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.requests.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToRequests(Map<String, Quantity> map) {
        if (this.requests == null && map != null) {
            this.requests = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.requests.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequests(String key) {
        if (this.requests == null) {
            return (A)this;
        }
        if (key != null && this.requests != null) {
            this.requests.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequests(Map<String, Quantity> map) {
        if (this.requests == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.requests == null) continue;
                this.requests.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getRequests() {
        return this.requests;
    }

    @Override
    public <K, V> A withRequests(Map<String, Quantity> requests) {
        this.requests = requests == null ? null : new LinkedHashMap<String, Quantity>(requests);
        return (A)this;
    }

    @Override
    public Boolean hasRequests() {
        return this.requests != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ResourceRequirementsFluentImpl that = (V1ResourceRequirementsFluentImpl)o;
        if (!Objects.equals(this.claims, that.claims)) {
            return false;
        }
        if (!Objects.equals(this.limits, that.limits)) {
            return false;
        }
        return Objects.equals(this.requests, that.requests);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.claims, this.limits, this.requests, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.claims != null) {
            sb.append("claims:");
            sb.append(this.claims + ",");
        }
        if (this.limits != null && !this.limits.isEmpty()) {
            sb.append("limits:");
            sb.append(this.limits + ",");
        }
        if (this.requests != null && !this.requests.isEmpty()) {
            sb.append("requests:");
            sb.append(this.requests);
        }
        sb.append("}");
        return sb.toString();
    }

    class ClaimsNestedImpl<N>
    extends V1ResourceClaimFluentImpl<V1ResourceRequirementsFluent.ClaimsNested<N>>
    implements V1ResourceRequirementsFluent.ClaimsNested<N>,
    Nested<N> {
        V1ResourceClaimBuilder builder;
        int index;

        ClaimsNestedImpl(int index, V1ResourceClaim item) {
            this.index = index;
            this.builder = new V1ResourceClaimBuilder(this, item);
        }

        ClaimsNestedImpl() {
            this.index = -1;
            this.builder = new V1ResourceClaimBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ResourceRequirementsFluentImpl.this.setToClaims(this.index, this.builder.build());
        }

        @Override
        public N endClaim() {
            return this.and();
        }
    }
}

