/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionUtils;
import org.apache.flink.table.expressions.ModelReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.TableReferenceExpression;
import org.apache.flink.table.expressions.TypeLiteralExpression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.expressions.resolver.rules.ResolverRule;
import org.apache.flink.table.expressions.resolver.rules.RuleExpressionVisitor;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.ModelSemantics;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.TableAggregateFunctionDefinition;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.functions.TableSemantics;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.operations.PartitionQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.StaticArgument;
import org.apache.flink.table.types.inference.StaticArgumentTrait;
import org.apache.flink.table.types.inference.SystemTypeInference;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
final class ResolveCallByArgumentsRule
implements ResolverRule {
    ResolveCallByArgumentsRule() {
    }

    @Override
    public List<Expression> apply(List<Expression> expression, ResolverRule.ResolutionContext context) {
        TypeInferenceUtil.SurroundingInfo surroundingInfo = context.getOutputDataType().map(TypeInferenceUtil.SurroundingInfo::of).orElse(null);
        return expression.stream().flatMap(e -> e.accept(new ResolvingCallVisitor(context, surroundingInfo)).stream()).collect(Collectors.toList());
    }

    private static class TableApiModelSemantics
    implements ModelSemantics {
        private final ModelReferenceExpression modelRef;

        private TableApiModelSemantics(ModelReferenceExpression modelRef) {
            this.modelRef = modelRef;
        }

        @Override
        public DataType inputDataType() {
            return this.modelRef.getInputDataType();
        }

        @Override
        public DataType outputDataType() {
            return this.modelRef.getOutputDataType();
        }
    }

    private static class TableApiTableSemantics
    implements TableSemantics {
        private final QueryOperation operation;
        private final DataType dataType;
        private final StaticArgument staticArg;

        private TableApiTableSemantics(QueryOperation operation, DataType dataType, StaticArgument staticArg) {
            this.operation = operation;
            this.dataType = dataType;
            this.staticArg = staticArg;
        }

        @Override
        public DataType dataType() {
            DataType typed = this.staticArg.getDataType().orElse(null);
            if (typed != null) {
                return typed;
            }
            return this.dataType;
        }

        @Override
        public int[] partitionByColumns() {
            if (!(this.operation instanceof PartitionQueryOperation)) {
                return new int[0];
            }
            PartitionQueryOperation partitionOperation = (PartitionQueryOperation)this.operation;
            return partitionOperation.getPartitionKeys();
        }

        @Override
        public int[] orderByColumns() {
            return new int[0];
        }

        @Override
        public int timeColumn() {
            return -1;
        }

        @Override
        public Optional<ChangelogMode> changelogMode() {
            return Optional.empty();
        }
    }

    private static class TableApiCallContext
    implements CallContext {
        private final DataTypeFactory typeFactory;
        private final String functionName;
        private final FunctionDefinition definition;
        private final List<ResolvedExpression> resolvedArgs;
        private final boolean isGroupedAggregation;
        @Nullable
        private final List<StaticArgument> staticArguments;

        public TableApiCallContext(DataTypeFactory typeFactory, String functionName, FunctionDefinition definition, List<ResolvedExpression> resolvedArgs, boolean isGroupedAggregation, @Nullable List<StaticArgument> staticArguments) {
            this.typeFactory = typeFactory;
            this.functionName = functionName;
            this.definition = definition;
            this.resolvedArgs = resolvedArgs;
            this.isGroupedAggregation = isGroupedAggregation;
            this.staticArguments = staticArguments;
        }

        @Override
        public DataTypeFactory getDataTypeFactory() {
            return this.typeFactory;
        }

        @Override
        public FunctionDefinition getFunctionDefinition() {
            return this.definition;
        }

        @Override
        public boolean isArgumentLiteral(int pos) {
            ResolvedExpression arg = this.getArgument(pos);
            return arg instanceof ValueLiteralExpression || arg instanceof TypeLiteralExpression;
        }

        @Override
        public boolean isArgumentNull(int pos) {
            ResolvedExpression arg = this.getArgument(pos);
            if (ApiExpressionUtils.isFunction(arg, BuiltInFunctionDefinitions.DEFAULT)) {
                return true;
            }
            if (arg instanceof ValueLiteralExpression) {
                ValueLiteralExpression literal = (ValueLiteralExpression)arg;
                return literal.isNull();
            }
            return false;
        }

        @Override
        public <T> Optional<T> getArgumentValue(int pos, Class<T> clazz) {
            ResolvedExpression arg = this.getArgument(pos);
            if (arg instanceof TypeLiteralExpression) {
                if (!DataType.class.isAssignableFrom(clazz)) {
                    return Optional.empty();
                }
                return Optional.of(arg.getOutputDataType());
            }
            if (arg instanceof ValueLiteralExpression) {
                ValueLiteralExpression literal = (ValueLiteralExpression)arg;
                return literal.getValueAs(clazz);
            }
            return Optional.empty();
        }

        @Override
        public Optional<TableSemantics> getTableSemantics(int pos) {
            StaticArgument staticArg = Optional.ofNullable(this.staticArguments).map(args -> (StaticArgument)args.get(pos)).orElse(null);
            if (staticArg == null || !staticArg.is(StaticArgumentTrait.TABLE)) {
                return Optional.empty();
            }
            ResolvedExpression arg = this.getArgument(pos);
            if (!(arg instanceof TableReferenceExpression)) {
                return Optional.empty();
            }
            TableReferenceExpression tableRef = (TableReferenceExpression)arg;
            TableApiTableSemantics semantics = new TableApiTableSemantics(tableRef.getQueryOperation(), DataTypeUtils.removeTimeAttribute(tableRef.getOutputDataType()), staticArg);
            return Optional.of(semantics);
        }

        @Override
        public Optional<ModelSemantics> getModelSemantics(int pos) {
            StaticArgument staticArg = Optional.ofNullable(this.staticArguments).map(args -> (StaticArgument)args.get(pos)).orElse(null);
            if (staticArg == null || !staticArg.is(StaticArgumentTrait.MODEL)) {
                return Optional.empty();
            }
            ResolvedExpression arg = this.getArgument(pos);
            if (!(arg instanceof ModelReferenceExpression)) {
                return Optional.empty();
            }
            ModelReferenceExpression modelRef = (ModelReferenceExpression)arg;
            TableApiModelSemantics semantics = new TableApiModelSemantics(modelRef);
            return Optional.of(semantics);
        }

        @Override
        public String getName() {
            return this.functionName;
        }

        @Override
        public List<DataType> getArgumentDataTypes() {
            return this.resolvedArgs.stream().map(ResolvedExpression::getOutputDataType).collect(Collectors.toList());
        }

        @Override
        public Optional<DataType> getOutputDataType() {
            return Optional.empty();
        }

        @Override
        public boolean isGroupedAggregation() {
            return this.isGroupedAggregation;
        }

        private ResolvedExpression getArgument(int pos) {
            if (pos >= this.resolvedArgs.size()) {
                throw new IndexOutOfBoundsException(String.format("Not enough arguments to access literal at position %d for function '%s'.", pos, this.functionName));
            }
            return this.resolvedArgs.get(pos);
        }
    }

    private static class ResolvingCallVisitor
    extends RuleExpressionVisitor<List<ResolvedExpression>> {
        @Nullable
        private final TypeInferenceUtil.SurroundingInfo surroundingInfo;

        ResolvingCallVisitor(ResolverRule.ResolutionContext context, @Nullable TypeInferenceUtil.SurroundingInfo surroundingInfo) {
            super(context);
            this.surroundingInfo = surroundingInfo;
        }

        @Override
        public List<ResolvedExpression> visit(UnresolvedCallExpression unresolvedCall) {
            FunctionDefinition definition = unresolvedCall.getFunctionIdentifier().isEmpty() ? this.prepareInlineUserDefinedFunction(unresolvedCall.getFunctionDefinition()) : unresolvedCall.getFunctionDefinition();
            String functionName = unresolvedCall.getFunctionIdentifier().map(FunctionIdentifier::toString).orElseGet(definition::toString);
            TypeInference typeInference = this.getTypeInferenceOrNull(definition);
            UnresolvedCallExpression adaptedCall = this.executeAssignment(functionName, definition, typeInference, unresolvedCall);
            ArrayList<ResolvedExpression> resolvedArgs = new ArrayList<ResolvedExpression>();
            int argCount = adaptedCall.getChildren().size();
            for (int i = 0; i < argCount; ++i) {
                TypeInferenceUtil.SurroundingInfo surroundingInfo = typeInference == null ? null : TypeInferenceUtil.SurroundingInfo.of(functionName, definition, typeInference, argCount, i, this.resolutionContext.isGroupedAggregation());
                ResolvingCallVisitor childResolver = new ResolvingCallVisitor(this.resolutionContext, surroundingInfo);
                resolvedArgs.addAll((Collection<ResolvedExpression>)adaptedCall.getChildren().get(i).accept(childResolver));
            }
            if (definition == BuiltInFunctionDefinitions.FLATTEN) {
                return this.executeFlatten(resolvedArgs);
            }
            return Collections.singletonList(this.runTypeInference(functionName, adaptedCall, typeInference, resolvedArgs, this.surroundingInfo));
        }

        @Override
        protected List<ResolvedExpression> defaultMethod(Expression expression) {
            if (expression instanceof ResolvedExpression) {
                return Collections.singletonList((ResolvedExpression)expression);
            }
            throw new TableException("Unexpected unresolved expression: " + String.valueOf(expression));
        }

        private List<ResolvedExpression> executeFlatten(List<ResolvedExpression> args) {
            if (args.size() != 1) {
                throw new ValidationException("Invalid number of arguments for flattening.");
            }
            ResolvedExpression composite = args.get(0);
            LogicalType compositeType = composite.getOutputDataType().getLogicalType();
            if (LogicalTypeChecks.hasLegacyTypes(compositeType)) {
                return this.flattenLegacyCompositeType(composite);
            }
            return this.flattenCompositeType(composite);
        }

        private List<ResolvedExpression> flattenCompositeType(ResolvedExpression composite) {
            DataType dataType = composite.getOutputDataType();
            LogicalType type = dataType.getLogicalType();
            if (!LogicalTypeChecks.isCompositeType(type)) {
                return Collections.singletonList(composite);
            }
            List<DataType> fieldDataTypes = DataTypeUtils.flattenToDataTypes(dataType);
            List<String> fieldNames = DataTypeUtils.flattenToNames(dataType);
            return IntStream.range(0, fieldDataTypes.size()).mapToObj(idx -> {
                DataType fieldDataType = (DataType)fieldDataTypes.get(idx);
                DataType nullableFieldDataType = type.isNullable() ? (DataType)fieldDataType.nullable() : fieldDataType;
                return this.resolutionContext.postResolutionFactory().get(composite, ApiExpressionUtils.valueLiteral(fieldNames.get(idx)), nullableFieldDataType);
            }).collect(Collectors.toList());
        }

        private List<ResolvedExpression> flattenLegacyCompositeType(ResolvedExpression composite) {
            TypeInformation<?> resultType = TypeConversions.fromDataTypeToLegacyInfo(composite.getOutputDataType());
            if (!(resultType instanceof CompositeType)) {
                return Collections.singletonList(composite);
            }
            CompositeType compositeType = (CompositeType)resultType;
            return IntStream.range(0, resultType.getArity()).mapToObj(idx -> this.resolutionContext.postResolutionFactory().get(composite, ApiExpressionUtils.valueLiteral(compositeType.getFieldNames()[idx]), TypeConversions.fromLegacyInfoToDataType(compositeType.getTypeAt(idx)))).collect(Collectors.toList());
        }

        @Nullable
        private TypeInference getTypeInferenceOrNull(FunctionDefinition definition) {
            TypeInference inference = definition.getTypeInference(this.resolutionContext.typeFactory());
            if (inference.getOutputTypeStrategy() != TypeStrategies.MISSING) {
                return SystemTypeInference.of(definition.getKind(), inference);
            }
            return null;
        }

        private UnresolvedCallExpression executeAssignment(String functionName, FunctionDefinition definition, @Nullable TypeInference inference, UnresolvedCallExpression unresolvedCall) {
            if (definition == BuiltInFunctionDefinitions.ASSIGNMENT) {
                throw new ValidationException("Named arguments via asArgument() can only be used within function calls.");
            }
            if (inference == null) {
                return unresolvedCall;
            }
            List<Expression> actualArgs = unresolvedCall.getChildren();
            List declaredArgs = inference.getStaticArguments().orElse(null);
            Map<String, Expression> namedArgs = this.collectAssignments(functionName, actualArgs);
            if (namedArgs.isEmpty()) {
                List<Expression> reorderedArgs = this.appendDefaultPositionedArguments(declaredArgs, actualArgs);
                this.fillInPtfSpecificPositionedArguments(functionName, definition, declaredArgs, reorderedArgs);
                return unresolvedCall.replaceArgs(reorderedArgs);
            }
            if (declaredArgs == null) {
                throw new ValidationException(String.format("Invalid call to function '%s'. The function does not support named arguments. Please pass the arguments based on positions (i.e. without asArgument()).", functionName));
            }
            this.fillInDefaultNamedArguments(declaredArgs, namedArgs);
            this.fillInPtfSpecificNamedArguments(functionName, definition, declaredArgs, namedArgs, actualArgs);
            try {
                this.validateAssignments(declaredArgs, namedArgs);
            }
            catch (ValidationException e) {
                throw new ValidationException(String.format("Invalid call to function '%s'. If the call uses named arguments, a valid name has to be provided for all passed arguments. %s", functionName, e.getMessage()));
            }
            List<Expression> reorderedArgs = declaredArgs.stream().map(arg -> (Expression)namedArgs.get(arg.getName())).collect(Collectors.toList());
            return unresolvedCall.replaceArgs(reorderedArgs);
        }

        private Map<String, Expression> collectAssignments(String functionName, List<Expression> actualArgs) {
            HashMap<String, Expression> namedArgs = new HashMap<String, Expression>();
            actualArgs.stream().map(this::extractAssignment).filter(Objects::nonNull).forEach(assignment -> {
                if (namedArgs.containsKey(assignment.getKey())) {
                    throw new ValidationException(String.format("Invalid call to function '%s'. Duplicate named argument found: %s", functionName, assignment.getKey()));
                }
                namedArgs.put((String)assignment.getKey(), (Expression)assignment.getValue());
            });
            return namedArgs;
        }

        private Map.Entry<String, Expression> extractAssignment(Expression e) {
            List<Expression> children = e.getChildren();
            if (!ApiExpressionUtils.isFunction(e, BuiltInFunctionDefinitions.ASSIGNMENT) || children.size() != 2) {
                return null;
            }
            String name = ExpressionUtils.stringValue(children.get(0));
            if (name == null) {
                return null;
            }
            return Map.entry(name, children.get(1));
        }

        private void fillInPtfSpecificNamedArguments(String functionName, FunctionDefinition definition, List<StaticArgument> declaredArgs, Map<String, Expression> namedArgs, List<Expression> actualArgs) {
            if (definition.getKind() != FunctionKind.PROCESS_TABLE) {
                return;
            }
            Expression uid = namedArgs.get("uid");
            if (ApiExpressionUtils.isFunction(uid, BuiltInFunctionDefinitions.DEFAULT) && !SystemTypeInference.isInvalidUidForProcessTableFunction(functionName)) {
                namedArgs.put("uid", ApiExpressionUtils.valueLiteral(functionName));
            }
            List declaredTableArgs = declaredArgs.stream().filter(declaredArg -> declaredArg.is(StaticArgumentTrait.TABLE)).collect(Collectors.toList());
            List actualTableArgs = actualArgs.stream().filter(TableReferenceExpression.class::isInstance).collect(Collectors.toList());
            if (declaredTableArgs.size() == 1 && actualTableArgs.size() == 1) {
                namedArgs.put(((StaticArgument)declaredTableArgs.get(0)).getName(), (Expression)actualTableArgs.get(0));
            }
        }

        private void fillInPtfSpecificPositionedArguments(String functionName, FunctionDefinition definition, List<StaticArgument> declaredArgs, List<Expression> actualArgs) {
            if (definition.getKind() != FunctionKind.PROCESS_TABLE || declaredArgs.size() != actualArgs.size()) {
                return;
            }
            int uidPos = actualArgs.size() - 1 - 0;
            Expression uidArg = actualArgs.get(uidPos);
            if (ApiExpressionUtils.isFunction(uidArg, BuiltInFunctionDefinitions.DEFAULT) && !SystemTypeInference.isInvalidUidForProcessTableFunction(functionName)) {
                actualArgs.set(uidPos, ApiExpressionUtils.valueLiteral(functionName));
            }
        }

        private List<Expression> appendDefaultPositionedArguments(@Nullable List<StaticArgument> declaredArgs, List<Expression> actualArgs) {
            if (declaredArgs == null || actualArgs.size() >= declaredArgs.size()) {
                return actualArgs;
            }
            ArrayList<Expression> enrichedArgs = new ArrayList<Expression>(actualArgs);
            IntStream.range(actualArgs.size(), declaredArgs.size()).forEach(pos -> {
                StaticArgument declaredArg = (StaticArgument)declaredArgs.get(pos);
                if (((StaticArgument)declaredArgs.get(pos)).isOptional()) {
                    enrichedArgs.add(this.createDefaultExpression(declaredArg));
                }
            });
            return enrichedArgs;
        }

        private void fillInDefaultNamedArguments(List<StaticArgument> declaredArgs, Map<String, Expression> namedArgs) {
            declaredArgs.forEach(declaredArg -> {
                if (declaredArg.isOptional()) {
                    namedArgs.putIfAbsent(declaredArg.getName(), this.createDefaultExpression((StaticArgument)declaredArg));
                }
            });
        }

        private Expression createDefaultExpression(StaticArgument declaredArg) {
            DataType dataType = declaredArg.getDataType().orElseThrow(IllegalStateException::new);
            return CallExpression.permanent(BuiltInFunctionDefinitions.DEFAULT, List.of(), dataType);
        }

        private void validateAssignments(List<StaticArgument> declaredArgs, Map<String, Expression> namedArgs) {
            Set<String> providedArgs = namedArgs.keySet();
            Set knownArgs = declaredArgs.stream().map(StaticArgument::getName).collect(Collectors.toSet());
            Set unknownArgs = providedArgs.stream().filter(arg -> !knownArgs.contains(arg)).collect(Collectors.toSet());
            if (!unknownArgs.isEmpty()) {
                throw new ValidationException("Unknown argument names: " + String.valueOf(unknownArgs));
            }
            List missingArgs = declaredArgs.stream().filter(arg -> !providedArgs.contains(arg.getName())).collect(Collectors.toList());
            if (!missingArgs.isEmpty()) {
                throw new ValidationException("Missing required arguments: " + String.valueOf(missingArgs));
            }
        }

        private ResolvedExpression runTypeInference(String functionName, UnresolvedCallExpression unresolvedCall, TypeInference inference, List<ResolvedExpression> resolvedArgs, @Nullable TypeInferenceUtil.SurroundingInfo surroundingInfo) {
            if (inference == null) {
                throw new TableException("Could not get a type inference for function: " + functionName);
            }
            TypeInferenceUtil.Result inferenceResult = TypeInferenceUtil.runTypeInference(inference, new TableApiCallContext(this.resolutionContext.typeFactory(), functionName, unresolvedCall.getFunctionDefinition(), resolvedArgs, this.resolutionContext.isGroupedAggregation(), inference.getStaticArguments().orElse(null)), surroundingInfo);
            List<ResolvedExpression> adaptedArguments = this.castArguments(inferenceResult, resolvedArgs);
            return unresolvedCall.resolve(adaptedArguments, inferenceResult.getOutputDataType());
        }

        private List<ResolvedExpression> castArguments(TypeInferenceUtil.Result inferenceResult, List<ResolvedExpression> resolvedArgs) {
            return IntStream.range(0, resolvedArgs.size()).mapToObj(pos -> {
                ResolvedExpression argument = (ResolvedExpression)resolvedArgs.get(pos);
                DataType argumentType = argument.getOutputDataType();
                DataType expectedType = inferenceResult.getExpectedArgumentTypes().get(pos);
                if (!LogicalTypeCasts.supportsAvoidingCast(argumentType.getLogicalType(), expectedType.getLogicalType())) {
                    return this.resolutionContext.postResolutionFactory().cast(argument, expectedType);
                }
                return argument;
            }).collect(Collectors.toList());
        }

        private FunctionDefinition prepareInlineUserDefinedFunction(FunctionDefinition definition) {
            if (definition instanceof ScalarFunctionDefinition) {
                ScalarFunctionDefinition sf = (ScalarFunctionDefinition)definition;
                UserDefinedFunctionHelper.prepareInstance(this.resolutionContext.configuration(), sf.getScalarFunction());
                return new ScalarFunctionDefinition(sf.getName(), sf.getScalarFunction());
            }
            if (definition instanceof TableFunctionDefinition) {
                TableFunctionDefinition tf = (TableFunctionDefinition)definition;
                UserDefinedFunctionHelper.prepareInstance(this.resolutionContext.configuration(), tf.getTableFunction());
                return new TableFunctionDefinition(tf.getName(), tf.getTableFunction(), tf.getResultType());
            }
            if (definition instanceof AggregateFunctionDefinition) {
                AggregateFunctionDefinition af = (AggregateFunctionDefinition)definition;
                UserDefinedFunctionHelper.prepareInstance(this.resolutionContext.configuration(), af.getAggregateFunction());
                return new AggregateFunctionDefinition(af.getName(), af.getAggregateFunction(), af.getResultTypeInfo(), af.getAccumulatorTypeInfo());
            }
            if (definition instanceof TableAggregateFunctionDefinition) {
                TableAggregateFunctionDefinition taf = (TableAggregateFunctionDefinition)definition;
                UserDefinedFunctionHelper.prepareInstance(this.resolutionContext.configuration(), taf.getTableAggregateFunction());
                return new TableAggregateFunctionDefinition(taf.getName(), taf.getTableAggregateFunction(), taf.getResultTypeInfo(), taf.getAccumulatorTypeInfo());
            }
            if (definition instanceof UserDefinedFunction) {
                UserDefinedFunctionHelper.prepareInstance(this.resolutionContext.configuration(), (UserDefinedFunction)definition);
            }
            return definition;
        }
    }
}

