/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.statement.ParenthesedStatement;
import net.sf.jsqlparser.statement.delete.ParenthesedDelete;
import net.sf.jsqlparser.statement.insert.ParenthesedInsert;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.update.ParenthesedUpdate;

public class WithItem<T extends ParenthesedStatement> {
    private T statement;
    private Alias alias;
    private List<SelectItem<?>> withItemList;
    private boolean recursive = false;
    private boolean materialized = false;

    public WithItem(T statement, Alias alias) {
        this.statement = statement;
        this.alias = alias;
    }

    public WithItem() {
        this(null, null);
    }

    public T getParenthesedStatement() {
        return this.statement;
    }

    public void setParenthesedStatement(T statement) {
        this.statement = statement;
    }

    public WithItem<T> withParenthesedStatement(T statement) {
        this.setParenthesedStatement(statement);
        return this;
    }

    public Alias getAlias() {
        return this.alias;
    }

    public String getAliasName() {
        return this.alias != null ? this.alias.getName() : null;
    }

    public String getUnquotedAliasName() {
        return this.alias != null ? this.alias.getUnquotedName() : null;
    }

    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    public WithItem<?> withAlias(Alias alias) {
        this.setAlias(alias);
        return this;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isMaterialized() {
        return this.materialized;
    }

    public void setMaterialized(boolean materialized) {
        this.materialized = materialized;
    }

    public List<SelectItem<?>> getWithItemList() {
        return this.withItemList;
    }

    public void setWithItemList(List<SelectItem<?>> withItemList) {
        this.withItemList = withItemList;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.recursive ? "RECURSIVE " : "");
        if (this.alias != null) {
            builder.append(this.alias.getName());
        }
        if (this.withItemList != null) {
            builder.append("(");
            int size = this.withItemList.size();
            for (int i = 0; i < size; ++i) {
                builder.append(this.withItemList.get(i)).append(i < size - 1 ? "," : "");
            }
            builder.append(")");
        }
        builder.append(" AS ");
        builder.append(this.materialized ? "MATERIALIZED " : "");
        builder.append(this.statement);
        return builder.toString();
    }

    public <T, S> T accept(SelectVisitor<T> selectVisitor, S context) {
        return selectVisitor.visit(this, context);
    }

    public WithItem<?> withWithItemList(List<SelectItem<?>> withItemList) {
        this.setWithItemList(withItemList);
        return this;
    }

    public WithItem<?> withRecursive(boolean recursive, boolean materialized) {
        this.setRecursive(recursive);
        this.setMaterialized(materialized);
        return this;
    }

    public WithItem<?> addWithItemList(SelectItem<?> ... withItemList) {
        List collection = Optional.ofNullable(this.getWithItemList()).orElseGet(ArrayList::new);
        Collections.addAll(collection, withItemList);
        return this.withWithItemList(collection);
    }

    public WithItem<?> addWithItemList(Collection<? extends SelectItem<?>> withItemList) {
        List collection = Optional.ofNullable(this.getWithItemList()).orElseGet(ArrayList::new);
        collection.addAll(withItemList);
        return this.withWithItemList(collection);
    }

    public ParenthesedSelect getSelect() {
        return (ParenthesedSelect)this.statement;
    }

    public ParenthesedInsert getInsert() {
        return (ParenthesedInsert)this.statement;
    }

    public ParenthesedUpdate getUpdate() {
        return (ParenthesedUpdate)this.statement;
    }

    public ParenthesedDelete getDelete() {
        return (ParenthesedDelete)this.statement;
    }

    public void setSelect(ParenthesedSelect select) {
        this.statement = select;
    }
}

