/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.dns;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.DnsProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Opcode;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.Type;

public class DnsCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(DnsCollectImpl.class);
    private static final String HEADER = "header";
    private static final String QUESTION = "question";
    private static final String ANSWER = "answer";
    private static final String AUTHORITY = "authority";
    private static final String ADDITIONAL = "additional";
    private static final String RESPONSE_TIME = "responseTime";
    private static final String OP_CODE = "opcode";
    private static final String STATUS = "status";
    private static final String FLAGS = "flags";
    private static final String QUESTION_ROW_COUNT = "questionRowCount";
    private static final String ANSWER_ROW_COUNT = "answerRowCount";
    private static final String AUTHORITY_ROW_COUNT = "authorityRowCount";
    private static final String ADDITIONAL_ROW_COUNT = "additionalRowCount";

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)metrics.getDns().getQueryClass())) {
            metrics.getDns().setQueryClass(DClass.string((int)1));
        }
        if (this.checkDnsProtocolFailed(metrics.getDns())) {
            throw new IllegalArgumentException("DNS collect must have a valid DNS protocol param! ");
        }
    }

    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        DnsResolveResult dnsResolveResult;
        try {
            dnsResolveResult = this.dig(metrics.getDns());
        }
        catch (IOException e) {
            log.info(CommonUtil.getMessageFromThrowable((Throwable)e));
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg(e.getMessage());
            return;
        }
        catch (Exception e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.warn("[dns collect] error: {}", (Object)e.getMessage(), (Object)e);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
            return;
        }
        CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
        if (StringUtils.equals((CharSequence)HEADER, (CharSequence)metrics.getName())) {
            Map<String, String> headerInfo = dnsResolveResult.getHeaderInfo();
            metrics.getAliasFields().forEach(field -> valueRowBuilder.addColumn(headerInfo.getOrDefault(field, "&nbsp;")));
        } else {
            List<String> currentMetricsResolveResultList = dnsResolveResult.getList(metrics.getName());
            for (int index = 0; index < metrics.getAliasFields().size(); ++index) {
                valueRowBuilder.addColumn(index >= currentMetricsResolveResultList.size() ? "&nbsp;" : currentMetricsResolveResultList.get(index));
            }
        }
        builder.addValueRow(valueRowBuilder.build());
    }

    public String supportProtocol() {
        return "dns";
    }

    private boolean checkDnsProtocolFailed(DnsProtocol dnsProtocol) {
        return Objects.isNull(dnsProtocol) || dnsProtocol.isInvalid();
    }

    private DnsResolveResult dig(DnsProtocol dns) throws IOException {
        StopWatch responseTimeStopWatch = new StopWatch(RESPONSE_TIME);
        responseTimeStopWatch.start();
        Name name = Name.fromString((String)dns.getAddress(), (Name)Name.root);
        Message query = Message.newQuery((Record)Record.newRecord((Name)name, (int)Type.value((String)dns.getRecordType()), (int)DClass.value((String)dns.getQueryClass())));
        SimpleResolver res = new SimpleResolver(dns.getDnsServerIP());
        res.setTimeout(Duration.of(Long.parseLong(dns.getTimeout()), ChronoUnit.MILLIS));
        res.setTCP(Boolean.parseBoolean(dns.getTcp()));
        res.setPort(Integer.parseInt(dns.getPort()));
        Message response = res.send(query);
        responseTimeStopWatch.stop();
        return this.resolve(response, responseTimeStopWatch.lastTaskInfo().getTimeMillis());
    }

    private DnsResolveResult resolve(Message message, Long responseTime) {
        return DnsResolveResult.builder().headerInfo(this.getHeaderInfo(message, responseTime)).questionList(this.getSectionInfo(message, 0)).answerList(this.getSectionInfo(message, 1)).authorityList(this.getSectionInfo(message, 2)).additionalList(this.getSectionInfo(message, 3)).build();
    }

    private Map<String, String> getHeaderInfo(Message message, Long responseTime) {
        HashMap resultMap = Maps.newHashMap();
        resultMap.put(RESPONSE_TIME, String.valueOf(responseTime));
        resultMap.put(OP_CODE, Opcode.string((int)message.getHeader().getOpcode()));
        resultMap.put(STATUS, Rcode.string((int)message.getHeader().getRcode()));
        resultMap.put(FLAGS, message.getHeader().printFlags());
        resultMap.put(QUESTION_ROW_COUNT, String.valueOf(message.getHeader().getCount(0)));
        resultMap.put(ANSWER_ROW_COUNT, String.valueOf(message.getHeader().getCount(1)));
        resultMap.put(AUTHORITY_ROW_COUNT, String.valueOf(message.getHeader().getCount(2)));
        resultMap.put(ADDITIONAL_ROW_COUNT, String.valueOf(message.getHeader().getCount(3)));
        return resultMap;
    }

    private List<String> getSectionInfo(Message message, int section) {
        List currentSetList = message.getSectionRRsets(section);
        if (CollectionUtils.isEmpty((Collection)currentSetList)) {
            return Lists.newArrayList();
        }
        ArrayList infoList = Lists.newArrayListWithCapacity((int)currentSetList.size());
        currentSetList.forEach(res -> infoList.add(res.toString()));
        return infoList;
    }

    private static class DnsResolveResult {
        private Map<String, String> headerInfo;
        private List<String> questionList;
        private List<String> answerList;
        private List<String> authorityList;
        private List<String> additionalList;

        public List<String> getList(String metricsName) {
            return switch (metricsName) {
                case DnsCollectImpl.QUESTION -> this.questionList;
                case DnsCollectImpl.ANSWER -> this.answerList;
                case DnsCollectImpl.AUTHORITY -> this.authorityList;
                case DnsCollectImpl.ADDITIONAL -> this.additionalList;
                default -> Collections.emptyList();
            };
        }

        public static DnsResolveResultBuilder builder() {
            return new DnsResolveResultBuilder();
        }

        public Map<String, String> getHeaderInfo() {
            return this.headerInfo;
        }

        public List<String> getQuestionList() {
            return this.questionList;
        }

        public List<String> getAnswerList() {
            return this.answerList;
        }

        public List<String> getAuthorityList() {
            return this.authorityList;
        }

        public List<String> getAdditionalList() {
            return this.additionalList;
        }

        public void setHeaderInfo(Map<String, String> headerInfo) {
            this.headerInfo = headerInfo;
        }

        public void setQuestionList(List<String> questionList) {
            this.questionList = questionList;
        }

        public void setAnswerList(List<String> answerList) {
            this.answerList = answerList;
        }

        public void setAuthorityList(List<String> authorityList) {
            this.authorityList = authorityList;
        }

        public void setAdditionalList(List<String> additionalList) {
            this.additionalList = additionalList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DnsResolveResult)) {
                return false;
            }
            DnsResolveResult other = (DnsResolveResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, String> this$headerInfo = this.getHeaderInfo();
            Map<String, String> other$headerInfo = other.getHeaderInfo();
            if (this$headerInfo == null ? other$headerInfo != null : !((Object)this$headerInfo).equals(other$headerInfo)) {
                return false;
            }
            List<String> this$questionList = this.getQuestionList();
            List<String> other$questionList = other.getQuestionList();
            if (this$questionList == null ? other$questionList != null : !((Object)this$questionList).equals(other$questionList)) {
                return false;
            }
            List<String> this$answerList = this.getAnswerList();
            List<String> other$answerList = other.getAnswerList();
            if (this$answerList == null ? other$answerList != null : !((Object)this$answerList).equals(other$answerList)) {
                return false;
            }
            List<String> this$authorityList = this.getAuthorityList();
            List<String> other$authorityList = other.getAuthorityList();
            if (this$authorityList == null ? other$authorityList != null : !((Object)this$authorityList).equals(other$authorityList)) {
                return false;
            }
            List<String> this$additionalList = this.getAdditionalList();
            List<String> other$additionalList = other.getAdditionalList();
            return !(this$additionalList == null ? other$additionalList != null : !((Object)this$additionalList).equals(other$additionalList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DnsResolveResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $headerInfo = this.getHeaderInfo();
            result = result * 59 + ($headerInfo == null ? 43 : ((Object)$headerInfo).hashCode());
            List<String> $questionList = this.getQuestionList();
            result = result * 59 + ($questionList == null ? 43 : ((Object)$questionList).hashCode());
            List<String> $answerList = this.getAnswerList();
            result = result * 59 + ($answerList == null ? 43 : ((Object)$answerList).hashCode());
            List<String> $authorityList = this.getAuthorityList();
            result = result * 59 + ($authorityList == null ? 43 : ((Object)$authorityList).hashCode());
            List<String> $additionalList = this.getAdditionalList();
            result = result * 59 + ($additionalList == null ? 43 : ((Object)$additionalList).hashCode());
            return result;
        }

        public String toString() {
            return "DnsCollectImpl.DnsResolveResult(headerInfo=" + this.getHeaderInfo() + ", questionList=" + this.getQuestionList() + ", answerList=" + this.getAnswerList() + ", authorityList=" + this.getAuthorityList() + ", additionalList=" + this.getAdditionalList() + ")";
        }

        public DnsResolveResult() {
        }

        public DnsResolveResult(Map<String, String> headerInfo, List<String> questionList, List<String> answerList, List<String> authorityList, List<String> additionalList) {
            this.headerInfo = headerInfo;
            this.questionList = questionList;
            this.answerList = answerList;
            this.authorityList = authorityList;
            this.additionalList = additionalList;
        }

        public static class DnsResolveResultBuilder {
            private Map<String, String> headerInfo;
            private List<String> questionList;
            private List<String> answerList;
            private List<String> authorityList;
            private List<String> additionalList;

            DnsResolveResultBuilder() {
            }

            public DnsResolveResultBuilder headerInfo(Map<String, String> headerInfo) {
                this.headerInfo = headerInfo;
                return this;
            }

            public DnsResolveResultBuilder questionList(List<String> questionList) {
                this.questionList = questionList;
                return this;
            }

            public DnsResolveResultBuilder answerList(List<String> answerList) {
                this.answerList = answerList;
                return this;
            }

            public DnsResolveResultBuilder authorityList(List<String> authorityList) {
                this.authorityList = authorityList;
                return this;
            }

            public DnsResolveResultBuilder additionalList(List<String> additionalList) {
                this.additionalList = additionalList;
                return this;
            }

            public DnsResolveResult build() {
                return new DnsResolveResult(this.headerInfo, this.questionList, this.answerList, this.authorityList, this.additionalList);
            }

            public String toString() {
                return "DnsCollectImpl.DnsResolveResult.DnsResolveResultBuilder(headerInfo=" + this.headerInfo + ", questionList=" + this.questionList + ", answerList=" + this.answerList + ", authorityList=" + this.authorityList + ", additionalList=" + this.additionalList + ")";
            }
        }
    }
}

