/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.Blob;
import com.xugu.cloudjdbc.Clob;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

class WatchableOutputStream
extends ByteArrayOutputStream {
    private byte[] watcher_byte;
    private ArrayList<byte[]> writeArray = new ArrayList();
    private Blob watcher_blob;
    private Clob watcher_clob;
    int totalLength;
    int beginIndex;

    WatchableOutputStream() {
    }

    @Override
    public void close() throws IOException {
        this.totalLength += this.beginIndex;
        this.watcher_byte = new byte[this.totalLength];
        int watcher_byte_index = 0;
        for (int i = 0; i < this.writeArray.size(); ++i) {
            System.arraycopy(this.writeArray.get(i), 0, this.watcher_byte, watcher_byte_index, this.writeArray.get(i).length);
            watcher_byte_index += this.writeArray.get(i).length;
        }
        try {
            if (this.watcher_blob != null) {
                this.watcher_blob.setBinaryData(this.watcher_byte);
                this.watcher_blob.getBlobRS().updateBlob(this.watcher_blob.getColNum(), (java.sql.Blob)this.watcher_blob);
                this.watcher_blob.getBlobRS().updateRow();
            } else {
                this.watcher_clob.setCharData(this.watcher_byte);
                this.watcher_clob.getClobRS().updateClob(this.watcher_clob.getColNum(), (java.sql.Clob)this.watcher_clob);
                this.watcher_clob.getClobRS().updateRow();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        super.close();
    }

    void setWatcher(Blob bb, int index) {
        this.watcher_blob = bb;
        this.watcher_byte = this.watcher_blob.binaryData;
        if (index > 1) {
            this.beginIndex = index;
        }
    }

    void setWatcher(Clob cc, int index) {
        this.watcher_clob = cc;
        if (index > 1) {
            this.beginIndex = index;
        }
        this.watcher_byte = this.watcher_clob.binaryData;
    }

    @Override
    public void write(byte[] writebytes, int pos, int len) {
        try {
            if (pos == 0 && len == writebytes.length) {
                this.write(writebytes);
            } else {
                byte[] newbyte = null;
                if (len > this.watcher_byte.length - this.beginIndex) {
                    newbyte = new byte[len + this.beginIndex];
                    if (this.beginIndex > 0) {
                        System.arraycopy(this.watcher_byte, 0, newbyte, 0, this.beginIndex);
                    }
                    System.arraycopy(writebytes, pos, newbyte, this.beginIndex, len);
                } else {
                    newbyte = this.watcher_byte;
                    System.arraycopy(writebytes, pos, newbyte, this.beginIndex, len);
                }
                this.watcher_blob.updateBlob(newbyte);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void write(byte[] writeBytes) throws IOException {
        int tempLen = writeBytes.length;
        byte[] temp = new byte[tempLen];
        System.arraycopy(writeBytes, 0, temp, 0, tempLen);
        this.totalLength += tempLen;
        this.writeArray.add(temp);
    }

    @Override
    public void write(int c) {
    }
}

