/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store;

import com.google.protobuf.Struct;
import java.io.File;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.bifromq.basekv.localengine.StructUtil;
import org.apache.bifromq.basekv.store.option.KVRangeStoreOptions;
import org.apache.bifromq.basekv.store.stats.StatsCollector;
import org.apache.bifromq.basekv.store.util.ProcessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KVRangeStoreStatsCollector
extends StatsCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KVRangeStoreStatsCollector.class);
    private final KVRangeStoreOptions opt;

    KVRangeStoreStatsCollector(KVRangeStoreOptions opt, Duration interval, Executor executor) {
        super(interval, executor);
        this.opt = opt;
        this.tick();
    }

    @Override
    protected void scrap(Map<String, Double> stats) {
        long total;
        if ("rocksdb".equalsIgnoreCase(this.opt.getDataEngineType())) {
            try {
                File dbRootDir = new File(StructUtil.strVal((Struct)this.opt.getDataEngineConf(), (String)"dbRootDir"));
                total = dbRootDir.getTotalSpace();
                if (total > 0L) {
                    stats.put("db.usage", this.roundUsage((double)dbRootDir.getUsableSpace() / (double)total));
                }
            }
            catch (Throwable e) {
                log.error("Failed to calculate db usage", e);
            }
        }
        if ("rocksdb".equalsIgnoreCase(this.opt.getWalEngineType())) {
            try {
                File walRootDir = new File(StructUtil.strVal((Struct)this.opt.getDataEngineConf(), (String)"dbRootDir"));
                total = walRootDir.getTotalSpace();
                if (total > 0L) {
                    stats.put("wal.usage", this.roundUsage((double)walRootDir.getUsableSpace() / (double)total));
                }
            }
            catch (Throwable e) {
                log.error("Failed to calculate wal usage", e);
            }
        }
        stats.put("cpu.usage", this.roundUsage(ProcessUtil.cpuLoad()));
    }

    private double roundUsage(double usage) {
        return (double)Math.round(usage * 100.0) / 100.0;
    }
}

