/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.balance.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.bifromq.basekv.balance.impl.RuleBasedPlacementBalancer;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeDescriptor;
import org.apache.bifromq.basekv.proto.KVRangeStoreDescriptor;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.utils.EffectiveRoute;
import org.apache.bifromq.basekv.utils.RangeLeader;

public class ReplicaCntBalancer
extends RuleBasedPlacementBalancer {
    public static final String LOAD_RULE_VOTERS = "votersPerRange";
    public static final String LOAD_RULE_LEARNERS = "learnersPerRange";
    private final Struct defaultLoadRules;

    public ReplicaCntBalancer(String clusterId, String localStoreId, int votersPerRange, int learnersPerRange) {
        super(clusterId, localStoreId);
        this.defaultLoadRules = Struct.newBuilder().putFields(LOAD_RULE_VOTERS, Value.newBuilder().setNumberValue((double)votersPerRange).build()).putFields(LOAD_RULE_LEARNERS, Value.newBuilder().setNumberValue((double)learnersPerRange).build()).build();
        Preconditions.checkArgument((boolean)this.validate(this.defaultLoadRules), (Object)"Invalid default load rules");
    }

    private ClusterConfig buildConfig(Set<String> voters, Set<String> learners) {
        return ClusterConfig.newBuilder().addAllVoters(voters).addAllLearners(learners).build();
    }

    private void sanitize(Set<String> s, Set<String> live) {
        s.retainAll(live);
    }

    public Struct initialLoadRules() {
        return this.defaultLoadRules;
    }

    @Override
    public boolean validate(Struct loadRules) {
        Value voters = (Value)loadRules.getFieldsMap().get(LOAD_RULE_VOTERS);
        if (voters == null || !voters.hasNumberValue() || voters.getNumberValue() == 0.0 || voters.getNumberValue() % 2.0 == 0.0) {
            return false;
        }
        Value learners = (Value)loadRules.getFieldsMap().get(LOAD_RULE_LEARNERS);
        return learners != null && learners.hasNumberValue() && !(learners.getNumberValue() < -1.0);
    }

    @Override
    protected Map<Boundary, ClusterConfig> doGenerate(Struct loadRules, Map<String, KVRangeStoreDescriptor> landscape, EffectiveRoute effectiveRoute) {
        HashMap<Boundary, ClusterConfig> expectedRangeLayout = new HashMap<Boundary, ClusterConfig>();
        boolean meetingGoalOne = this.meetExpectedConfig(loadRules, landscape, effectiveRoute, expectedRangeLayout);
        if (meetingGoalOne) {
            return expectedRangeLayout;
        }
        boolean meetingGoalTwo = this.balanceVoterCount(landscape, effectiveRoute, expectedRangeLayout);
        if (meetingGoalTwo) {
            return expectedRangeLayout;
        }
        this.balanceLearnerCount(landscape, effectiveRoute, expectedRangeLayout);
        return expectedRangeLayout;
    }

    private boolean meetExpectedConfig(Struct loadRules, Map<String, KVRangeStoreDescriptor> landscape, EffectiveRoute effectiveRoute, Map<Boundary, ClusterConfig> expectedRangeLayout) {
        HashSet<String> learners;
        HashSet<String> voters;
        ClusterConfig clusterConfig;
        KVRangeDescriptor rangeDescriptor;
        RangeLeader rangeLeader;
        Set<String> liveStores = landscape.keySet();
        int expectedVoters = (int)((Value)loadRules.getFieldsMap().get(LOAD_RULE_VOTERS)).getNumberValue();
        int expectedLearners = (int)((Value)loadRules.getFieldsMap().get(LOAD_RULE_LEARNERS)).getNumberValue();
        if (liveStores.size() < expectedVoters) {
            for (Map.Entry e2 : effectiveRoute.leaderRanges().entrySet()) {
                ClusterConfig cc = ((RangeLeader)e2.getValue()).descriptor().getConfig();
                for (String v : cc.getVotersList()) {
                    if (liveStores.contains(v)) continue;
                    return true;
                }
            }
        }
        boolean meetingGoal = false;
        for (Map.Entry entry : effectiveRoute.leaderRanges().entrySet()) {
            boolean needFix;
            rangeLeader = (RangeLeader)entry.getValue();
            rangeDescriptor = rangeLeader.descriptor();
            clusterConfig = rangeDescriptor.getConfig();
            if (clusterConfig.getNextVotersCount() > 0 || clusterConfig.getNextLearnersCount() > 0) {
                expectedRangeLayout.clear();
                return true;
            }
            voters = new HashSet<String>((Collection<String>)clusterConfig.getVotersList());
            learners = new HashSet<String>((Collection<String>)clusterConfig.getLearnersList());
            this.sanitize(voters, liveStores);
            this.sanitize(learners, liveStores);
            Boundary boundary = (Boundary)entry.getKey();
            int targetVoters = Math.min(expectedVoters, liveStores.size());
            boolean bl = needFix = voters.size() != targetVoters;
            if (!meetingGoal && needFix) {
                String leaderStore = rangeLeader.storeId();
                if (voters.size() < targetVoters) {
                    if (!learners.isEmpty()) {
                        List<String> learnerCandidates = landscape.entrySet().stream().filter(e -> learners.contains(e.getKey())).sorted(Comparator.comparingInt(e -> ((KVRangeStoreDescriptor)e.getValue()).getRangesCount())).map(Map.Entry::getKey).toList();
                        for (String s : learnerCandidates) {
                            learners.remove(s);
                            voters.add(s);
                            if (voters.size() != targetVoters) continue;
                            break;
                        }
                    }
                    if (voters.size() < targetVoters) {
                        List<String> freeCandidates = landscape.entrySet().stream().filter(e -> !learners.contains(e.getKey()) && !voters.contains(e.getKey())).sorted(Comparator.comparingInt(e -> ((KVRangeStoreDescriptor)e.getValue()).getRangesCount())).map(Map.Entry::getKey).toList();
                        for (String s : freeCandidates) {
                            voters.add(s);
                            if (voters.size() != targetVoters) continue;
                            break;
                        }
                    }
                    if (expectedLearners == -1) {
                        HashSet<String> newLearners = new HashSet<String>(liveStores);
                        newLearners.removeAll(voters);
                        learners.clear();
                        learners.addAll(newLearners);
                    }
                    List<String> candidates = landscape.entrySet().stream().filter(e -> !learners.contains(e.getKey()) && !voters.contains(e.getKey())).sorted(Comparator.comparingInt(e -> ((KVRangeStoreDescriptor)e.getValue()).getRangesCount())).map(Map.Entry::getKey).toList();
                    for (String s : candidates) {
                        voters.add(s);
                        if (voters.size() != targetVoters) continue;
                        break;
                    }
                } else {
                    List<String> overloaded = landscape.entrySet().stream().sorted((a, b) -> ((KVRangeStoreDescriptor)b.getValue()).getRangesCount() - ((KVRangeStoreDescriptor)a.getValue()).getRangesCount()).map(Map.Entry::getKey).toList();
                    for (String s : overloaded) {
                        if (s.equals(leaderStore) || !voters.contains(s)) continue;
                        voters.remove(s);
                        if (voters.size() != targetVoters) continue;
                        break;
                    }
                    if (voters.size() > targetVoters) {
                        for (String s : new ArrayList<String>(voters)) {
                            if (s.equals(leaderStore)) continue;
                            voters.remove(s);
                            if (voters.size() != targetVoters) continue;
                            break;
                        }
                    }
                }
                expectedRangeLayout.put(boundary, this.buildConfig(voters, learners));
                meetingGoal = true;
                continue;
            }
            expectedRangeLayout.put(boundary, this.buildConfig(voters, learners));
        }
        if (meetingGoal) {
            return true;
        }
        for (Map.Entry entry : effectiveRoute.leaderRanges().entrySet()) {
            rangeLeader = (RangeLeader)entry.getValue();
            rangeDescriptor = rangeLeader.descriptor();
            clusterConfig = rangeDescriptor.getConfig();
            voters = new HashSet(clusterConfig.getVotersList());
            learners = new HashSet(clusterConfig.getLearnersList());
            this.sanitize(voters, liveStores);
            this.sanitize(learners, liveStores);
            boolean changed = false;
            if (expectedLearners == -1) {
                HashSet<String> newLearners = new HashSet<String>(liveStores);
                newLearners.removeAll(voters);
                if (!newLearners.equals(learners)) {
                    learners = newLearners;
                    changed = true;
                }
            } else {
                int maxPossible = Math.max(0, liveStores.size() - voters.size());
                int targetLearners = Math.min(expectedLearners, maxPossible);
                if (learners.size() < targetLearners) {
                    List<String> candidates = landscape.entrySet().stream().sorted(Comparator.comparingInt(e -> ((KVRangeStoreDescriptor)e.getValue()).getRangesCount())).map(Map.Entry::getKey).toList();
                    for (String s : candidates) {
                        if (voters.contains(s) || learners.contains(s)) continue;
                        learners.add(s);
                        if (learners.size() != targetLearners) continue;
                        break;
                    }
                    changed = true;
                } else if (learners.size() > targetLearners) {
                    List<String> overloaded = landscape.entrySet().stream().sorted((a, b) -> ((KVRangeStoreDescriptor)b.getValue()).getRangesCount() - ((KVRangeStoreDescriptor)a.getValue()).getRangesCount()).map(Map.Entry::getKey).toList();
                    for (String s : overloaded) {
                        if (!learners.contains(s)) continue;
                        learners.remove(s);
                        if (learners.size() != targetLearners) continue;
                        break;
                    }
                    changed = true;
                }
            }
            Boundary boundary = (Boundary)entry.getKey();
            expectedRangeLayout.put(boundary, this.buildConfig(voters, learners));
            if (meetingGoal || !changed) continue;
            meetingGoal = true;
        }
        return meetingGoal;
    }

    private boolean balanceVoterCount(Map<String, KVRangeStoreDescriptor> landscape, EffectiveRoute effectiveRoute, Map<Boundary, ClusterConfig> expectedRangeLayout) {
        Set<String> liveStores = landscape.keySet();
        HashMap<String, Integer> storeVoterCount = new HashMap<String, Integer>();
        for (Map.Entry entry : effectiveRoute.leaderRanges().entrySet()) {
            ClusterConfig config = ((RangeLeader)entry.getValue()).descriptor().getConfig();
            config.getVotersList().stream().filter(liveStores::contains).forEach(storeId -> storeVoterCount.put((String)storeId, storeVoterCount.getOrDefault(storeId, 0) + 1));
        }
        liveStores.forEach(s -> storeVoterCount.putIfAbsent((String)s, 0));
        record StoreVoterCount(String storeId, int voterCount) {
        }
        TreeSet<StoreVoterCount> storeVoterCountSorted = new TreeSet<StoreVoterCount>(Comparator.comparingInt(StoreVoterCount::voterCount).thenComparing(StoreVoterCount::storeId));
        storeVoterCount.forEach((storeId, voterCount) -> storeVoterCountSorted.add(new StoreVoterCount((String)storeId, (int)voterCount)));
        double totalVoters = storeVoterCount.values().stream().mapToInt(Integer::intValue).sum();
        double targetVotersPerStore = liveStores.isEmpty() ? 0.0 : totalVoters / (double)liveStores.size();
        int minVotersPerStore = (int)Math.floor(targetVotersPerStore);
        int globalMax = storeVoterCount.values().stream().mapToInt(Integer::intValue).max().orElse(0);
        int globalMin = storeVoterCount.values().stream().mapToInt(Integer::intValue).min().orElse(0);
        if (globalMax - globalMin <= 1) {
            return false;
        }
        boolean meetingGoal = false;
        for (Map.Entry entry : effectiveRoute.leaderRanges().entrySet()) {
            Boundary boundary = (Boundary)entry.getKey();
            RangeLeader lr = (RangeLeader)entry.getValue();
            ClusterConfig cc = lr.descriptor().getConfig();
            HashSet learners = Sets.newHashSet((Iterable)cc.getLearnersList());
            TreeSet voterSorted = Sets.newTreeSet((Iterable)cc.getVotersList());
            this.sanitize(learners, liveStores);
            voterSorted.retainAll(liveStores);
            if (!meetingGoal) {
                block2: for (String voter : new ArrayList(voterSorted)) {
                    int voters = storeVoterCount.getOrDefault(voter, 0);
                    if (voters != globalMax) continue;
                    for (StoreVoterCount under : storeVoterCountSorted) {
                        if (storeVoterCount.getOrDefault(under.storeId, 0) > minVotersPerStore || voterSorted.contains(under.storeId) || learners.contains(under.storeId)) continue;
                        HashSet<String> newVoters = new HashSet<String>(voterSorted);
                        newVoters.remove(voter);
                        newVoters.add(under.storeId);
                        expectedRangeLayout.put(boundary, this.buildConfig(newVoters, learners));
                        meetingGoal = true;
                        break block2;
                    }
                }
                if (meetingGoal) continue;
                expectedRangeLayout.put(boundary, this.buildConfig(voterSorted, learners));
                continue;
            }
            expectedRangeLayout.put(boundary, this.buildConfig(voterSorted, learners));
        }
        if (!meetingGoal) {
            expectedRangeLayout.clear();
        }
        return meetingGoal;
    }

    private void balanceLearnerCount(Map<String, KVRangeStoreDescriptor> landscape, EffectiveRoute effectiveRoute, Map<Boundary, ClusterConfig> expectedRangeLayout) {
        Set<String> liveStores = landscape.keySet();
        HashMap<String, Integer> storeLearnerCount = new HashMap<String, Integer>();
        for (Map.Entry entry : effectiveRoute.leaderRanges().entrySet()) {
            ClusterConfig config = ((RangeLeader)entry.getValue()).descriptor().getConfig();
            config.getLearnersList().stream().filter(liveStores::contains).forEach(storeId -> storeLearnerCount.put((String)storeId, storeLearnerCount.getOrDefault(storeId, 0) + 1));
        }
        liveStores.forEach(s -> storeLearnerCount.putIfAbsent((String)s, 0));
        record StoreLearnerCount(String storeId, int learnerCount) {
        }
        TreeSet<StoreLearnerCount> storeLearnerCountSorted = new TreeSet<StoreLearnerCount>(Comparator.comparingInt(StoreLearnerCount::learnerCount).thenComparing(StoreLearnerCount::storeId));
        storeLearnerCount.forEach((id, c) -> storeLearnerCountSorted.add(new StoreLearnerCount((String)id, (int)c)));
        double totalLearners = storeLearnerCount.values().stream().mapToInt(Integer::intValue).sum();
        double targetLearnersPerStore = liveStores.isEmpty() ? 0.0 : totalLearners / (double)liveStores.size();
        int minLearnersPerStore = (int)Math.floor(targetLearnersPerStore);
        int globalMax = storeLearnerCount.values().stream().mapToInt(Integer::intValue).max().orElse(0);
        int globalMin = storeLearnerCount.values().stream().mapToInt(Integer::intValue).min().orElse(0);
        if (globalMax - globalMin <= 1) {
            return;
        }
        boolean meetingGoal = false;
        for (Map.Entry entry : effectiveRoute.leaderRanges().entrySet()) {
            Boundary boundary = (Boundary)entry.getKey();
            RangeLeader lr = (RangeLeader)entry.getValue();
            ClusterConfig cc = lr.descriptor().getConfig();
            HashSet voters = Sets.newHashSet((Iterable)cc.getVotersList());
            TreeSet learnerSorted = Sets.newTreeSet((Iterable)cc.getLearnersList());
            this.sanitize(voters, liveStores);
            learnerSorted.retainAll(liveStores);
            if (!meetingGoal) {
                block2: for (String learner : new ArrayList(learnerSorted)) {
                    int learners = storeLearnerCount.getOrDefault(learner, 0);
                    if (learners != globalMax) continue;
                    for (StoreLearnerCount under : storeLearnerCountSorted) {
                        if (storeLearnerCount.getOrDefault(under.storeId, 0) >= minLearnersPerStore || voters.contains(under.storeId) || learnerSorted.contains(under.storeId)) continue;
                        HashSet<String> newLearners = new HashSet<String>(learnerSorted);
                        newLearners.remove(learner);
                        newLearners.add(under.storeId);
                        expectedRangeLayout.put(boundary, this.buildConfig(voters, newLearners));
                        meetingGoal = true;
                        break block2;
                    }
                }
                if (meetingGoal) continue;
                expectedRangeLayout.put(boundary, this.buildConfig(voters, learnerSorted));
                continue;
            }
            expectedRangeLayout.put(boundary, this.buildConfig(voters, learnerSorted));
        }
        if (!meetingGoal) {
            expectedRangeLayout.clear();
        }
    }
}

