/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import com.google.protobuf.Struct;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.bifromq.basekv.localengine.KVEngineException;
import org.apache.bifromq.basekv.localengine.StructUtil;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBCPableKVSpace;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBDefaultConfigs;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVEngine;
import org.slf4j.Logger;

class RocksDBCPableKVEngine
extends RocksDBKVEngine<RocksDBCPableKVSpace> {
    private final File cpRootDir;
    private MetricManager metricManager;

    public RocksDBCPableKVEngine(String overrideIdentity, Struct conf) {
        super(overrideIdentity, conf);
        this.cpRootDir = new File(StructUtil.strVal((Struct)conf, (String)"dbCheckpointRootDir"));
        try {
            Files.createDirectories(this.cpRootDir.getAbsoluteFile().toPath(), new FileAttribute[0]);
        }
        catch (Throwable e) {
            throw new KVEngineException("Failed to create checkpoint root folder", e);
        }
    }

    protected RocksDBCPableKVSpace doBuildKVSpace(String spaceId, Struct conf, Runnable onDestroy, KVSpaceOpMeters opMeters, Logger logger, String ... tags) {
        return new RocksDBCPableKVSpace(spaceId, conf, this, onDestroy, opMeters, logger, tags);
    }

    protected Struct defaultConf() {
        return RocksDBDefaultConfigs.CP;
    }

    protected void validateSemantics(Struct conf) {
        try {
            Paths.get(StructUtil.strVal((Struct)conf, (String)"dbRootDir"), new String[0]);
            Paths.get(StructUtil.strVal((Struct)conf, (String)"dbCheckpointRootDir"), new String[0]);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Invalid RocksDB data/checkpoint path in configuration", t);
        }
    }

    @Override
    protected void doStart(String ... metricTags) {
        super.doStart(metricTags);
        this.metricManager = new MetricManager(metricTags);
    }

    @Override
    protected void doStop() {
        this.metricManager.close();
        super.doStop();
    }

    private class MetricManager {
        private final Gauge checkpointTotalSpaceGauge;
        private final Gauge checkpointsUsableSpaceGauge;

        MetricManager(String ... metricTags) {
            Tags tags = Tags.of((String[])metricTags);
            this.checkpointTotalSpaceGauge = Gauge.builder((String)"basekv.le.rocksdb.total.checkpoints", RocksDBCPableKVEngine.this.cpRootDir::getTotalSpace).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            this.checkpointsUsableSpaceGauge = Gauge.builder((String)"basekv.le.rocksdb.usable.checkpoints", RocksDBCPableKVEngine.this.cpRootDir::getUsableSpace).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        }

        void close() {
            Metrics.globalRegistry.remove((Meter)this.checkpointTotalSpaceGauge);
            Metrics.globalRegistry.remove((Meter)this.checkpointsUsableSpaceGauge);
        }
    }
}

