/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker.cache;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bifromq.dist.worker.cache.IMatchedRoutes;
import org.apache.bifromq.dist.worker.schema.cache.GroupMatching;
import org.apache.bifromq.dist.worker.schema.cache.Matching;
import org.apache.bifromq.dist.worker.schema.cache.NormalMatching;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.distservice.GroupFanoutThrottled;
import org.apache.bifromq.plugin.eventcollector.distservice.PersistentFanoutThrottled;

public class MatchedRoutes
implements IMatchedRoutes {
    private final String tenantId;
    private final String topic;
    private final IEventCollector eventCollector;
    private final Set<Matching> allMatchings = Sets.newConcurrentHashSet();
    private final Map<String, GroupMatching> groupMatchings = Maps.newConcurrentMap();
    private final AtomicInteger persistentFanout = new AtomicInteger();
    private int maxPersistentFanout;
    private int maxGroupFanout;

    public MatchedRoutes(String tenantId, String topic, IEventCollector eventCollector, int maxPersistentFanout, int maxGroupFanout) {
        this.tenantId = tenantId;
        this.topic = topic;
        this.eventCollector = eventCollector;
        this.maxPersistentFanout = maxPersistentFanout;
        this.maxGroupFanout = maxGroupFanout;
    }

    @Override
    public int maxPersistentFanout() {
        return this.maxPersistentFanout;
    }

    @Override
    public int maxGroupFanout() {
        return this.maxGroupFanout;
    }

    @Override
    public int persistentFanout() {
        return this.persistentFanout.get();
    }

    @Override
    public int groupFanout() {
        return this.groupMatchings.size();
    }

    @Override
    public Set<Matching> routes() {
        return this.allMatchings;
    }

    @Override
    public IMatchedRoutes.AddResult addNormalMatching(NormalMatching matching) {
        if (this.allMatchings.add((Matching)matching)) {
            if (matching.subBrokerId() == 1) {
                if (this.persistentFanout.get() < this.maxPersistentFanout) {
                    this.persistentFanout.incrementAndGet();
                    return IMatchedRoutes.AddResult.Added;
                }
                this.allMatchings.remove(matching);
                this.eventCollector.report((Event)((PersistentFanoutThrottled)ThreadLocalEventPool.getLocal(PersistentFanoutThrottled.class)).tenantId(this.tenantId).topic(this.topic).mqttTopicFilter(matching.mqttTopicFilter()).maxCount(this.maxPersistentFanout));
                return IMatchedRoutes.AddResult.ExceedFanoutLimit;
            }
            return IMatchedRoutes.AddResult.Added;
        }
        return IMatchedRoutes.AddResult.Exists;
    }

    @Override
    public void removeNormalMatching(NormalMatching matching) {
        if (this.allMatchings.remove(matching) && matching.subBrokerId() == 1) {
            this.persistentFanout.decrementAndGet();
        }
    }

    @Override
    public IMatchedRoutes.AddResult putGroupMatching(GroupMatching matching) {
        GroupMatching prev = this.groupMatchings.put(matching.mqttTopicFilter(), matching);
        if (prev == null) {
            if (this.groupMatchings.size() <= this.maxGroupFanout) {
                this.allMatchings.add((Matching)matching);
                return IMatchedRoutes.AddResult.Added;
            }
            this.groupMatchings.remove(matching.mqttTopicFilter());
            this.eventCollector.report((Event)((GroupFanoutThrottled)ThreadLocalEventPool.getLocal(GroupFanoutThrottled.class)).tenantId(this.tenantId).topic(this.topic).mqttTopicFilter(matching.mqttTopicFilter()).maxCount(this.maxGroupFanout));
            return IMatchedRoutes.AddResult.ExceedFanoutLimit;
        }
        this.allMatchings.remove(prev);
        this.allMatchings.add((Matching)matching);
        return IMatchedRoutes.AddResult.Exists;
    }

    @Override
    public void removeGroupMatching(GroupMatching matching) {
        assert (matching.receivers().isEmpty());
        this.removeGroupMatching(matching.mqttTopicFilter());
    }

    private void removeGroupMatching(String mqttTopicFilter) {
        GroupMatching existing = this.groupMatchings.remove(mqttTopicFilter);
        if (existing != null) {
            this.allMatchings.remove(existing);
        }
    }

    @Override
    public IMatchedRoutes.AdjustResult adjust(int newMaxPersistentFanout, int newMaxGroupFanout) {
        ArrayList<Object> toRemoved;
        int toRemove;
        if (this.maxPersistentFanout < newMaxPersistentFanout && this.persistentFanout.get() == this.maxPersistentFanout) {
            return IMatchedRoutes.AdjustResult.ReloadNeeded;
        }
        if (this.maxGroupFanout < newMaxGroupFanout && this.groupMatchings.size() == this.maxGroupFanout) {
            return IMatchedRoutes.AdjustResult.ReloadNeeded;
        }
        boolean clamped = false;
        if (this.maxPersistentFanout > newMaxPersistentFanout && this.persistentFanout.get() > newMaxPersistentFanout) {
            toRemove = this.persistentFanout.get() - newMaxPersistentFanout;
            toRemoved = new ArrayList<Object>(toRemove);
            for (Matching matching : this.allMatchings) {
                if (toRemove == 0) break;
                if (matching.type() != Matching.Type.Normal || ((NormalMatching)matching).subBrokerId() != 1) continue;
                toRemoved.add((NormalMatching)matching);
                --toRemove;
            }
            toRemoved.forEach(this::removeNormalMatching);
            clamped = true;
        }
        if (this.maxGroupFanout > newMaxGroupFanout && this.groupMatchings.size() > newMaxGroupFanout) {
            toRemove = this.groupMatchings.size() - newMaxGroupFanout;
            toRemoved = new ArrayList(toRemove);
            for (String mqttTopicFilter : this.groupMatchings.keySet()) {
                if (toRemove == 0) break;
                toRemoved.add(mqttTopicFilter);
                --toRemove;
            }
            toRemoved.forEach(this::removeGroupMatching);
            clamped = true;
        }
        this.maxPersistentFanout = newMaxPersistentFanout;
        this.maxGroupFanout = newMaxGroupFanout;
        if (clamped) {
            return IMatchedRoutes.AdjustResult.Clamped;
        }
        return IMatchedRoutes.AdjustResult.Adjusted;
    }
}

