/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricFilter;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMetricFiltersResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, DescribeMetricFiltersResponse> {
    private static final SdkField<List<MetricFilter>> METRIC_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricFilters").getter(DescribeMetricFiltersResponse.getter(DescribeMetricFiltersResponse::metricFilters)).setter(DescribeMetricFiltersResponse.setter(Builder::metricFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeMetricFiltersResponse.getter(DescribeMetricFiltersResponse::nextToken)).setter(DescribeMetricFiltersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_FILTERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeMetricFiltersResponse.memberNameToFieldInitializer();
    private final List<MetricFilter> metricFilters;
    private final String nextToken;

    private DescribeMetricFiltersResponse(BuilderImpl builder) {
        super(builder);
        this.metricFilters = builder.metricFilters;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMetricFilters() {
        return this.metricFilters != null && !(this.metricFilters instanceof SdkAutoConstructList);
    }

    public final List<MetricFilter> metricFilters() {
        return this.metricFilters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricFilters() ? this.metricFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetricFiltersResponse)) {
            return false;
        }
        DescribeMetricFiltersResponse other = (DescribeMetricFiltersResponse)((Object)obj);
        return this.hasMetricFilters() == other.hasMetricFilters() && Objects.equals(this.metricFilters(), other.metricFilters()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMetricFiltersResponse").add("MetricFilters", this.hasMetricFilters() ? this.metricFilters() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricFilters": {
                return Optional.ofNullable(clazz.cast(this.metricFilters()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("metricFilters", METRIC_FILTERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMetricFiltersResponse, T> g) {
        return obj -> g.apply((DescribeMetricFiltersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<MetricFilter> metricFilters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetricFiltersResponse model) {
            super(model);
            this.metricFilters(model.metricFilters);
            this.nextToken(model.nextToken);
        }

        public final List<MetricFilter.Builder> getMetricFilters() {
            List<MetricFilter.Builder> result = MetricFiltersCopier.copyToBuilder(this.metricFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricFilters(Collection<MetricFilter.BuilderImpl> metricFilters) {
            this.metricFilters = MetricFiltersCopier.copyFromBuilder(metricFilters);
        }

        @Override
        public final Builder metricFilters(Collection<MetricFilter> metricFilters) {
            this.metricFilters = MetricFiltersCopier.copy(metricFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricFilters(MetricFilter ... metricFilters) {
            this.metricFilters(Arrays.asList(metricFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricFilters(Consumer<MetricFilter.Builder> ... metricFilters) {
            this.metricFilters(Stream.of(metricFilters).map(c -> (MetricFilter)((MetricFilter.Builder)MetricFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeMetricFiltersResponse build() {
            return new DescribeMetricFiltersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMetricFiltersResponse> {
        public Builder metricFilters(Collection<MetricFilter> var1);

        public Builder metricFilters(MetricFilter ... var1);

        public Builder metricFilters(Consumer<MetricFilter.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

