/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.function.Consumer;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class StandardSessionAccessor
implements HttpSession.Accessor {
    private static final Log log = LogFactory.getLog(StandardSessionAccessor.class);
    private static final StringManager sm = StringManager.getManager(StandardSessionAccessor.class);
    private final Manager manager;
    private final String id;

    public StandardSessionAccessor(Manager manager, String id) {
        if (manager == null) {
            throw new IllegalStateException(sm.getString("standardSessionAccessor.nullManager"));
        }
        if (id == null) {
            throw new IllegalStateException(sm.getString("standardSessionAccessor.nullId"));
        }
        this.manager = manager;
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void access(Consumer<HttpSession> sessionConsumer) {
        Session session;
        try {
            session = this.manager.findSession(this.id);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(sm.getString("standardSessionAccessor.access.ioe", this.id));
        }
        if (session == null || !session.isValid()) {
            throw new IllegalStateException(sm.getString("standardSessionAccessor.access.invalid", this.id));
        }
        session.access();
        try {
            sessionConsumer.accept(session.getSession());
        }
        finally {
            try {
                session.endAccess();
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                log.warn(sm.getString("standardSessionAccessor.access.end"), t);
            }
        }
    }
}

