/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.expression.util;

import java.util.List;
import org.apache.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.read.expression.ExpressionType;
import org.apache.tsfile.read.expression.IBinaryExpression;
import org.apache.tsfile.read.expression.IExpression;
import org.apache.tsfile.read.expression.IUnaryExpression;
import org.apache.tsfile.read.expression.impl.BinaryExpression;
import org.apache.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.factory.FilterFactory;

public class ExpressionOptimizer {
    private ExpressionOptimizer() {
    }

    public static ExpressionOptimizer getInstance() {
        return QueryFilterOptimizerHelper.INSTANCE;
    }

    public IExpression optimize(IExpression expression, List<Path> selectedSeries) throws QueryFilterOptimizationException {
        if (expression instanceof IUnaryExpression) {
            return expression;
        }
        if (expression instanceof IBinaryExpression) {
            ExpressionType relation = expression.getType();
            IExpression left = ((IBinaryExpression)expression).getLeft();
            IExpression right = ((IBinaryExpression)expression).getRight();
            if (left.getType() == ExpressionType.GLOBAL_TIME && right.getType() == ExpressionType.GLOBAL_TIME) {
                return this.combineTwoGlobalTimeFilter((GlobalTimeExpression)left, (GlobalTimeExpression)right, expression.getType());
            }
            if (left.getType() == ExpressionType.GLOBAL_TIME && right.getType() != ExpressionType.GLOBAL_TIME) {
                return this.handleOneGlobalTimeFilter((GlobalTimeExpression)left, right, selectedSeries, relation);
            }
            if (left.getType() != ExpressionType.GLOBAL_TIME && right.getType() == ExpressionType.GLOBAL_TIME) {
                return this.handleOneGlobalTimeFilter((GlobalTimeExpression)right, left, selectedSeries, relation);
            }
            if (left.getType() != ExpressionType.GLOBAL_TIME && right.getType() != ExpressionType.GLOBAL_TIME) {
                try {
                    IExpression regularLeft = this.optimize(left, selectedSeries);
                    IExpression regularRight = this.optimize(right, selectedSeries);
                    BinaryExpression midRet = null;
                    if (relation == ExpressionType.AND) {
                        midRet = BinaryExpression.and(regularLeft, regularRight);
                    } else if (relation == ExpressionType.OR) {
                        midRet = BinaryExpression.or(regularLeft, regularRight);
                    } else {
                        throw new UnsupportedOperationException("unsupported IExpression type: " + (Object)((Object)relation));
                    }
                    if (midRet.getLeft().getType() == ExpressionType.GLOBAL_TIME || midRet.getRight().getType() == ExpressionType.GLOBAL_TIME) {
                        return this.optimize(midRet, selectedSeries);
                    }
                    return midRet;
                }
                catch (StackOverflowError stackOverflowError) {
                    throw new QueryFilterOptimizationException("StackOverflowError is encountered.");
                }
            }
        }
        throw new UnsupportedOperationException("unknown IExpression type: " + expression.getClass().getName());
    }

    private IExpression handleOneGlobalTimeFilter(GlobalTimeExpression globalTimeExpression, IExpression expression, List<Path> selectedSeries, ExpressionType relation) throws QueryFilterOptimizationException {
        IExpression regularRightIExpression = this.optimize(expression, selectedSeries);
        if (regularRightIExpression instanceof GlobalTimeExpression) {
            return this.combineTwoGlobalTimeFilter(globalTimeExpression, (GlobalTimeExpression)regularRightIExpression, relation);
        }
        if (relation == ExpressionType.AND) {
            this.addTimeFilterToQueryFilter(globalTimeExpression.getFilter(), regularRightIExpression);
            return regularRightIExpression;
        }
        if (relation == ExpressionType.OR) {
            IExpression afterTransform = this.pushGlobalTimeFilterToAllSeries(globalTimeExpression, selectedSeries);
            return this.mergeSecondTreeToFirstTree(afterTransform, regularRightIExpression);
        }
        throw new QueryFilterOptimizationException("unknown relation in IExpression:" + (Object)((Object)relation));
    }

    private IExpression mergeSecondTreeToFirstTree(IExpression leftExpression, IExpression rightExpression) {
        if (rightExpression.getType() == ExpressionType.SERIES) {
            SingleSeriesExpression leaf = (SingleSeriesExpression)rightExpression;
            this.updateFilterWithOr(leftExpression, leaf.getFilter(), leaf.getSeriesPath());
            return leftExpression;
        }
        if (rightExpression.getType() == ExpressionType.OR) {
            IExpression leftChild = ((BinaryExpression)rightExpression).getLeft();
            IExpression rightChild = ((BinaryExpression)rightExpression).getRight();
            leftExpression = this.mergeSecondTreeToFirstTree(leftExpression, leftChild);
            leftExpression = this.mergeSecondTreeToFirstTree(leftExpression, rightChild);
            return leftExpression;
        }
        return BinaryExpression.or(leftExpression, rightExpression);
    }

    private boolean updateFilterWithOr(IExpression expression, Filter filter, Path path) {
        if (expression.getType() == ExpressionType.SERIES && ((SingleSeriesExpression)expression).getSeriesPath().equals(path)) {
            Filter nodeFilter = ((SingleSeriesExpression)expression).getFilter();
            nodeFilter = FilterFactory.or(nodeFilter, filter);
            ((SingleSeriesExpression)expression).setFilter(nodeFilter);
            return true;
        }
        if (expression.getType() == ExpressionType.OR) {
            assert (expression instanceof BinaryExpression);
            IExpression left = ((BinaryExpression)expression).getLeft();
            IExpression right = ((BinaryExpression)expression).getRight();
            return this.updateFilterWithOr(left, filter, path) || this.updateFilterWithOr(right, filter, path);
        }
        return false;
    }

    private IExpression pushGlobalTimeFilterToAllSeries(GlobalTimeExpression timeFilter, List<Path> selectedSeries) throws QueryFilterOptimizationException {
        if (selectedSeries.isEmpty()) {
            throw new QueryFilterOptimizationException("size of selectSeries could not be 0");
        }
        IExpression expression = new SingleSeriesExpression(selectedSeries.get(0), timeFilter.getFilter());
        for (int i = 1; i < selectedSeries.size(); ++i) {
            expression = BinaryExpression.or(expression, new SingleSeriesExpression(selectedSeries.get(i), timeFilter.getFilter()));
        }
        return expression;
    }

    private void addTimeFilterToQueryFilter(Filter timeFilter, IExpression expression) {
        if (expression instanceof SingleSeriesExpression) {
            this.addTimeFilterToSeriesFilter(timeFilter, (SingleSeriesExpression)expression);
        } else if (expression instanceof BinaryExpression) {
            this.addTimeFilterToQueryFilter(timeFilter, ((BinaryExpression)expression).getLeft());
            this.addTimeFilterToQueryFilter(timeFilter, ((BinaryExpression)expression).getRight());
        } else {
            throw new UnsupportedOperationException("IExpression should contains only SingleSeriesExpression but other type is found:" + expression.getClass().getName());
        }
    }

    private void addTimeFilterToSeriesFilter(Filter timeFilter, SingleSeriesExpression singleSeriesExp) {
        singleSeriesExp.setFilter(FilterFactory.and(singleSeriesExp.getFilter(), timeFilter));
    }

    private GlobalTimeExpression combineTwoGlobalTimeFilter(GlobalTimeExpression left, GlobalTimeExpression right, ExpressionType type) {
        if (type == ExpressionType.AND) {
            return new GlobalTimeExpression(FilterFactory.and(left.getFilter(), right.getFilter()));
        }
        if (type == ExpressionType.OR) {
            return new GlobalTimeExpression(FilterFactory.or(left.getFilter(), right.getFilter()));
        }
        throw new UnsupportedOperationException("unrecognized QueryFilterOperatorType :" + (Object)((Object)type));
    }

    private static class QueryFilterOptimizerHelper {
        private static final ExpressionOptimizer INSTANCE = new ExpressionOptimizer();

        private QueryFilterOptimizerHelper() {
        }
    }
}

