/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.tag;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.impl.TagFilter;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.tree.SchemaIterator;
import org.apache.iotdb.db.schemaengine.rescon.MemSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.IShowTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.impl.ShowTimeSeriesResult;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.ISchemaReader;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.impl.SchemaReaderLimitOffsetWrapper;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.impl.TimeseriesReaderWithViewFetch;
import org.apache.iotdb.db.schemaengine.schemaregion.tag.TagLogFile;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagManager {
    private static final String TAG_FORMAT = "tag key is %s, tag value is %s, tlog offset is %d";
    private static final String DEBUG_MSG = "%s : TimeSeries %s is removed from tag inverted index, ";
    private static final String DEBUG_MSG_1 = "%s: TimeSeries %s's tag info has been removed from tag inverted index ";
    private static final String PREVIOUS_CONDITION = "before deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b";
    private static final Logger logger = LoggerFactory.getLogger(TagManager.class);
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private TagLogFile tagLogFile;
    private final Map<String, Map<String, Set<IMeasurementMNode<?>>>> tagIndex = new ConcurrentHashMap();
    private final MemSchemaRegionStatistics regionStatistics;

    public TagManager(String sgSchemaDirPath, MemSchemaRegionStatistics regionStatistics) throws IOException {
        this.tagLogFile = new TagLogFile(sgSchemaDirPath, "tlog.txt");
        this.regionStatistics = regionStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean createSnapshot(File targetDir) {
        File tagLogSnapshot = SystemFileFactory.INSTANCE.getFile(targetDir, "tlog.txt.snapshot");
        File tagLogSnapshotTmp = SystemFileFactory.INSTANCE.getFile(targetDir, "tlog.txt.snapshot.tmp");
        try {
            this.tagLogFile.copyTo(tagLogSnapshotTmp);
            if (tagLogSnapshot.exists() && !org.apache.iotdb.commons.utils.FileUtils.deleteFileIfExist((File)tagLogSnapshot)) {
                logger.warn("Failed to delete old snapshot {} while creating tagManager snapshot.", (Object)tagLogSnapshot.getName());
                boolean bl = false;
                return bl;
            }
            if (!tagLogSnapshotTmp.renameTo(tagLogSnapshot)) {
                logger.warn("Failed to rename {} to {} while creating tagManager snapshot.", (Object)tagLogSnapshotTmp.getName(), (Object)tagLogSnapshot.getName());
                if (!org.apache.iotdb.commons.utils.FileUtils.deleteFileIfExist((File)tagLogSnapshot)) {
                    logger.warn("Failed to delete {} after renaming failure.", (Object)tagLogSnapshot.getName());
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.error("Failed to create tagManager snapshot due to {}", (Object)e.getMessage(), (Object)e);
            if (!org.apache.iotdb.commons.utils.FileUtils.deleteFileIfExist((File)tagLogSnapshot)) {
                logger.warn("Failed to delete {} after creating tagManager snapshot failure.", (Object)tagLogSnapshot.getName());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (!org.apache.iotdb.commons.utils.FileUtils.deleteFileIfExist((File)tagLogSnapshotTmp)) {
                logger.warn("Failed to delete {}.", (Object)tagLogSnapshotTmp.getName());
            }
        }
    }

    public static TagManager loadFromSnapshot(File snapshotDir, String sgSchemaDirPath, MemSchemaRegionStatistics regionStatistics) throws IOException {
        File tagSnapshot = SystemFileFactory.INSTANCE.getFile(snapshotDir, "tlog.txt.snapshot");
        File tagFile = SystemFileFactory.INSTANCE.getFile(sgSchemaDirPath, "tlog.txt");
        if (tagFile.exists() && !tagFile.delete()) {
            logger.warn("Failed to delete existing {} when loading snapshot.", (Object)tagFile.getName());
        }
        try {
            FileUtils.copyFile((File)tagSnapshot, (File)tagFile);
            return new TagManager(sgSchemaDirPath, regionStatistics);
        }
        catch (IOException e) {
            if (!tagFile.delete()) {
                logger.warn("Failed to delete existing {} when copying snapshot failure.", (Object)tagFile.getName());
            }
            throw e;
        }
    }

    public boolean recoverIndex(long offset, IMeasurementMNode<?> measurementMNode) throws IOException {
        Map<String, String> tags = this.tagLogFile.readTag(offset);
        if (tags == null || tags.isEmpty()) {
            return false;
        }
        this.addIndex(tags, measurementMNode);
        return true;
    }

    public void addIndex(String tagKey, String tagValue, IMeasurementMNode<?> measurementMNode) {
        if (tagKey == null || tagValue == null || measurementMNode == null) {
            return;
        }
        int tagIndexOldSize = this.tagIndex.size();
        Map tagValueMap = this.tagIndex.computeIfAbsent(tagKey, k -> new ConcurrentHashMap());
        int tagIndexNewSize = this.tagIndex.size();
        int tagValueMapOldSize = tagValueMap.size();
        Set measurementsSet = tagValueMap.computeIfAbsent(tagValue, v -> Collections.synchronizedSet(new HashSet()));
        int tagValueMapNewSize = tagValueMap.size();
        int measurementsSetOldSize = measurementsSet.size();
        measurementsSet.add(measurementMNode);
        int measurementsSetNewSize = measurementsSet.size();
        long memorySize = 0L;
        if (tagIndexNewSize - tagIndexOldSize == 1) {
            memorySize += RamUsageEstimator.sizeOf((String)tagKey) + 4L;
        }
        if (tagValueMapNewSize - tagValueMapOldSize == 1) {
            memorySize += RamUsageEstimator.sizeOf((String)tagValue) + 4L;
        }
        if (measurementsSetNewSize - measurementsSetOldSize == 1) {
            memorySize += (long)(RamUsageEstimator.NUM_BYTES_OBJECT_REF + 4);
        }
        this.requestMemory(memorySize);
    }

    public void addIndex(Map<String, String> tagsMap, IMeasurementMNode<?> measurementMNode) {
        if (tagsMap != null && measurementMNode != null) {
            for (Map.Entry<String, String> entry : tagsMap.entrySet()) {
                this.addIndex(entry.getKey(), entry.getValue(), measurementMNode);
            }
        }
    }

    public void removeIndex(String tagKey, String tagValue, IMeasurementMNode<?> measurementMNode) {
        if (tagKey == null || tagValue == null || measurementMNode == null) {
            return;
        }
        long memorySize = 0L;
        if (this.tagIndex.get(tagKey).get(tagValue).remove(measurementMNode)) {
            memorySize += (long)(RamUsageEstimator.NUM_BYTES_OBJECT_REF + 4);
        }
        if (this.tagIndex.get(tagKey).get(tagValue).isEmpty() && this.tagIndex.get(tagKey).remove(tagValue) != null) {
            memorySize += RamUsageEstimator.sizeOf((String)tagValue) + 4L;
        }
        if (this.tagIndex.get(tagKey).isEmpty() && this.tagIndex.remove(tagKey) != null) {
            memorySize += RamUsageEstimator.sizeOf((String)tagKey) + 4L;
        }
        this.releaseMemory(memorySize);
    }

    private List<IMeasurementMNode<?>> getMatchedTimeseriesInIndex(TagFilter tagFilter) {
        if (!this.tagIndex.containsKey(tagFilter.getKey())) {
            return Collections.emptyList();
        }
        Map<String, Set<IMeasurementMNode<?>>> value2Node = this.tagIndex.get(tagFilter.getKey());
        if (value2Node.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IMeasurementMNode<?>> allMatchedNodes = new ArrayList();
        if (tagFilter.isContains()) {
            for (Map.Entry<String, Set<IMeasurementMNode<?>>> entry : value2Node.entrySet()) {
                String tagValue;
                if (entry.getKey() == null || entry.getValue() == null || !(tagValue = entry.getKey()).contains(tagFilter.getValue())) continue;
                allMatchedNodes.addAll((Collection)entry.getValue());
            }
        } else {
            for (Map.Entry<String, Set<IMeasurementMNode<?>>> entry : value2Node.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                String tagValue = entry.getKey();
                if (!tagFilter.getValue().equals(tagValue)) continue;
                allMatchedNodes.addAll((Collection)entry.getValue());
            }
        }
        allMatchedNodes = allMatchedNodes.stream().sorted(Comparator.comparing(IMNode::getFullPath)).collect(Collectors.toList());
        return allMatchedNodes;
    }

    public ISchemaReader<ITimeSeriesSchemaInfo> getTimeSeriesReaderWithIndex(final IShowTimeSeriesPlan plan) {
        SchemaFilter schemaFilter = plan.getSchemaFilter();
        final Iterator<IMeasurementMNode<?>> allMatchedNodes = this.getMatchedTimeseriesInIndex((TagFilter)SchemaFilter.extract((SchemaFilter)schemaFilter, (SchemaFilterType)SchemaFilterType.TAGS_FILTER).get(0)).iterator();
        final PartialPath pathPattern = plan.getPath();
        SchemaIterator<ITimeSeriesSchemaInfo> schemaIterator = new SchemaIterator<ITimeSeriesSchemaInfo>(){
            private ITimeSeriesSchemaInfo nextMatched;
            private Throwable throwable;

            public boolean hasNext() {
                if (this.throwable == null && this.nextMatched == null) {
                    try {
                        this.getNext();
                    }
                    catch (Throwable e) {
                        this.throwable = e;
                    }
                }
                return this.throwable == null && this.nextMatched != null;
            }

            public ITimeSeriesSchemaInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ITimeSeriesSchemaInfo result = this.nextMatched;
                this.nextMatched = null;
                return result;
            }

            private void getNext() throws IOException {
                this.nextMatched = null;
                while (allMatchedNodes.hasNext()) {
                    IMeasurementMNode node = (IMeasurementMNode)allMatchedNodes.next();
                    if (!(plan.isPrefixMatch() ? pathPattern.prefixMatchFullPath(node.getPartialPath()) : pathPattern.matchFullPath(node.getPartialPath()))) continue;
                    Pair<Map<String, String>, Map<String, String>> tagAndAttributePair = TagManager.this.readTagFile(node.getOffset());
                    this.nextMatched = new ShowTimeSeriesResult(node.getFullPath(), node.getAlias(), node.getSchema(), (Map)tagAndAttributePair.left, (Map)tagAndAttributePair.right, node.getParent().getAsDeviceMNode().isAligned());
                    break;
                }
            }

            public Throwable getFailure() {
                return this.throwable;
            }

            public boolean isSuccess() {
                return this.throwable == null;
            }

            public void close() {
            }
        };
        TimeseriesReaderWithViewFetch reader = new TimeseriesReaderWithViewFetch(schemaIterator, schemaFilter);
        if (plan.getLimit() > 0L || plan.getOffset() > 0L) {
            return new SchemaReaderLimitOffsetWrapper<ITimeSeriesSchemaInfo>(reader, plan.getLimit(), plan.getOffset());
        }
        return reader;
    }

    public void removeFromTagInvertedIndex(IMeasurementMNode<?> node) throws IOException {
        if (node.getOffset() < 0L) {
            return;
        }
        Map<String, String> tagMap = this.tagLogFile.readTag(node.getOffset());
        if (tagMap != null) {
            for (Map.Entry<String, String> entry : tagMap.entrySet()) {
                if (this.tagIndex.containsKey(entry.getKey()) && this.tagIndex.get(entry.getKey()).containsKey(entry.getValue())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format(String.format(DEBUG_MSG, "Deletetag key is %s, tag value is %s, tlog offset is %d", node.getFullPath()), entry.getKey(), entry.getValue(), node.getOffset()));
                    }
                    this.removeIndex(entry.getKey(), entry.getValue(), node);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug(String.format(String.format(DEBUG_MSG_1, "Deletebefore deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", node.getFullPath()), entry.getKey(), entry.getValue(), node.getOffset(), this.tagIndex.containsKey(entry.getKey())));
            }
        }
    }

    public void updateTagsAndAttributes(Map<String, String> tagsMap, Map<String, String> attributesMap, IMeasurementMNode<?> leafMNode) throws MetadataException, IOException {
        Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(leafMNode.getOffset());
        if (tagsMap != null) {
            for (Map.Entry<String, String> entry : tagsMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                String beforeValue = (String)((Map)pair.left).get(key);
                ((Map)pair.left).put(key, value);
                if (beforeValue != null && !beforeValue.equals(value)) {
                    if (this.tagIndex.containsKey(key) && this.tagIndex.get(key).containsKey(beforeValue)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.format(String.format(DEBUG_MSG, "Upserttag key is %s, tag value is %s, tlog offset is %d", leafMNode.getFullPath()), key, beforeValue, leafMNode.getOffset()));
                        }
                        this.removeIndex(key, beforeValue, leafMNode);
                    } else if (logger.isDebugEnabled()) {
                        logger.debug(String.format(String.format(DEBUG_MSG_1, "Upsertbefore deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", leafMNode.getFullPath()), key, beforeValue, leafMNode.getOffset(), this.tagIndex.containsKey(key)));
                    }
                }
                if (beforeValue != null && beforeValue.equals(value)) continue;
                this.addIndex(key, value, leafMNode);
            }
        }
        if (attributesMap != null) {
            ((Map)pair.right).putAll(attributesMap);
        }
        this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
    }

    public void addAttributes(Map<String, String> attributesMap, PartialPath fullPath, IMeasurementMNode<?> leafMNode) throws MetadataException, IOException {
        Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(leafMNode.getOffset());
        for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (((Map)pair.right).containsKey(key)) {
                throw new MetadataException(String.format("TimeSeries [%s] already has the attribute [%s].", fullPath, key));
            }
            ((Map)pair.right).put(key, value);
        }
        this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
    }

    public void addTags(Map<String, String> tagsMap, PartialPath fullPath, IMeasurementMNode<?> leafMNode) throws MetadataException, IOException {
        Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(leafMNode.getOffset());
        for (Map.Entry<String, String> entry : tagsMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (((Map)pair.left).containsKey(key)) {
                throw new MetadataException(String.format("TimeSeries [%s] already has the tag [%s].", fullPath, key));
            }
            ((Map)pair.left).put(key, value);
        }
        this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
        this.addIndex(tagsMap, leafMNode);
    }

    public void dropTagsOrAttributes(Set<String> keySet, PartialPath fullPath, IMeasurementMNode<?> leafMNode) throws MetadataException, IOException {
        Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(leafMNode.getOffset());
        HashMap<String, String> deleteTag = new HashMap<String, String>();
        for (String string : keySet) {
            String removeVal = (String)((Map)pair.left).remove(string);
            if (removeVal != null) {
                deleteTag.put(string, removeVal);
                continue;
            }
            removeVal = (String)((Map)pair.right).remove(string);
            if (removeVal != null) continue;
            logger.warn("TimeSeries [{}] does not have tag/attribute [{}]", (Object)fullPath, (Object)string);
        }
        this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
        if (!deleteTag.isEmpty()) {
            for (Map.Entry entry : deleteTag.entrySet()) {
                if (this.tagIndex.containsKey(entry.getKey()) && this.tagIndex.get(entry.getKey()).containsKey(entry.getValue())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format(String.format(DEBUG_MSG, "Droptag key is %s, tag value is %s, tlog offset is %d", leafMNode.getFullPath()), entry.getKey(), entry.getValue(), leafMNode.getOffset()));
                    }
                    this.removeIndex((String)entry.getKey(), (String)entry.getValue(), leafMNode);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug(String.format(String.format(DEBUG_MSG_1, "Dropbefore deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", leafMNode.getFullPath()), entry.getKey(), entry.getValue(), leafMNode.getOffset(), this.tagIndex.containsKey(entry.getKey())));
            }
        }
    }

    public void setTagsOrAttributesValue(Map<String, String> alterMap, PartialPath fullPath, IMeasurementMNode<?> leafMNode) throws MetadataException, IOException {
        String key;
        Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(leafMNode.getOffset());
        HashMap<String, String> oldTagValue = new HashMap<String, String>();
        HashMap<String, String> newTagValue = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : alterMap.entrySet()) {
            key = entry.getKey();
            String value = entry.getValue();
            if (((Map)pair.left).containsKey(key)) {
                oldTagValue.put(key, (String)((Map)pair.left).get(key));
                newTagValue.put(key, value);
                ((Map)pair.left).put(key, value);
                continue;
            }
            if (((Map)pair.right).containsKey(key)) {
                ((Map)pair.right).put(key, value);
                continue;
            }
            throw new MetadataException(String.format("TimeSeries [%s] does not have tag/attribute [%s].", fullPath, key), true);
        }
        this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
        for (Map.Entry<String, String> entry : oldTagValue.entrySet()) {
            key = entry.getKey();
            String beforeValue = entry.getValue();
            String currentValue = (String)newTagValue.get(key);
            if (this.tagIndex.containsKey(key) && this.tagIndex.get(key).containsKey(beforeValue)) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format(String.format(DEBUG_MSG, "Settag key is %s, tag value is %s, tlog offset is %d", leafMNode.getFullPath()), entry.getKey(), beforeValue, leafMNode.getOffset()));
                }
                this.removeIndex(key, beforeValue, leafMNode);
            } else if (logger.isDebugEnabled()) {
                logger.debug(String.format(String.format(DEBUG_MSG_1, "Setbefore deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", leafMNode.getFullPath()), key, beforeValue, leafMNode.getOffset(), this.tagIndex.containsKey(key)));
            }
            this.addIndex(key, currentValue, leafMNode);
        }
    }

    public void renameTagOrAttributeKey(String oldKey, String newKey, PartialPath fullPath, IMeasurementMNode<?> leafMNode) throws MetadataException, IOException {
        Pair<Map<String, String>, Map<String, String>> pair = this.tagLogFile.read(leafMNode.getOffset());
        if (((Map)pair.left).containsKey(newKey) || ((Map)pair.right).containsKey(newKey)) {
            throw new MetadataException(String.format("TimeSeries [%s] already has a tag/attribute named [%s].", fullPath, newKey), true);
        }
        if (((Map)pair.left).containsKey(oldKey)) {
            String value = (String)((Map)pair.left).remove(oldKey);
            ((Map)pair.left).put(newKey, value);
            this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
            if (this.tagIndex.containsKey(oldKey) && this.tagIndex.get(oldKey).containsKey(value)) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format(String.format(DEBUG_MSG, "Renametag key is %s, tag value is %s, tlog offset is %d", leafMNode.getFullPath()), oldKey, value, leafMNode.getOffset()));
                }
                this.removeIndex(oldKey, value, leafMNode);
            } else if (logger.isDebugEnabled()) {
                logger.debug(String.format(String.format(DEBUG_MSG_1, "Renamebefore deleting it, tag key is %s, tag value is %s, tlog offset is %d, contains key %b", leafMNode.getFullPath()), oldKey, value, leafMNode.getOffset(), this.tagIndex.containsKey(oldKey)));
            }
            this.addIndex(newKey, value, leafMNode);
        } else if (((Map)pair.right).containsKey(oldKey)) {
            ((Map)pair.right).put(newKey, (String)((Map)pair.right).remove(oldKey));
            this.tagLogFile.write((Map)pair.left, (Map)pair.right, leafMNode.getOffset());
        } else {
            throw new MetadataException(String.format("TimeSeries [%s] does not have tag/attribute [%s].", fullPath, oldKey), true);
        }
    }

    public long writeTagFile(Map<String, String> tags, Map<String, String> attributes) throws MetadataException, IOException {
        return this.tagLogFile.write(tags, attributes);
    }

    public Pair<Map<String, String>, Map<String, String>> readTagFile(long tagFileOffset) throws IOException {
        return this.tagLogFile.read(tagFileOffset);
    }

    public Map<String, String> readTags(IMeasurementMNode<?> node) {
        try {
            return (Map)this.readTagFile(node.getOffset()).getLeft();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> readAttributes(IMeasurementMNode<?> node) {
        try {
            return (Map)this.readTagFile(node.getOffset()).getRight();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() throws IOException {
        this.tagIndex.clear();
        if (this.tagLogFile != null) {
            this.tagLogFile.close();
            this.tagLogFile = null;
        }
    }

    private void requestMemory(long size) {
        if (this.regionStatistics != null) {
            this.regionStatistics.requestMemory(size);
        }
    }

    private void releaseMemory(long size) {
        if (this.regionStatistics != null) {
            this.regionStatistics.releaseMemory(size);
        }
    }
}

