/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.ModifiedStatus;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.CompactChunkPlan;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.Pair;

public class BatchCompactionPlan {
    public static long maxCachedTimeChunksSize = 0x200000L;
    private final List<CompactChunkPlan> compactChunkPlans = new ArrayList<CompactChunkPlan>();
    private final Map<String, Map<TimeRange, ModifiedStatus>> alignedPageModifiedStatusCache = new HashMap<String, Map<TimeRange, ModifiedStatus>>();
    private final Map<Pair<String, Long>, Chunk> cachedTimeChunks = new HashMap<Pair<String, Long>, Chunk>();
    private long cachedTimeChunkSize = 0L;

    public Chunk getTimeChunkFromCache(TsFileSequenceReader reader, ChunkMetadata chunkMetadata) throws IOException {
        Pair key = new Pair((Object)reader.getFileName(), (Object)chunkMetadata.getOffsetOfChunkHeader());
        Chunk chunk = this.cachedTimeChunks.get(key);
        if (chunk == null) {
            chunk = reader.readMemChunk(chunkMetadata);
        }
        chunk.getData().rewind();
        return chunk;
    }

    public void addTimeChunkToCache(String file, long offset, Chunk chunk) {
        if (this.cachedTimeChunkSize >= maxCachedTimeChunksSize) {
            return;
        }
        this.cachedTimeChunks.put((Pair<String, Long>)new Pair((Object)file, (Object)offset), new Chunk(chunk.getHeader(), chunk.getData(), chunk.getDeleteIntervalList(), chunk.getChunkStatistic()));
        this.cachedTimeChunkSize += (long)chunk.getHeader().getDataSize();
    }

    public void recordCompactedChunk(CompactChunkPlan compactChunkPlan) {
        this.compactChunkPlans.add(compactChunkPlan);
    }

    public CompactChunkPlan getCompactChunkPlan(int i) {
        return this.compactChunkPlans.get(i);
    }

    public void recordPageModifiedStatus(String file, TimeRange timeRange, ModifiedStatus modifiedStatus) {
        this.alignedPageModifiedStatusCache.computeIfAbsent(file, k1 -> new HashMap()).computeIfAbsent(timeRange, k2 -> modifiedStatus);
    }

    public ModifiedStatus getAlignedPageModifiedStatus(String file, TimeRange timeRange) {
        return (ModifiedStatus)((Object)this.alignedPageModifiedStatusCache.getOrDefault(file, Collections.emptyMap()).get(timeRange));
    }

    public int compactedChunkNum() {
        return this.compactChunkPlans.size();
    }

    public boolean isEmpty() {
        return this.compactChunkPlans.isEmpty();
    }

    public static void setMaxCachedTimeChunksSize(long size) {
        maxCachedTimeChunksSize = size;
    }

    public static long getMaxCachedTimeChunksSize() {
        return maxCachedTimeChunksSize;
    }

    public String toString() {
        return this.compactChunkPlans.toString();
    }
}

