/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.dboe.base.record.Record;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.dboe.base.record.RecordMapper;
import org.apache.jena.dboe.index.RangeIndex;
import org.apache.jena.dboe.trans.bplustree.BPT;
import org.apache.jena.dboe.trans.bplustree.BPTStateMgr;
import org.apache.jena.dboe.trans.bplustree.BPTreeDistinctKeyPrefixIterator;
import org.apache.jena.dboe.trans.bplustree.BPTreeNode;
import org.apache.jena.dboe.trans.bplustree.BPTreeNodeMgr;
import org.apache.jena.dboe.trans.bplustree.BPTreeRangeIterator;
import org.apache.jena.dboe.trans.bplustree.BPTreeRangeIteratorMapper;
import org.apache.jena.dboe.trans.bplustree.BPTreeRecordsMgr;
import org.apache.jena.dboe.trans.bplustree.BPlusTreeParams;
import org.apache.jena.dboe.trans.bplustree.BptTxnState;
import org.apache.jena.dboe.trans.bplustree.Mode;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.TransactionalComponentLifecycle;
import org.apache.jena.dboe.transaction.txn.TxnId;
import org.apache.jena.query.ReadWrite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPlusTree
extends TransactionalComponentLifecycle<BptTxnState>
implements RangeIndex {
    private static Logger log = LoggerFactory.getLogger(BPlusTree.class);
    private int rootIdx = -99;
    private BPTStateMgr stateManager;
    private BPTreeNodeMgr nodeManager;
    private BPTreeRecordsMgr recordsMgr;
    private final BPlusTreeParams bpTreeParams;
    private Mode mode = Mode.TRANSACTIONAL;
    private BptTxnState nonTxnState = null;
    private static Record noMin = null;
    private static Record noMax = null;
    private static int SLICE = 10000;

    BPlusTree(ComponentId componentId, BPlusTreeParams bpTreeParams) {
        super(componentId);
        this.bpTreeParams = bpTreeParams;
        this.nodeManager = null;
        this.recordsMgr = null;
    }

    void init(BPTStateMgr stateManager, BPTreeNodeMgr nodeManager, BPTreeRecordsMgr recordsMgr) {
        this.rootIdx = stateManager.getRoot();
        this.stateManager = stateManager;
        this.nodeManager = nodeManager;
        this.recordsMgr = recordsMgr;
    }

    private BPTreeNode getRootRead() {
        if (this.isTransactional()) {
            super.checkTxn();
            int rootId = ((BptTxnState)super.getDataState()).getRoot();
            return this.nodeManager.getRead(rootId, -2);
        }
        return this.nodeManager.getRead(this.rootIdx, -2);
    }

    private BPTreeNode getRootWrite() {
        if (this.isTransactional()) {
            super.requireWriteTxn();
            int rootId = ((BptTxnState)super.getDataState()).getRoot();
            return this.nodeManager.getRead(rootId, -2);
        }
        return this.nodeManager.getRead(this.rootIdx, -2);
    }

    private boolean isTransactional() {
        return this.mode == Mode.TRANSACTIONAL;
    }

    private void releaseRootRead(BPTreeNode rootNode) {
        rootNode.release();
    }

    private void releaseRootWrite(BPTreeNode rootNode) {
        rootNode.release();
    }

    private void setRoot(BPTreeNode node) {
        throw new InternalErrorException("BPlusTree.setRoot");
    }

    public void newRoot(BPTreeNode newRoot) {
        if (this.isTransactional()) {
            ((BptTxnState)this.getDataState()).setRoot(newRoot.getId());
        } else {
            this.rootIdx = newRoot.getId();
        }
    }

    public int getRootId() {
        if (super.isActiveTxn()) {
            return ((BptTxnState)super.getDataState()).getRoot();
        }
        return this.rootIdx;
    }

    BptTxnState state() {
        if (this.mode == Mode.TRANSACTIONAL) {
            if (super.isActiveTxn()) {
                return (BptTxnState)super.getDataState();
            }
            return null;
        }
        return this.nonTxnState;
    }

    public BPlusTreeParams getParams() {
        return this.bpTreeParams;
    }

    public BPTStateMgr getStateManager() {
        return this.stateManager;
    }

    public BPTreeNodeMgr getNodeManager() {
        return this.nodeManager;
    }

    public BPTreeRecordsMgr getRecordsMgr() {
        return this.recordsMgr;
    }

    public RecordFactory getRecordFactory() {
        return this.bpTreeParams.recordFactory;
    }

    public Record find(Record record) {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRootRead();
        Record v = BPTreeNode.search(root, record);
        this.releaseRootRead(root);
        this.finishReadBlkMgr();
        return v;
    }

    public boolean contains(Record record) {
        Record r = this.find(record);
        return r != null;
    }

    public Record minKey() {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRootRead();
        Record r = BPTreeNode.minRecord(root);
        this.releaseRootRead(root);
        this.finishReadBlkMgr();
        return r;
    }

    public Record maxKey() {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRootRead();
        Record r = BPTreeNode.maxRecord(root);
        this.releaseRootRead(root);
        this.finishReadBlkMgr();
        return r;
    }

    public boolean insert(Record record) {
        return this.insertAndReturnOld(record) == null;
    }

    public Record insertAndReturnOld(Record record) {
        this.startUpdateBlkMgr();
        BPTreeNode root = this.getRootWrite();
        Record r = BPTreeNode.insert(root, record);
        this.releaseRootWrite(root);
        this.finishUpdateBlkMgr();
        return r;
    }

    public boolean delete(Record record) {
        return this.deleteAndReturnOld(record) != null;
    }

    public Record deleteAndReturnOld(Record record) {
        this.startUpdateBlkMgr();
        BPTreeNode root = this.getRootWrite();
        Record r = BPTreeNode.delete(root, record);
        this.releaseRootWrite(root);
        this.finishUpdateBlkMgr();
        return r;
    }

    public Iterator<Record> iterator() {
        return this.iterator(noMin, noMax);
    }

    public Iterator<Record> iterator(Record fromRec, Record toRec) {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRootRead();
        this.releaseRootRead(root);
        this.finishReadBlkMgr();
        return BPTreeRangeIterator.create(root, fromRec, toRec);
    }

    public Iterator<Record> distinctByKeyPrefix(int keyPrefixLength) {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRootRead();
        this.releaseRootRead(root);
        this.finishReadBlkMgr();
        return BPTreeDistinctKeyPrefixIterator.create(root, keyPrefixLength);
    }

    public <X> Iterator<X> iterator(Record minRec, Record maxRec, RecordMapper<X> mapper) {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRootRead();
        this.releaseRootRead(root);
        this.finishReadBlkMgr();
        return this.iterator(root, minRec, maxRec, mapper);
    }

    private <X> Iterator<X> iterator(BPTreeNode node, Record minRec, Record maxRec, RecordMapper<X> mapper) {
        int keyLen = this.recordsMgr.getRecordBufferPageMgr().getRecordFactory().keyLength();
        return BPTreeRangeIteratorMapper.create(node, minRec, maxRec, keyLen, mapper);
    }

    void startReadBlkMgr() {
        this.nodeManager.startRead();
        this.recordsMgr.startRead();
    }

    void finishReadBlkMgr() {
        this.nodeManager.finishRead();
        this.recordsMgr.finishRead();
    }

    private void startUpdateBlkMgr() {
        this.nodeManager.startUpdate();
        this.recordsMgr.startUpdate();
    }

    private void finishUpdateBlkMgr() {
        this.nodeManager.finishUpdate();
        this.recordsMgr.finishUpdate();
    }

    public boolean isEmpty() {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRootRead();
        boolean b = !root.hasAnyKeys();
        this.releaseRootRead(root);
        this.finishReadBlkMgr();
        return b;
    }

    public void clear() {
        Record[] records = new Record[SLICE];
        block0: while (true) {
            Iterator<Record> iter = this.iterator();
            int i = 0;
            for (i = 0; i < SLICE && iter.hasNext(); ++i) {
                Record r;
                records[i] = r = iter.next();
            }
            if (i == 0) break;
            int j = 0;
            while (true) {
                if (j >= i) continue block0;
                this.delete(records[j]);
                records[j] = null;
                ++j;
            }
            break;
        }
    }

    public void sync() {
        if (this.nodeManager.getBlockMgr() != null) {
            this.nodeManager.getBlockMgr().sync();
        }
        if (this.recordsMgr.getBlockMgr() != null) {
            this.recordsMgr.getBlockMgr().sync();
        }
    }

    public void close() {
        this.nodeManager.close();
        this.recordsMgr.close();
        this.stateManager.close();
    }

    public long size() {
        Iterator<Record> iter = this.iterator();
        return Iter.count(iter);
    }

    public void check() {
        BPTreeNode root = this.getRootRead();
        try {
            root.checkNodeDeep();
        }
        finally {
            this.releaseRootRead(root);
        }
    }

    public void dump() {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRootRead();
        boolean b = BPT.Logging;
        BPT.Logging = false;
        try {
            root.dump();
        }
        finally {
            this.releaseRootRead(root);
            BPT.Logging = b;
        }
        this.finishReadBlkMgr();
    }

    public void dump(IndentedWriter out) {
        BPTreeNode root = this.getRootRead();
        try {
            root.dump(out);
        }
        finally {
            this.releaseRootRead(root);
        }
    }

    public void nonTransactional() {
        this.setMode(Mode.MUTABLE);
    }

    private void setMode(Mode newMode) {
        this.mode = newMode;
        switch (this.mode) {
            case TRANSACTIONAL: {
                this.nonTxnState = null;
                break;
            }
            case MUTABLE: {
                this.nonTxnState = new BptTxnState(0, 0L, 0L);
                break;
            }
            case IMMUTABLE: {
                this.nonTxnState = new BptTxnState(0, this.nodeManager.allocLimit(), this.recordsMgr.allocLimit());
                break;
            }
            case IMMUTABLE_ALL: {
                this.nonTxnState = new BptTxnState(0, Long.MAX_VALUE, Long.MAX_VALUE);
            }
        }
    }

    public void startRecovery() {
    }

    public void recover(ByteBuffer ref) {
        this.stateManager.setState(ref);
        this.rootIdx = this.stateManager.getRoot();
        this.nodeManager.resetAlloc(this.stateManager.getNodeBlocksLimit());
        this.recordsMgr.resetAlloc(this.stateManager.getRecordsBlocksLimit());
    }

    public void finishRecovery() {
        this.stateManager.sync();
    }

    public void cleanStart() {
    }

    protected BptTxnState _begin(ReadWrite readWrite, TxnId txnId) {
        return this.createState();
    }

    private BptTxnState createState() {
        return new BptTxnState(this.rootIdx, this.nodeManager.allocLimit(), this.recordsMgr.allocLimit());
    }

    protected BptTxnState _promote(TxnId txnId, BptTxnState oldState) {
        BptTxnState newState = this.createState();
        return newState;
    }

    protected ByteBuffer _commitPrepare(TxnId txnId, BptTxnState state) {
        this.nodeManager.getBlockMgr().sync();
        this.recordsMgr.getBlockMgr().sync();
        long nodeLimit = this.nodeManager.allocLimit();
        long recordsLimit = this.recordsMgr.allocLimit();
        this.stateManager.setState(state.getRoot(), nodeLimit, recordsLimit);
        return this.stateManager.getState();
    }

    protected void _commit(TxnId txnId, BptTxnState state) {
        if (this.isWriteTxn()) {
            this.rootIdx = state.getRoot();
            this.stateManager.sync();
        }
    }

    protected void _commitEnd(TxnId txnId, BptTxnState state) {
    }

    protected void _abort(TxnId txnId, BptTxnState state) {
        if (this.isWriteTxn()) {
            this.rootIdx = state.initialroot;
            this.nodeManager.resetAlloc(state.boundaryBlocksNode);
            this.recordsMgr.resetAlloc(state.boundaryBlocksRecord);
            this.stateManager.setState(state.initialroot, state.boundaryBlocksNode, state.boundaryBlocksRecord);
            this.stateManager.sync();
        }
    }

    protected void _complete(TxnId txnId, BptTxnState state) {
    }

    protected void _shutdown() {
    }
}

