/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.compact.writer.CompactOut;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.ConstraintVisitor;
import org.apache.jena.shacl.parser.ShaclParseException;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.validation.event.ConstraintEvaluatedOnFocusNodeEvent;
import org.apache.jena.shacl.validation.event.ConstraintEvaluatedOnSinglePathNodeEvent;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathFactory;
import org.apache.jena.sparql.util.graph.GNode;
import org.apache.jena.sparql.util.graph.GraphList;
import org.apache.jena.system.G;

public class ClosedConstraint
implements Constraint {
    private final Set<Node> expected;
    private final List<Node> ignoredProperties;
    private final boolean active;

    public ClosedConstraint(Graph shapeGraph, Node shapeNode, boolean active) {
        this.expected = this.shapeProperties(shapeGraph, shapeNode);
        this.active = active;
        List<Node> ignored = ClosedConstraint.ignoredProperties(shapeGraph, shapeNode);
        this.ignoredProperties = ignored == null ? Collections.emptyList() : ignored;
    }

    public Set<Node> getExpected() {
        return Collections.unmodifiableSet(this.expected);
    }

    public List<Node> getIgnoredProperties() {
        return Collections.unmodifiableList(this.ignoredProperties);
    }

    public boolean isActive() {
        return this.active;
    }

    private static List<Node> ignoredProperties(Graph shapesGraph, Node shNode) {
        Node ignored;
        List ignoredProperties = null;
        if (G.contains((Graph)shapesGraph, (Node)shNode, (Node)SHACL.ignoredProperties, null) && (ignored = G.getOneSP((Graph)shapesGraph, (Node)shNode, (Node)SHACL.ignoredProperties)) != null) {
            ignoredProperties = GraphList.members((GNode)GNode.create((Graph)shapesGraph, (Node)ignored));
            ignoredProperties.forEach(p -> {
                if (!p.isURI()) {
                    throw new ShaclParseException("Only URIs allowed in sh:ignoredProperties at " + ShLib.displayStr(shNode));
                }
            });
        }
        return ignoredProperties;
    }

    @Override
    public void validateNodeShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        this.validate(vCxt, data, shape, focusNode);
    }

    @Override
    public void validatePropertyShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode, Path path, Set<Node> valueNodes) {
        this.validate(vCxt, data, shape, focusNode);
    }

    private void validate(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        if (!this.active) {
            return;
        }
        Set<Node> actual = this.properties(data, focusNode);
        boolean passed = true;
        for (Node p : actual) {
            if (this.expected.contains(p) || this.ignoredProperties.contains(p)) continue;
            Path path = PathFactory.pathLink((Node)p);
            passed = false;
            G.listSP((Graph)data, (Node)focusNode, (Node)p).forEach(o -> {
                String msg = this.toString() + " Property = " + ShLib.displayStr(p) + " : Object = " + ShLib.displayStr(o);
                vCxt.notifyValidationListener(() -> new ConstraintEvaluatedOnSinglePathNodeEvent(vCxt, shape, focusNode, this, path, (Node)o, false));
                vCxt.reportEntry(msg, shape, focusNode, path, (Node)o, this);
            });
        }
        if (passed) {
            vCxt.notifyValidationListener(() -> new ConstraintEvaluatedOnFocusNodeEvent(vCxt, shape, focusNode, this, true));
        }
    }

    private Set<Node> properties(Graph data, Node focusNode) {
        return G.find((Graph)data, (Node)focusNode, (Node)Node.ANY, (Node)Node.ANY).mapWith(Triple::getPredicate).filterKeep(p -> p.isURI()).toSet();
    }

    private Set<Node> shapeProperties(Graph shapeGraph, Node shapeNode) {
        List propertyShapes = G.listSP((Graph)shapeGraph, (Node)shapeNode, (Node)SHACL.property);
        HashSet<Node> properties = new HashSet<Node>();
        propertyShapes.forEach(ps -> shapeGraph.find(ps, SHACL.path, null).mapWith(Triple::getObject).filterKeep(Node::isURI).forEachRemaining(properties::add));
        return properties;
    }

    @Override
    public Node getComponent() {
        return SHACL.ClosedConstraintComponent;
    }

    @Override
    public void visit(ConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
        CompactOut.compactUnquotedString(out, "closed", Boolean.toString(this.active));
        if (!this.ignoredProperties.isEmpty()) {
            out.print(" ");
            CompactOut.compactArrayNodes(out, nodeFmt, "ignoredProperties", this.ignoredProperties);
        }
    }

    public String toString() {
        String x = "Closed" + String.valueOf(this.expected);
        if (!this.ignoredProperties.isEmpty()) {
            x = x + String.valueOf(this.ignoredProperties);
        }
        return x;
    }

    public int hashCode() {
        return Objects.hash(this.active, this.expected, this.ignoredProperties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClosedConstraint other = (ClosedConstraint)obj;
        return this.active == other.active && Objects.equals(this.expected, other.expected) && Objects.equals(this.ignoredProperties, other.ignoredProperties);
    }
}

