/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library.cdt;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.cdt.CDTFactory;
import org.apache.jena.cdt.CDTKey;
import org.apache.jena.cdt.CDTValue;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.library.cdt.CDTLiteralFunctionUtils;

public class MapFct
extends FunctionBase {
    @Override
    public void checkBuild(String uri, ExprList args) {
        if (args.size() % 2 == 1) {
            throw new QueryBuildException("Function '" + Lib.className(this) + "' takes an even number of arguments");
        }
    }

    @Override
    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        if (args.size() % 2 == 1) {
            throw new ExprException("Function '" + Lib.className(this) + "' takes an even number of arguments");
        }
        HashMap<CDTKey, CDTValue> map = new HashMap<CDTKey, CDTValue>();
        Iterator<Expr> it = args.iterator();
        while (it.hasNext()) {
            Expr exprKey = it.next();
            Expr exprValue = it.next();
            CDTKey key = this.getKey(exprKey, binding, env);
            if (key == null) continue;
            CDTValue value = this.getValue(exprValue, binding, env);
            map.put(key, value);
        }
        return CDTLiteralFunctionUtils.createNodeValue(map);
    }

    protected CDTKey getKey(Expr e2, Binding binding, FunctionEnv env) {
        NodeValue nv;
        try {
            nv = e2.eval(binding, env);
        }
        catch (ExprException ex) {
            return null;
        }
        Node n = nv.asNode();
        if (!n.isURI() && !n.isLiteral()) {
            return null;
        }
        return CDTFactory.createKey(n);
    }

    protected CDTValue getValue(Expr e2, Binding binding, FunctionEnv env) {
        NodeValue nv;
        try {
            nv = e2.eval(binding, env);
        }
        catch (ExprException ex) {
            return CDTFactory.getNullValue();
        }
        return CDTFactory.createValue(nv.asNode());
    }

    @Override
    public NodeValue exec(List<NodeValue> args) {
        throw new IllegalStateException("should never end up here");
    }
}

