/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.spi.connector.transport;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aether.spi.connector.transport.TransportListener;
import org.eclipse.aether.spi.connector.transport.TransportTask;

public final class GetTask
extends TransportTask {
    private Path dataPath;
    private boolean resume;
    private ByteArrayOutputStream dataBytes;
    private Map<String, String> checksums = Collections.emptyMap();

    public GetTask(URI location) {
        this.setLocation(location);
    }

    public OutputStream newOutputStream() throws IOException {
        return this.newOutputStream(false);
    }

    public OutputStream newOutputStream(boolean resume) throws IOException {
        if (this.dataPath != null) {
            if (this.resume && resume) {
                return Files.newOutputStream(this.dataPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
            }
            return Files.newOutputStream(this.dataPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        if (this.dataBytes == null) {
            this.dataBytes = new ByteArrayOutputStream(1024);
        } else if (!resume) {
            this.dataBytes.reset();
        }
        return this.dataBytes;
    }

    @Deprecated
    public File getDataFile() {
        return this.dataPath != null ? this.dataPath.toFile() : null;
    }

    public Path getDataPath() {
        return this.dataPath;
    }

    @Deprecated
    public GetTask setDataFile(File dataFile) {
        return this.setDataFile(dataFile, false);
    }

    public GetTask setDataPath(Path dataPath) {
        return this.setDataPath(dataPath, false);
    }

    @Deprecated
    public GetTask setDataFile(File dataFile, boolean resume) {
        return this.setDataPath(dataFile != null ? dataFile.toPath() : null, resume);
    }

    public GetTask setDataPath(Path dataPath, boolean resume) {
        this.dataPath = dataPath;
        this.resume = resume;
        return this;
    }

    public long getResumeOffset() {
        if (this.resume) {
            if (this.dataPath != null) {
                try {
                    return Files.size(this.dataPath);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            if (this.dataBytes != null) {
                return this.dataBytes.size();
            }
        }
        return 0L;
    }

    public byte[] getDataBytes() {
        if (this.dataPath != null || this.dataBytes == null) {
            return EMPTY;
        }
        return this.dataBytes.toByteArray();
    }

    public String getDataString() {
        if (this.dataPath != null || this.dataBytes == null) {
            return "";
        }
        return new String(this.dataBytes.toByteArray(), StandardCharsets.UTF_8);
    }

    @Override
    public GetTask setListener(TransportListener listener) {
        super.setListener(listener);
        return this;
    }

    public Map<String, String> getChecksums() {
        return this.checksums;
    }

    public GetTask setChecksum(String algorithm, String value) {
        if (algorithm != null) {
            if (this.checksums.isEmpty()) {
                this.checksums = new HashMap<String, String>();
            }
            if (value != null && !value.isEmpty()) {
                this.checksums.put(algorithm, value);
            } else {
                this.checksums.remove(algorithm);
            }
        }
        return this;
    }

    public String toString() {
        return "<< " + this.getLocation();
    }
}

