---
layout: news_item
title: "ORC 1.7.3 Released"
date: "2022-02-09 03:00:00 -0800"
author: dongjoon
version: 1.7.3
categories: [release]
---

The ORC team is excited to announce the release of ORC v1.7.3.

{% assign releaseName = "1.7.3" %}
{% include release_description.md %}

The 'bug' fixes:

- [ORC-1060]({{site.jira}}/ORC-1060) Reduce memory usage when vectorized reading dictionary string encoding columns
- [ORC-1065]({{site.jira}}/ORC-1065) Fix IndexOutOfBoundsException in ReaderImpl.extractFileTail
- [ORC-1067]({{site.jira}}/ORC-1067) [C++] Upgrade ZSTD to 1.5.1
- [ORC-1078]({{site.jira}}/ORC-1078) Row group end offset doesn't accommodate all the blocks
- [ORC-1081]({{site.jira}}/ORC-1081) Fix heap-use-after-free in SearchArgumentBuilderImpl::end()
- [ORC-1087]({{site.jira}}/ORC-1087) [C++] Handle unloaded seek positions when seeking in an uncompressed chunk
- [ORC-1092]({{site.jira}}/ORC-1092) [C++] Upgrade LZ4 to version 1.9.3
- [ORC-1102]({{site.jira}}/ORC-1102) [C++] Upgrade ZSTD to 1.5.2

The 'tools' improvements:
- [ORC-1055]({{site.jira}}/ORC-1055) [C++] Add the timezone option for the csv-import tool 
- [ORC-1082]({{site.jira}}/ORC-1082) Improve FileDump and JsonFileDump to be robust on missing column statistics
- [ORC-1092]({{site.jira}}/ORC-1092) [C++] Support specifying type ids or column names in cpp tools 

The 'documentation' patches:
- [ORC-1050]({{site.jira}}/ORC-1050) Update ORC site README.md and release process page
- [ORC-1069]({{site.jira}}/ORC-1069) Update building.md
- [ORC-1071]({{site.jira}}/ORC-1071) Update 'adopters' page
- [ORC-1091]({{site.jira}}/ORC-1091) Add 'Tests' section at ORC 'develop' page
- [ORC-1112]({{site.jira}}/ORC-1112) Add 'Using with Python' web page 
- [ORC-1114]({{site.jira}}/ORC-1114) Update 'Using with Python' page with 'PyArrow' 7.0.0

The 'task' patches:
- [ORC-1070]({{site.jira}}/ORC-1070) Upgrade site docker image to use Ubuntu 20.04
- [ORC-1072]({{site.jira}}/ORC-1072) Add 'Stale' GitHub Action job
- [ORC-1094]({{site.jira}}/ORC-1094) Enable GitHub issues tab
- [ORC-1095]({{site.jira}}/ORC-1095) Deprecate 'UnknownFormatException'

The 'tests' fixes:
- [ORC-875]({{site.jira}}/ORC-875) Add GitHub Action job for Windows Server 2019
- [ORC-878]({{site.jira}}/ORC-878) Bump auto-service from 1.0-rc7 to 1.0
- [ORC-881]({{site.jira}}/ORC-881) Bump slf4j.version from 1.7.30 to 1.7.32
- [ORC-989]({{site.jira}}/ORC-989) Bump checkstyle from 8.45.1 to 9.0
- [ORC-993]({{site.jira}}/ORC-993) Bump junit.version from 5.7.2 to 5.8.0
- [ORC-1018]({{site.jira}}/ORC-1018) Bump checkstyle from 9.0 to 9.0.1
- [ORC-1033]({{site.jira}}/ORC-1033) Bump junit.version from 5.8.0 to 5.8.1
- [ORC-1044]({{site.jira}}/ORC-1044) Bump reproducible-build-maven-plugin to 0.14
- [ORC-1048]({{site.jira}}/ORC-1048) Bump checkstyle from 9.0.1 to 9.1
- [ORC-1052]({{site.jira}}/ORC-1052) Bump avro.version from 1.10.2 to 1.11.0
- [ORC-1057]({{site.jira}}/ORC-1057) Bump junit.version from 5.8.1 to 5.8.2
- [ORC-1061]({{site.jira}}/ORC-1061) Bump checkstyle from 9.1 to 9.2
- [ORC-1066]({{site.jira}}/ORC-1066) Bump guava from 30.1.1-jre to 31.0.1-jre
- [ORC-1068]({{site.jira}}/ORC-1068) [C++] Stabilize HAS_POST_2038 test
- [ORC-1073]({{site.jira}}/ORC-1073) Remove appveyor.yml
- [ORC-1076]({{site.jira}}/ORC-1076) Remove Travis PR Builder Link from README.md
- [ORC-1079]({{site.jira}}/ORC-1079) Add Linux Clang 11 GitHub Action test coverage
- [ORC-1080]({{site.jira}}/ORC-1080) Remove .travis.yml
- [ORC-1084]({{site.jira}}/ORC-1084) Bump checkstyle from 9.2 to 9.2.1
- [ORC-1086]({{site.jira}}/ORC-1086) Bump reproducible-build-maven-plugin from 0.14 to 0.15
- [ORC-1090]({{site.jira}}/ORC-1090) Disable Clang 13.0-specific compilation warnings
- [ORC-1093]({{site.jira}}/ORC-1093) Remove debian8 specific code in run-one.sh
- [ORC-1096]({{site.jira}}/ORC-1096) Bump slf4j.version to 1.7.33
- [ORC-1103]({{site.jira}}/ORC-1103) Use Maven 3.8.4
- [ORC-1104]({{site.jira}}/ORC-1104) Use Spark 3.2.1 in benchmark
- [ORC-1105]({{site.jira}}/ORC-1105) fetch-data.sh should use zsh instead of bash
- [ORC-1106]({{site.jira}}/ORC-1106) Use transitive commons-lang3 dependency in bench module
- [ORC-1107]({{site.jira}}/ORC-1107) Fix NPE at benchmark data schema loading
- [ORC-1108]({{site.jira}}/ORC-1108) Use RawLocalFileSystem to skip checksum files during benchmark data generation
- [ORC-1109]({{site.jira}}/ORC-1109) Use zstd instead of none in the default compress option
- [ORC-1111]({{site.jira}}/ORC-1111) Bump build-helper-maven-plugin from 3.2.0 to 3.3.0
- [ORC-1113]({{site.jira}}/ORC-1113) Remove CentOS 8 from docker-based tests
- [ORC-1115]({{site.jira}}/ORC-1115) Suppress Illegal reflective access warnings on Java9+ Tests 
