/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatanodeCommandCountUpdatedHandler
implements EventHandler<DatanodeDetails> {
    private final ReplicationManager replicationManager;
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeCommandCountUpdatedHandler.class);

    public DatanodeCommandCountUpdatedHandler(ReplicationManager replicationManager) {
        this.replicationManager = replicationManager;
    }

    public void onMessage(DatanodeDetails datanodeDetails, EventPublisher publisher) {
        LOG.trace("DatanodeCommandCountUpdatedHandler called with datanode {}", (Object)datanodeDetails);
        this.replicationManager.datanodeCommandCountUpdated(datanodeDetails);
    }
}

