/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.replication.AbstractOverReplicationHandler;
import org.apache.hadoop.hdds.scm.container.replication.CommandTargetOverloadedException;
import org.apache.hadoop.hdds.scm.container.replication.ContainerHealthResult;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.container.replication.ECContainerReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECOverReplicationHandler
extends AbstractOverReplicationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ECOverReplicationHandler.class);
    private final ReplicationManager replicationManager;

    public ECOverReplicationHandler(PlacementPolicy placementPolicy, ReplicationManager replicationManager) {
        super(placementPolicy);
        this.replicationManager = replicationManager;
    }

    @Override
    public int processAndSendCommands(Set<ContainerReplica> replicas, List<ContainerReplicaOp> pendingOps, ContainerHealthResult result, int remainingMaintenanceRedundancy) throws NotLeaderException, CommandTargetOverloadedException {
        Set<ContainerReplica> healthyReplicas;
        ContainerInfo container = result.getContainerInfo();
        ECContainerReplicaCount replicaCount = new ECContainerReplicaCount(container, healthyReplicas = replicas.stream().filter(r -> {
            try {
                NodeStatus ns = this.replicationManager.getNodeStatus(r.getDatanodeDetails());
                return ns.isHealthy() && ns.getOperationalState() == HddsProtos.NodeOperationalState.IN_SERVICE;
            }
            catch (NodeNotFoundException e) {
                return false;
            }
        }).collect(Collectors.toSet()), pendingOps, remainingMaintenanceRedundancy);
        if (!replicaCount.isOverReplicated()) {
            LOG.info("The container {} state changed and it is no longer over replication. Replica count: {}, healthy replica count: {}", new Object[]{container.getContainerID(), replicas.size(), healthyReplicas.size()});
            return 0;
        }
        if (!replicaCount.isOverReplicated(true)) {
            LOG.info("The container {} with replicas {} will be corrected by the pending delete", (Object)container.getContainerID(), replicas);
            return 0;
        }
        List<Integer> overReplicatedIndexes = replicaCount.overReplicatedIndexes(true);
        if (overReplicatedIndexes.isEmpty()) {
            LOG.warn("The container {} with replicas {} was found over replicated by EcContainerReplicaCount, but there are no over replicated indexes returned", (Object)container.getContainerID(), replicas);
            return 0;
        }
        ArrayList<DatanodeDetails> deletionInFlight = new ArrayList<DatanodeDetails>();
        for (ContainerReplicaOp op : pendingOps) {
            if (op.getOpType() != ContainerReplicaOp.PendingOpType.DELETE) continue;
            deletionInFlight.add(op.getTarget());
        }
        Set<ContainerReplica> candidates = healthyReplicas.stream().filter(r -> !deletionInFlight.contains(r.getDatanodeDetails())).filter(r -> r.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED).collect(Collectors.toSet());
        Set<ContainerReplica> replicasToRemove = this.selectReplicasToRemove(candidates, 1);
        if (replicasToRemove.isEmpty()) {
            LOG.warn("The container {} is over replicated, but no replicas were selected to remove by the placement policy. Replicas: {}", (Object)container, replicas);
            return 0;
        }
        int commandsSent = 0;
        HashMap<Integer, Integer> replicaIndexCounts = new HashMap<Integer, Integer>();
        for (ContainerReplica r2 : candidates) {
            replicaIndexCounts.put(r2.getReplicaIndex(), replicaIndexCounts.getOrDefault(r2.getReplicaIndex(), 0) + 1);
        }
        CommandTargetOverloadedException firstException = null;
        for (ContainerReplica r3 : replicasToRemove) {
            int currentCount = replicaIndexCounts.getOrDefault(r3.getReplicaIndex(), 0);
            if (currentCount < 2) {
                LOG.warn("The replica {} selected to remove would reduce the count for that index to zero. Candidate Replicas: {}", (Object)r3, candidates);
                continue;
            }
            try {
                this.replicationManager.sendThrottledDeleteCommand(container, r3.getReplicaIndex(), r3.getDatanodeDetails(), true);
                replicaIndexCounts.put(r3.getReplicaIndex(), currentCount - 1);
                ++commandsSent;
            }
            catch (CommandTargetOverloadedException e) {
                LOG.debug("Unable to send delete command for container {} replica index {} to {}", new Object[]{container.getContainerID(), r3.getReplicaIndex(), r3.getDatanodeDetails()});
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (commandsSent == 0) {
            LOG.warn("With the current state of available replicas {}, no commands were created to remove excess replicas.", replicas);
        }
        if (firstException != null) {
            throw firstException;
        }
        return commandsSent;
    }
}

