/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.states;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hdds.protocol.DatanodeID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;

public class ContainerEntry {
    private final ContainerInfo info;
    private final Map<DatanodeID, ContainerReplica> replicas = new HashMap<DatanodeID, ContainerReplica>();

    ContainerEntry(ContainerInfo info) {
        this.info = info;
    }

    public ContainerInfo getInfo() {
        return this.info;
    }

    public Set<ContainerReplica> getReplicas() {
        return new HashSet<ContainerReplica>(this.replicas.values());
    }

    public ContainerReplica put(ContainerReplica r) {
        return this.replicas.put(r.getDatanodeDetails().getID(), r);
    }

    public ContainerReplica removeReplica(DatanodeID datanodeID) {
        return this.replicas.remove(datanodeID);
    }
}

