/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLog;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLogImpl;
import org.apache.hadoop.hdds.scm.ha.SCMHADBTransactionBuffer;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMHADBTransactionBufferImpl
implements SCMHADBTransactionBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(SCMHADBTransactionBufferImpl.class);
    private final StorageContainerManager scm;
    private SCMMetadataStore metadataStore;
    private BatchOperation currentBatchOperation;
    private TransactionInfo latestTrxInfo;
    private final AtomicReference<SnapshotInfo> latestSnapshot = new AtomicReference();
    private final AtomicLong txFlushPending = new AtomicLong(0L);
    private long lastSnapshotTimeMs = 0L;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();

    public SCMHADBTransactionBufferImpl(StorageContainerManager scm) throws IOException {
        this.scm = scm;
        this.init();
    }

    private BatchOperation getCurrentBatchOperation() {
        return this.currentBatchOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <KEY, VALUE> void addToBuffer(Table<KEY, VALUE> table, KEY key, VALUE value) throws IOException {
        this.rwLock.readLock().lock();
        try {
            this.txFlushPending.getAndIncrement();
            table.putWithBatch(this.getCurrentBatchOperation(), key, value);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public <KEY, VALUE> void removeFromBuffer(Table<KEY, VALUE> table, KEY key) throws IOException {
        this.rwLock.readLock().lock();
        try {
            this.txFlushPending.getAndIncrement();
            table.deleteWithBatch(this.getCurrentBatchOperation(), key);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public void updateLatestTrxInfo(TransactionInfo info) {
        if (info.compareTo(this.latestTrxInfo) <= 0) {
            throw new IllegalArgumentException("Updating DB buffer transaction info by an older transaction info, current: " + this.latestTrxInfo + ", updating to: " + info);
        }
        this.latestTrxInfo = info;
    }

    @Override
    public TransactionInfo getLatestTrxInfo() {
        return this.latestTrxInfo;
    }

    @Override
    public SnapshotInfo getLatestSnapshot() {
        return this.latestSnapshot.get();
    }

    @Override
    public void setLatestSnapshot(SnapshotInfo latestSnapshot) {
        LOG.info("{}: Set latest Snapshot to {}", (Object)this.scm.getScmHAManager().getRatisServer().getDivision().getId(), (Object)latestSnapshot);
        this.latestSnapshot.set(latestSnapshot);
    }

    @Override
    public AtomicReference<SnapshotInfo> getLatestSnapshotRef() {
        return this.latestSnapshot;
    }

    @Override
    public void flush() throws IOException {
        this.rwLock.writeLock().lock();
        try {
            Table transactionInfoTable = this.metadataStore.getTransactionInfoTable();
            transactionInfoTable.putWithBatch(this.currentBatchOperation, (Object)"#TRANSACTIONINFO", (Object)this.latestTrxInfo);
            this.metadataStore.getStore().commitBatchOperation(this.currentBatchOperation);
            this.currentBatchOperation.close();
            this.latestSnapshot.set(this.latestTrxInfo.toSnapshotInfo());
            this.currentBatchOperation = this.metadataStore.getStore().initBatchOperation();
            DeletedBlockLog deletedBlockLog = this.scm.getScmBlockManager().getDeletedBlockLog();
            Preconditions.checkArgument((boolean)(deletedBlockLog instanceof DeletedBlockLogImpl));
            ((DeletedBlockLogImpl)deletedBlockLog).onFlush();
        }
        finally {
            this.txFlushPending.set(0L);
            this.lastSnapshotTimeMs = this.scm.getSystemClock().millis();
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public void init() throws IOException {
        this.metadataStore = this.scm.getScmMetadataStore();
        this.rwLock.writeLock().lock();
        try {
            IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.currentBatchOperation});
            this.currentBatchOperation = this.metadataStore.getStore().initBatchOperation();
            this.latestTrxInfo = (TransactionInfo)this.metadataStore.getTransactionInfoTable().get((Object)"#TRANSACTIONINFO");
            if (this.latestTrxInfo == null) {
                this.latestTrxInfo = TransactionInfo.DEFAULT_VALUE;
            }
            this.latestSnapshot.set(this.latestTrxInfo.toSnapshotInfo());
        }
        finally {
            this.txFlushPending.set(0L);
            this.lastSnapshotTimeMs = this.scm.getSystemClock().millis();
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldFlush(long snapshotWaitTime) {
        this.rwLock.readLock().lock();
        try {
            long timeDiff = this.scm.getSystemClock().millis() - this.lastSnapshotTimeMs;
            boolean bl = this.txFlushPending.get() > 0L && timeDiff > snapshotWaitTime;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public String toString() {
        return this.latestTrxInfo.toString();
    }

    public void close() throws IOException {
        if (this.currentBatchOperation != null) {
            this.currentBatchOperation.close();
        }
    }
}

